/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import scouter.util.StringKeyLinkedMap;

public class DateTimeHelper {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_FIVE_MINUTE = 300000;
    public static final int MILLIS_PER_TEN_MINUTE = 600000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;
    static String[] wday = new String[]{"Mon", "Tue", "Wed", "Thr", "Fri", "Sat", "Sun"};
    static int[] mdayLen = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private long BASE_TIME;
    private Day[][][] table = new Day[100][][];
    private Day[] dateTable = new Day[40000];
    private static StringKeyLinkedMap<DateTimeHelper> _table = new StringKeyLinkedMap().setMax(5);

    private DateTimeHelper(TimeZone zone) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            sdf.setTimeZone(zone);
            this.BASE_TIME = sdf.parse("20000101").getTime();
            this.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getBaseTime() {
        return this.BASE_TIME;
    }

    private void open() throws Exception {
        long mtime = this.BASE_TIME;
        int seq = 0;
        int wdayIdx = 5;
        for (int year = 0; year < 100; ++year) {
            boolean isYun = DateTimeHelper.isYun(year);
            this.table[year] = new Day[12][];
            for (int mm = 0; mm < 12; ++mm) {
                int monLen = mdayLen[mm];
                if (mm == 1 && isYun) {
                    ++monLen;
                }
                this.table[year][mm] = new Day[monLen];
                for (int dd = 0; dd < monLen; ++dd) {
                    String yyyyMMdd = String.format("%d%02d%02d", year + 2000, mm + 1, dd + 1);
                    this.dateTable[seq] = new Day(yyyyMMdd, wday[wdayIdx], mtime);
                    this.table[year][mm][dd] = this.dateTable[seq];
                    wdayIdx = wdayIdx == 6 ? 0 : wdayIdx + 1;
                    ++seq;
                    mtime += 86400000L;
                }
            }
        }
    }

    static boolean isYun(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public long yyyymmdd(String yyyyMMdd) {
        int year = Integer.parseInt(yyyyMMdd.substring(0, 4));
        int mm = Integer.parseInt(yyyyMMdd.substring(4, 6));
        int dd = Integer.parseInt(yyyyMMdd.substring(6, 8));
        if (year >= 2100) {
            return this.table[99][11][30].time + 86400000L;
        }
        if (year < 2000) {
            return this.BASE_TIME;
        }
        return this.table[year - 2000][mm - 1][dd - 1].time;
    }

    public long hhmm(String date) {
        if (date == null) {
            return 0L;
        }
        int h = Integer.parseInt(date.substring(0, 2));
        int m = Integer.parseInt(date.substring(2, 4));
        return h * 3600000 + m * 60000;
    }

    public String getWeekDay(String yyyyMMdd) {
        int year = Integer.parseInt(yyyyMMdd.substring(0, 4));
        int mm = Integer.parseInt(yyyyMMdd.substring(4, 6));
        int dd = Integer.parseInt(yyyyMMdd.substring(6, 8));
        if (year >= 2100) {
            return this.table[99][11][30].wday;
        }
        if (year < 2000) {
            return this.table[0][0][0].wday;
        }
        return this.table[year - 2000][mm - 1][dd - 1].wday;
    }

    public String yyyymmdd(long time) {
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        if (idx < 0) {
            idx = 0;
        }
        return this.dateTable[idx].date;
    }

    public String datetime(long time) {
        if (time < this.BASE_TIME) {
            return "20000101 00:00:00";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date).append(" ");
        sb.append(this.mk2(hh)).append(":");
        sb.append(this.mk2(mm)).append(":");
        sb.append(this.mk2(ss));
        return sb.toString();
    }

    public String timestamp(long time) {
        if (time < this.BASE_TIME) {
            return "20000101 00:00:00.000";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        int sss = (int)(dtime % 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date).append(" ");
        sb.append(this.mk2(hh)).append(":");
        sb.append(this.mk2(mm)).append(":");
        sb.append(this.mk2(ss));
        sb.append(".").append(this.mk3(sss));
        return sb.toString();
    }

    private String mk2(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "0" + n;
            }
        }
        return Integer.toString(n);
    }

    private String mk3(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "00" + n;
            }
        }
        return n < 100 ? "0" + n : Integer.toString(n);
    }

    public String timestampFileName(long time) {
        if (time < this.BASE_TIME) {
            return "20000101_000000_000";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        int sss = (int)(dtime % 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date).append("_");
        sb.append(this.mk2(hh));
        sb.append(this.mk2(mm));
        sb.append(this.mk2(ss));
        sb.append("_").append(this.mk3(sss));
        return sb.toString();
    }

    public String ymdhms(long time) {
        if (time < this.BASE_TIME) {
            return "20000101000000";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date);
        sb.append(this.mk2(hh));
        sb.append(this.mk2(mm));
        sb.append(this.mk2(ss));
        return sb.toString();
    }

    public String logtime(long time) {
        if (time < this.BASE_TIME) {
            return "00:00:00.000";
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        int sss = (int)(dtime % 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.mk2(hh)).append(":");
        sb.append(this.mk2(mm)).append(":");
        sb.append(this.mk2(ss));
        sb.append(".").append(this.mk3(sss));
        return sb.toString();
    }

    public String hhmmss(long time) {
        if (time < this.BASE_TIME) {
            return "000000";
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        return String.format("%02d%02d%02d", hh, mm, ss);
    }

    public String hhmm(long time) {
        if (time < this.BASE_TIME) {
            return "0000";
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        return String.format("%02d%02d", hh, mm);
    }

    public int getDateMillis(long time) {
        if (time < this.BASE_TIME) {
            return 0;
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        return (int)dtime;
    }

    public int getHour(long time) {
        return this.getDateMillis(time) / 3600000;
    }

    public int getMM(long time) {
        int dtime = this.getDateMillis(time) % 3600000;
        return dtime / 60000;
    }

    public long getTimeUnit(long time) {
        return time - this.BASE_TIME;
    }

    public long getDateUnit(long time) {
        return (time - this.BASE_TIME) / 86400000L;
    }

    public long getTenMinUnit(long time) {
        return (time - this.BASE_TIME) / 600000L;
    }

    public long getMinUnit(long time) {
        return (time - this.BASE_TIME) / 60000L;
    }

    public long getHourUnit(long time) {
        return (time - this.BASE_TIME) / 3600000L;
    }

    public long reverseHourUnit(long unit) {
        return unit * 3600000L + this.BASE_TIME;
    }

    public long getDateUnit() {
        return this.getDateUnit(System.currentTimeMillis());
    }

    public static DateTimeHelper getDefault() {
        return DateTimeHelper.getDateTimeHelper(TimeZone.getDefault());
    }

    public static synchronized DateTimeHelper getDateTimeHelper(TimeZone timezone) {
        DateTimeHelper helper = _table.get(timezone.getID());
        if (helper == null) {
            helper = new DateTimeHelper(timezone);
            _table.put(timezone.getID(), helper);
        }
        return helper;
    }

    public long xxx() {
        return -946598400000L + this.BASE_TIME;
    }

    public long dateUnitToTimeMillis(long dateUnit) {
        return dateUnit * 86400000L + this.BASE_TIME;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new Timestamp(DateTimeHelper.getDefault().xxx()));
        System.out.println(DateTimeHelper.getDefault().yyyymmdd(0L));
        long m = System.currentTimeMillis();
        long yesterday = System.currentTimeMillis() - 86400000L;
        System.out.println(DateTimeHelper.getDefault().getDateUnit(m));
        System.out.println(DateTimeHelper.getDefault().getDateUnit(yesterday));
    }

    private static void c1(DateTimeHelper dh) throws ParseException {
        long t1 = new SimpleDateFormat("yyyyMMdd").parse("20000101").getTime();
        long t2 = dh.yyyymmdd("20000101");
        System.out.println(t1);
        System.out.println(t2);
    }

    private static void c2(DateTimeHelper dh) throws ParseException {
        long t1 = new SimpleDateFormat("yyyyMMddHHmm").parse("201502241212").getTime();
        long t2 = dh.yyyymmdd("20150224") + dh.hhmm("1212");
        System.out.println(t1);
        System.out.println(t2);
    }

    private static class Day {
        public final String date;
        public final String wday;
        public final long time;

        public Day(String date, String day, long time) {
            this.date = date;
            this.wday = day;
            this.time = time;
        }
    }
}

