/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.cli;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import io.jooby.cli.Context;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jline.reader.LineReader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CommandContextImpl
implements Context {
    private final LineReader reader;
    private final Handlebars templates;
    private final PrintWriter out;
    private final String version;
    private JSONObject configuration;
    private Properties versions;

    public CommandContextImpl(LineReader reader, String version) throws IOException {
        this.reader = reader;
        this.out = reader.getTerminal().writer();
        ClassPathTemplateLoader loader = new ClassPathTemplateLoader("/cli");
        this.templates = new Handlebars(loader);
        this.templates.setPrettyPrint(true);
        this.version = version;
        Path file = this.configurationPath();
        this.configuration = Files.exists(file, new LinkOption[0]) ? new JSONObject(new JSONTokener(Files.newBufferedReader(file))) : new JSONObject();
    }

    private Path configurationPath() {
        return Paths.get(System.getProperty("user.home"), ".jooby");
    }

    @Override
    @Nonnull
    public String getVersion() {
        return this.configuration.has("version") ? this.configuration.getString("version") : this.version;
    }

    @Override
    @Nonnull
    public Path getWorkspace() {
        return this.configuration.has("workspace") ? Paths.get(this.configuration.getString("workspace"), new String[0]) : Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    @Override
    public void setWorkspace(@Nonnull Path workspace) throws IOException {
        if (!Files.isDirectory(workspace, new LinkOption[0])) {
            throw new FileNotFoundException(workspace.toAbsolutePath().toString());
        }
        this.configuration.put("workspace", workspace.toAbsolutePath().toString());
        Files.write(this.configurationPath(), this.configuration.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public void exit(int code) {
        System.exit(code);
    }

    @Override
    public String readLine(String prompt) {
        return this.reader.readLine(prompt);
    }

    @Override
    public void println(String message) {
        this.out.println(message);
    }

    @Override
    public void writeTemplate(String template, Object model, Path file) throws IOException {
        Path parent = file.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (PrintWriter writer = new PrintWriter(file.toFile());){
            this.writeTemplate(template, model, writer);
        }
    }

    private void writeTemplate(String template, Object model, Writer writer) throws IOException {
        this.templates.compile(template).apply(model, writer);
    }

    @Override
    public void copyResource(String source, Path dest) throws IOException {
        this.copyResource(source, dest, Collections.emptySet());
    }

    @Override
    public void copyResource(String source, Path dest, Set<PosixFilePermission> permissions) throws IOException {
        Path parent = dest.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (InputStream in = this.getClass().getResourceAsStream(source);){
            Files.copy(in, dest, new CopyOption[0]);
        }
        if (permissions.size() > 0) {
            Files.setPosixFilePermissions(dest, permissions);
        }
    }

    @Override
    public Map<String, String> getDependencyMap() throws IOException {
        if (this.versions == null) {
            this.versions = new Properties();
            try (InputStream in = this.getClass().getResourceAsStream("/dependencies.properties");){
                this.versions.load(in);
            }
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.putAll(this.versions);
        return result;
    }
}

