/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.java.ao.RawEntity;
import net.java.ao.cache.MemoryRelationsCacheKey;
import net.java.ao.cache.MemoryRelationsCacheMetaCacheKey;
import net.java.ao.cache.RelationsCache;

final class MemoryRelationsCache
implements RelationsCache {
    private final Map<MemoryRelationsCacheKey, RawEntity<?>[]> cache = new HashMap<MemoryRelationsCacheKey, RawEntity<?>[]>();
    private final Multimap<Class<? extends RawEntity<?>>, MemoryRelationsCacheKey> typeMap = HashMultimap.create();
    private final Multimap<MemoryRelationsCacheMetaCacheKey, MemoryRelationsCacheKey> fieldMap = HashMultimap.create();

    MemoryRelationsCache() {
    }

    @Override
    public <T extends RawEntity<K>, K> T[] get(RawEntity<?> from, Class<T> toType, Class<? extends RawEntity<?>> throughType, String[] fields, String where) {
        return this.cache.get(new MemoryRelationsCacheKey(from, toType, throughType, fields, where));
    }

    @Override
    public void put(RawEntity<?> from, RawEntity<?>[] through, Class<? extends RawEntity<?>> throughType, RawEntity<?>[] to, Class<? extends RawEntity<?>> toType, String[] fields, String where) {
        MemoryRelationsCacheKey key = new MemoryRelationsCacheKey(from, toType, throughType, fields, where);
        this.cache.put(key, to);
        this.typeMap.put(key.getThroughType(), (Object)key);
        for (String field : fields) {
            for (RawEntity<?> entity : through) {
                this.fieldMap.put((Object)new MemoryRelationsCacheMetaCacheKey(entity, field), (Object)key);
            }
        }
    }

    @Override
    public void remove(Class<? extends RawEntity<?>> ... types) {
        for (Class<RawEntity<?>> clazz : types) {
            Collection keys = this.typeMap.get(clazz);
            if (keys == null) continue;
            for (MemoryRelationsCacheKey key : keys) {
                this.cache.remove(key);
            }
            this.typeMap.removeAll(clazz);
        }
    }

    @Override
    public void remove(RawEntity<?> entity, String[] fields) {
        for (String field : fields) {
            Collection keys = this.fieldMap.get((Object)new MemoryRelationsCacheMetaCacheKey(entity, field));
            if (keys == null) continue;
            for (MemoryRelationsCacheKey key : keys) {
                this.cache.remove(key);
            }
        }
    }

    @Override
    public void flush() {
        this.cache.clear();
        this.typeMap.clear();
        this.fieldMap.clear();
    }
}

