/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.RawEntity;
import net.java.ao.schema.Table;
import net.java.ao.schema.TableNameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableNameConverter
implements TableNameConverter {
    private Map<Class<? extends RawEntity<?>>, String> classMappings = new HashMap();
    private List<String> patterns = new LinkedList<String>();
    private Map<String, String> patternMappings = new HashMap<String, String>();

    protected AbstractTableNameConverter() {
    }

    public void addClassMapping(Class<? extends RawEntity<?>> clazz, String name) {
        this.classMappings.put(clazz, name);
    }

    public void addClassMappings(Map<Class<? extends RawEntity<?>>, String> mappings) {
        this.classMappings.putAll(mappings);
    }

    public void addPatternMapping(String pattern, String result) {
        this.patterns.add(0, pattern);
        this.patternMappings.put(pattern, result);
    }

    public void addPatternMappings(Map<String, String> mappings, Iterator<String> keys) {
        int i = 0;
        while (keys.hasNext()) {
            this.patterns.add(i++, keys.next());
        }
        this.patternMappings.putAll(mappings);
    }

    @Override
    public String getName(Class<? extends RawEntity<?>> entity) {
        Table tableAnnotation = entity.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            return tableAnnotation.value();
        }
        if (this.classMappings.containsKey(entity)) {
            return this.classMappings.get(entity);
        }
        return this.postProcessName(this.processName(this.convertName(entity)));
    }

    protected abstract String convertName(Class<? extends RawEntity<?>> var1);

    protected String processName(String back) {
        for (String regexp : this.patterns) {
            Pattern pattern = Pattern.compile("^" + regexp + "$", 2);
            Matcher matcher = pattern.matcher(back);
            if (!matcher.find()) continue;
            String mapResult = this.patternMappings.get(regexp);
            Pattern mapPattern = Pattern.compile("\\{\\d+\\}");
            Matcher mapMatcher = mapPattern.matcher(mapResult);
            while (mapMatcher.find()) {
                Matcher groupMatcher = Pattern.compile("\\{(\\d+)\\}").matcher(mapResult);
                groupMatcher.find();
                String toReplace = matcher.group(Integer.parseInt(groupMatcher.group(1)));
                mapResult = mapMatcher.replaceFirst(toReplace);
                mapMatcher = mapPattern.matcher(mapResult);
            }
            back = mapResult;
            break;
        }
        return back;
    }

    protected String postProcessName(String back) {
        return back;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

