/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public final class ConfigurationProperties {
    private static Properties props = null;

    public static String get(String key, String defaultValue) {
        String value = ConfigurationProperties.load().getProperty(key, defaultValue);
        if (value.startsWith("${")) {
            value = defaultValue;
        }
        return value;
    }

    private static Properties load() {
        if (props == null) {
            props = ConfigurationProperties.load(ConfigurationProperties.getFileName());
        }
        return props;
    }

    private static Properties load(String configFile) {
        Properties properties = new Properties();
        InputStream configFileStream = ConfigurationProperties.class.getResourceAsStream("/" + configFile);
        if (configFileStream != null) {
            try {
                properties.load(configFileStream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error loading properties from resource <" + configFile + ">", e);
            }
            finally {
                ConfigurationProperties.close(configFileStream);
            }
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    private static String getFileName() {
        return System.getProperty("test.file", "test.properties");
    }

    private static void close(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

