/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.util;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.NoteWithVolume;
import net.raphimc.noteblocklib.model.SongView;
import net.raphimc.noteblocklib.util.Instrument;

public class SongUtil {
    public static <N extends Note> void applyToAllNotes(SongView<N> songView, Consumer<N> noteConsumer) {
        songView.getNotes().values().stream().flatMap(Collection::stream).forEach(noteConsumer);
    }

    public static <N extends Note> void iterateAllNotes(SongView<N> songView, Predicate<N> notePredicate) {
        Note note;
        Iterator iterator = songView.getNotes().values().stream().flatMap(Collection::stream).collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && !notePredicate.test(note = (Note)iterator.next())) {
        }
    }

    public static <N extends Note> void removeNotesIf(SongView<N> songView, Predicate<N> notePredicate) {
        for (List<N> list : songView.getNotes().values()) {
            list.removeIf(notePredicate);
        }
    }

    public static <N extends Note> void removeDoubleNotes(SongView<N> songView) {
        for (List<N> list : songView.getNotes().values()) {
            HashSet<N> set = new HashSet<N>(list);
            list.clear();
            list.addAll(set);
        }
    }

    public static <N extends Note> void removeSilentNotes(SongView<N> songView) {
        SongUtil.removeSilentNotes(songView, 0.0f);
    }

    public static <N extends Note> void removeSilentNotes(SongView<N> songView, float threshold) {
        SongUtil.removeNotesIf(songView, note -> {
            if (note instanceof NoteWithVolume) {
                return ((NoteWithVolume)((Object)note)).getVolume() <= threshold;
            }
            return false;
        });
    }

    public static <N extends Note> Set<Instrument> getUsedVanillaInstruments(SongView<N> songView) {
        EnumSet<Instrument> usedInstruments = EnumSet.noneOf(Instrument.class);
        SongUtil.iterateAllNotes(songView, note -> {
            if (note.getInstrument() != null) {
                usedInstruments.add(note.getInstrument());
            }
            return false;
        });
        return usedInstruments;
    }

    public static <N extends Note> Set<NbsCustomInstrument> getUsedCustomInstruments(SongView<N> songView) {
        HashSet<NbsCustomInstrument> usedInstruments = new HashSet<NbsCustomInstrument>();
        SongUtil.iterateAllNotes(songView, note -> {
            if (note instanceof NbsNote && ((NbsNote)note).getCustomInstrument() != null) {
                usedInstruments.add(((NbsNote)note).getCustomInstrument());
            }
            return false;
        });
        return usedInstruments;
    }

    public static <N extends Note> long getNoteCount(SongView<N> songView) {
        return songView.getNotes().values().stream().mapToLong(List::size).sum();
    }
}

