/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.raphimc.noteblocklib.model.Note;

public class Notes {
    private final Map<Integer, List<Note>> notes = new HashMap<Integer, List<Note>>();
    private int lastTick;
    private boolean recomputeLastTick = true;

    public List<Note> get(int tick) {
        return this.notes.get(tick);
    }

    public List<Note> getOrEmpty(int tick) {
        return this.notes.getOrDefault(tick, new ArrayList());
    }

    public void set(int tick, List<Note> notes) {
        if (notes != null) {
            if (this.notes.put(tick, notes) == null) {
                this.recomputeLastTick = true;
            }
        } else if (this.notes.remove(tick) != null) {
            this.recomputeLastTick = true;
        }
    }

    public void add(int tick, Note note) {
        this.notes.computeIfAbsent(tick, k -> {
            this.recomputeLastTick = true;
            return new ArrayList();
        }).add(note);
    }

    public void add(int tick, List<Note> notes) {
        this.notes.computeIfAbsent(tick, k -> {
            this.recomputeLastTick = true;
            return new ArrayList();
        }).addAll(notes);
    }

    public Set<Integer> getTicks() {
        return Collections.unmodifiableSet(this.notes.keySet());
    }

    public void clearTick(int tick) {
        this.notes.remove(tick);
    }

    public void clear() {
        this.notes.clear();
    }

    public void forEach(Consumer<Note> noteConsumer) {
        this.notes.values().stream().flatMap(Collection::stream).forEach(noteConsumer);
    }

    public boolean testEach(Predicate<Note> notePredicate) {
        for (List<Note> list : this.notes.values()) {
            for (Note note : list) {
                if (!notePredicate.test(note)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeIf(Predicate<Note> notePredicate) {
        for (List<Note> list : this.notes.values()) {
            list.removeIf(notePredicate);
        }
        this.compact();
    }

    public void removeDoubleNotes() {
        for (List<Note> list : this.notes.values()) {
            HashSet<Note> set = new HashSet<Note>(list);
            list.clear();
            list.addAll(set);
        }
    }

    public void removeSilentNotes() {
        this.removeSilentNotes(0.0f);
    }

    public void removeSilentNotes(float threshold) {
        this.removeIf(note -> note.getVolume() <= threshold);
        this.compact();
    }

    public void compact() {
        this.notes.entrySet().removeIf((? super E entry) -> ((List)entry.getValue()).isEmpty());
        this.recomputeLastTick = true;
    }

    public int getLastTick() {
        if (this.recomputeLastTick) {
            this.compact();
            this.lastTick = this.notes.keySet().stream().max(Integer::compareTo).orElse(0);
            this.recomputeLastTick = false;
        }
        return this.lastTick;
    }

    public int getLengthInTicks() {
        return this.getLastTick() + 1;
    }

    public int getNoteCount() {
        return this.notes.values().stream().mapToInt(List::size).sum();
    }

    public Notes copy() {
        Notes copyNotes = new Notes();
        for (Map.Entry<Integer, List<Note>> entry : this.notes.entrySet()) {
            ArrayList<Note> noteList = new ArrayList<Note>();
            for (Note note : entry.getValue()) {
                noteList.add(note.copy());
            }
            copyNotes.notes.put(entry.getKey(), noteList);
        }
        return copyNotes;
    }
}

