/*
 * Decompiled with CFR 0.152.
 */
package org.algorithm_visualizer;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;

public abstract class Randomize {

    public static class Graph
    extends Randomizer {
        private int _N;
        private double _ratio;
        private Randomizer _randomizer;
        private boolean _directed;
        private boolean _weighted;

        @Override
        protected Class getType() {
            return null;
        }

        public Graph(int N, double ratio, Randomizer randomizer) {
            this._N = N;
            this._ratio = ratio;
            this._randomizer = randomizer;
            this._directed = true;
            this._weighted = false;
        }

        public Graph(int N, double ratio) {
            this(N, ratio, new Integer());
        }

        public Graph(int N) {
            this(N, 0.3);
        }

        public Graph() {
            this(5);
        }

        public Graph directed(boolean directed) {
            this._directed = directed;
            return this;
        }

        public Graph directed() {
            return this.directed(true);
        }

        public Graph weighted(boolean weighted) {
            this._weighted = weighted;
            return this;
        }

        public Graph weighted() {
            return this.weighted(true);
        }

        public Object[][] create() {
            Object[][] G = (Object[][])Array.newInstance(this._randomizer.getType(), this._N, this._N);
            for (int i = 0; i < this._N; ++i) {
                for (int j = 0; j < this._N; ++j) {
                    if (i == j) {
                        G[i][j] = 0;
                        continue;
                    }
                    if (this._directed || i < j) {
                        G[i][j] = random.nextDouble() < this._ratio ? (this._weighted ? this._randomizer.create() : java.lang.Integer.valueOf(1)) : java.lang.Integer.valueOf(0);
                        continue;
                    }
                    G[i][j] = G[j][i];
                }
            }
            return G;
        }
    }

    public static class Array1D
    extends Randomizer {
        private int _N;
        private Randomizer _randomizer;
        private boolean _sorted;

        @Override
        protected Class getType() {
            return null;
        }

        public Array1D(int N, Randomizer randomizer) {
            this._N = N;
            this._randomizer = randomizer;
            this._sorted = false;
        }

        public Array1D(int N) {
            this(N, new Integer());
        }

        public Array1D() {
            this(10);
        }

        public Array1D sorted(boolean sorted) {
            this._sorted = sorted;
            return this;
        }

        public Array1D sorted() {
            return this.sorted(true);
        }

        public Object[] create() {
            Object[] D = (Object[])Array.newInstance(this._randomizer.getType(), this._N);
            for (int i = 0; i < this._N; ++i) {
                D[i] = this._randomizer.create();
            }
            if (this._sorted) {
                Arrays.sort(D);
            }
            return D;
        }
    }

    public static class Array2D
    extends Randomizer {
        private int _N;
        private int _M;
        private Randomizer _randomizer;
        private boolean _sorted;

        @Override
        protected Class getType() {
            return null;
        }

        public Array2D(int N, int M, Randomizer randomizer) {
            this._N = N;
            this._M = M;
            this._randomizer = randomizer;
            this._sorted = false;
        }

        public Array2D(int N, int M) {
            this(N, M, new Integer());
        }

        public Array2D(int N) {
            this(N, 10);
        }

        public Array2D() {
            this(10);
        }

        public Array2D sorted(boolean sorted) {
            this._sorted = sorted;
            return this;
        }

        public Array2D sorted() {
            return this.sorted(true);
        }

        public Object[][] create() {
            Object[][] D = (Object[][])Array.newInstance(this._randomizer.getType(), this._N, this._M);
            for (int i = 0; i < this._N; ++i) {
                for (int j = 0; j < this._M; ++j) {
                    D[i][j] = this._randomizer.create();
                }
                if (!this._sorted) continue;
                Arrays.sort(D[i]);
            }
            return D;
        }
    }

    public static class String
    extends Randomizer {
        private int _length;
        private java.lang.String _letters;

        @Override
        protected Class getType() {
            return java.lang.String.class;
        }

        public String(int length, java.lang.String letters) {
            this._length = length;
            this._letters = letters;
        }

        public String(int length) {
            this(length, "abcdefghijklmnopqrstuvwxyz");
        }

        public String() {
            this(16);
        }

        @Override
        public java.lang.String create() {
            StringBuilder text = new StringBuilder();
            Integer randomizer = new Integer(0, this._letters.length() - 1);
            for (int i = 0; i < this._length; ++i) {
                text.append(this._letters.charAt(randomizer.create()));
            }
            return text.toString();
        }
    }

    public static class Double
    extends Randomizer {
        private double _min;
        private double _max;

        @Override
        protected Class getType() {
            return java.lang.Double.class;
        }

        public Double(double min, double max) {
            this._min = min;
            this._max = max;
        }

        public Double(double min) {
            this(min, 1.0);
        }

        public Double() {
            this(0.0);
        }

        @Override
        public java.lang.Double create() {
            return random.nextDouble() * (this._max - this._min) + this._min;
        }
    }

    public static class Integer
    extends Randomizer {
        private int _min;
        private int _max;

        @Override
        protected Class getType() {
            return java.lang.Integer.class;
        }

        public Integer(int min, int max) {
            this._min = min;
            this._max = max;
        }

        public Integer(int min) {
            this(min, 9);
        }

        public Integer() {
            this(1);
        }

        @Override
        public java.lang.Integer create() {
            return random.nextInt(this._max - this._min + 1) + this._min;
        }
    }

    private static abstract class Randomizer {
        protected static Random random = new Random();

        private Randomizer() {
        }

        protected abstract Class getType();

        public abstract Object create();
    }
}

