/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.asteriskjava.fastagi.reply.AgiReply;

public class SpeechRecognitionResult
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final AgiReply agiReply;

    public SpeechRecognitionResult(AgiReply agiReply) {
        this.agiReply = agiReply;
    }

    public boolean isDtmf() {
        return "digit".equals(this.agiReply.getExtra());
    }

    public boolean isSpeech() {
        return "speech".equals(this.agiReply.getExtra());
    }

    public boolean isTimeout() {
        return "timeout".equals(this.agiReply.getExtra());
    }

    public char getDigit() {
        String digit = this.agiReply.getAttribute("digit");
        if (digit == null || digit.length() == 0) {
            return '\u0000';
        }
        return digit.charAt(0);
    }

    public int getEndpos() {
        return Integer.parseInt(this.agiReply.getAttribute("endpos"));
    }

    public int getScore() {
        String score0 = this.agiReply.getAttribute("score0");
        return score0 == null ? 0 : Integer.parseInt(score0);
    }

    public String getText() {
        return this.agiReply.getAttribute("text0");
    }

    public String getGrammar() {
        return this.agiReply.getAttribute("grammar0");
    }

    public int getNumberOfResults() {
        String numberOfResults = this.agiReply.getAttribute("results");
        return numberOfResults == null ? 0 : Integer.parseInt(numberOfResults);
    }

    public List<SpeechResult> getAllResults() {
        int numberOfResults = this.getNumberOfResults();
        ArrayList<SpeechResult> results = new ArrayList<SpeechResult>(numberOfResults);
        for (int i = 0; i < numberOfResults; ++i) {
            SpeechResult result = new SpeechResult(Integer.parseInt(this.agiReply.getAttribute("score" + i)), this.agiReply.getAttribute("text" + i), this.agiReply.getAttribute("grammar" + i));
            results.add(result);
        }
        return results;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SpeechRecognitionResult[");
        if (this.isDtmf()) {
            sb.append("dtmf=true,");
            sb.append("digit=").append(this.getDigit()).append(",");
        }
        if (this.isSpeech()) {
            sb.append("speech=true,");
            sb.append("score=").append(this.getScore()).append(",");
            sb.append("text='").append(this.getText()).append("',");
            sb.append("grammar='").append(this.getGrammar()).append("',");
        }
        if (this.isTimeout()) {
            sb.append("timeout=true,");
        }
        if (this.getNumberOfResults() > 1) {
            sb.append("numberOfResults=").append(this.getNumberOfResults()).append(",");
            sb.append("allResults=").append(this.getAllResults()).append(",");
        }
        sb.append("endpos=").append(this.getEndpos()).append("]");
        return sb.toString();
    }

    public static class SpeechResult
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final int score;
        private final String text;
        private final String grammar;

        private SpeechResult(int score, String text, String grammar) {
            this.score = score;
            this.text = text;
            this.grammar = grammar;
        }

        public int getScore() {
            return this.score;
        }

        public String getText() {
            return this.text;
        }

        public String getGrammar() {
            return this.grammar;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append("score=").append(this.score).append(",");
            sb.append("text='").append(this.text).append("',");
            sb.append("grammar='").append(this.grammar).append("']");
            return sb.toString();
        }
    }
}

