/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.NewChannelListener;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.GetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.actions.OriginateAction;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.OriginateResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.pbx.internal.managerAPI.OriginateResult;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class OriginateBaseClass
extends EventListenerBaseClass {
    public static final String NJR_ORIGINATE_ID = "njrOriginateID";
    protected static final Log logger = LogFactory.getLog(OriginateBaseClass.class);
    private volatile String originateID;
    private volatile boolean originateSuccess;
    private final Channel monitorChannel1;
    private boolean hungup = false;
    private Channel newChannel;
    private final Channel monitorChannel2;
    private final OriginateResult result;
    Exception ex = new Exception("Created here");
    private boolean originateSeen = false;
    private boolean channelSeen = false;
    private final NewChannelListener listener;
    private final CountDownLatch originateLatch = new CountDownLatch(1);
    private final AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
    private static final Object sync = new Object();
    private static final Map<String, Worker> channelToWorkerLruMap = new LinkedHashMap<String, Worker>();
    private static final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(10);

    protected OriginateBaseClass(NewChannelListener listener, Channel monitor, Channel monitor2) {
        super("NewOrginateClass", PBXFactory.getActivePBX());
        this.listener = listener;
        this.monitorChannel1 = monitor;
        this.monitorChannel2 = monitor2;
        this.result = new OriginateResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OriginateResult originate(EndPoint local, EndPoint target, HashMap<String, String> myVars, CallerID callerID, Integer timeout, boolean hideCallerId, String context) {
        logger.debug("originate called");
        this.originateSeen = false;
        this.channelSeen = false;
        if (this.hungup) {
            return null;
        }
        logger.debug("originate connection endPoint \n" + local + " to endPoint " + target + " vars " + myVars);
        ManagerResponse response = null;
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        OriginateAction originate = new OriginateAction();
        this.originateID = originate.getActionId();
        myVars.put("__njrOriginateID", this.originateID);
        Integer localTimeout = timeout;
        if (timeout == null) {
            localTimeout = 30000;
            try {
                localTimeout = settings.getDialTimeout() * 1000;
            }
            catch (Exception e) {
                logger.error("Invalid dial timeout value");
            }
        }
        if (local.isLocal()) {
            originate.setEndPoint(local);
            originate.setOption("/n");
        } else {
            originate.setEndPoint(local);
        }
        originate.setContext(context);
        originate.setExten(target);
        originate.setPriority(1);
        if (hideCallerId) {
            originate.setCallingPres(32);
        } else {
            originate.setCallerId(callerID);
        }
        originate.setVariables(myVars);
        originate.setAsync(true);
        originate.setTimeout(localTimeout.intValue());
        try {
            this.startListener();
            response = this.pbx.sendAction(originate, localTimeout);
            logger.debug("Originate.sendAction completed");
            if (response.getResponse().compareToIgnoreCase("Success") != 0) {
                logger.error("Error Originating call" + originate.toString() + " : " + response.getMessage());
                throw new ManagerCommunicationException(response.getMessage(), null);
            }
            this.originateLatch.await(localTimeout + 1000, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug(e, e);
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        finally {
            this.close();
        }
        if (this.originateSuccess) {
            this.result.setSuccess(true);
            this.result.setChannelData(this.newChannel);
            logger.debug("new channel ok: " + this.newChannel);
        } else {
            logger.warn("originate failed connecting endPoint: " + local + " to ext " + target);
            if (this.newChannel != null) {
                try {
                    logger.info("Hanging up");
                    this.pbx.hangup(this.newChannel);
                }
                catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                    logger.error(e, e);
                }
            }
        }
        return this.result;
    }

    void abort(String reason) {
        logger.debug("Aborting originate ");
        this.originateSuccess = false;
        this.result.setAbortReason(reason);
        this.hungup = true;
        if (this.newChannel != null) {
            logger.warn("Aborted, Hangup up on the way out");
            this.result.setChannelHungup(true);
            PBX pbx = PBXFactory.getActivePBX();
            try {
                pbx.hangup(this.newChannel);
            }
            catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                logger.error(e, e);
            }
        }
        this.originateLatch.countDown();
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(OriginateResponseEvent.class);
        required.add(BridgeEvent.class);
        required.add(LinkEvent.class);
        required.add(UnlinkEvent.class);
        required.add(HangupEvent.class);
        required.add(NewChannelEvent.class);
        return required;
    }

    @Override
    public synchronized void onManagerEvent(ManagerEvent event) {
        Channel channel;
        if (event instanceof HangupEvent) {
            PBX pbx;
            HangupEvent hangupEvt = (HangupEvent)event;
            Channel hangupChannel = hangupEvt.getChannel();
            if (this.newChannel != null && hangupChannel.isSame(this.newChannel)) {
                this.originateSuccess = false;
                logger.warn("Dest channel " + this.newChannel + " hungup after answer");
                this.originateLatch.countDown();
            }
            if (this.monitorChannel1 != null && hangupChannel.isSame(this.monitorChannel1)) {
                this.originateSuccess = false;
                this.hungup = true;
                if (this.newChannel != null) {
                    logger.debug("hanging up " + this.newChannel);
                    this.result.setChannelHungup(true);
                    pbx = PBXFactory.getActivePBX();
                    try {
                        logger.warn("Hanging up");
                        pbx.hangup(this.newChannel);
                    }
                    catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                        logger.error(e, e);
                    }
                }
                logger.debug("notify channel 1 hungup");
                this.originateLatch.countDown();
            }
            if (this.monitorChannel2 != null && hangupChannel.isSame(this.monitorChannel2)) {
                this.originateSuccess = false;
                this.hungup = true;
                if (this.newChannel != null) {
                    logger.debug("Hanging up channel " + this.newChannel);
                    this.result.setChannelHungup(true);
                    pbx = PBXFactory.getActivePBX();
                    try {
                        pbx.hangup(this.newChannel);
                    }
                    catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                        logger.error(e, e);
                    }
                }
                logger.debug("Notify channel 2 (" + this.monitorChannel2 + ") hungup");
                this.originateLatch.countDown();
            }
        }
        if (event instanceof OriginateResponseEvent) {
            logger.debug("response : " + this.newChannel);
            OriginateResponseEvent response = (OriginateResponseEvent)event;
            logger.debug("OriginateResponseEvent: channel=" + (response.isChannel() ? response.getChannel() : response.getEndPoint()) + " originateID:" + this.originateID);
            logger.debug("{" + response.getReason() + ":" + response.getResponse() + "}");
            if (this.originateID != null) {
                if (this.originateID.compareToIgnoreCase(response.getActionId()) == 0) {
                    this.originateSuccess = response.isSuccess();
                    logger.debug("OriginateResponse: matched actionId, success=" + this.originateSuccess + " channelSeen=" + this.channelSeen);
                    this.originateSeen = true;
                    if (this.originateSuccess) {
                        this.newChannel = response.getChannel();
                        boolean bl = this.channelSeen = this.newChannel != null;
                        if (this.channelSeen) {
                            logger.debug("notify originate response event 305 " + this.originateSuccess);
                            this.originateLatch.countDown();
                        } else {
                            logger.error("Originate Response didn't contain the channel");
                        }
                    }
                }
            } else {
                logger.warn("actionid is null");
            }
        }
        if (event instanceof NewChannelEvent) {
            NewChannelEvent newState = (NewChannelEvent)event;
            channel = newState.getChannel();
            logger.debug("new channel event :" + channel + " context = " + newState.getContext() + " state =" + newState.getChannelStateDesc() + " state =" + (Object)((Object)newState.getChannelState()));
            this.getChannelsOriginateId(channel);
        }
        if (event instanceof BridgeEvent && ((BridgeEvent)event).isLink()) {
            BridgeEvent bridgeEvent = (BridgeEvent)event;
            channel = bridgeEvent.getChannel1();
            if (bridgeEvent.getChannel1().isLocal()) {
                channel = bridgeEvent.getChannel2();
            }
            logger.debug("new bridge event :" + channel + " channel1 = " + bridgeEvent.getChannel1() + " channel2 =" + bridgeEvent.getChannel2());
            this.getChannelsOriginateId(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getChannelsOriginateId(final Channel channel) {
        Worker worker;
        Object object = sync;
        synchronized (object) {
            worker = channelToWorkerLruMap.remove(channel.getChannelName());
            if (worker == null) {
                worker = new Worker(channel);
            }
            channelToWorkerLruMap.put(channel.getChannelName(), worker);
            if (channelToWorkerLruMap.size() > 500) {
                String keyToRemove = channelToWorkerLruMap.keySet().iterator().next();
                channelToWorkerLruMap.remove(keyToRemove);
                logger.info("Removing future for " + keyToRemove + " when handling " + channel + " cache size is " + channelToWorkerLruMap.size());
            }
        }
        worker.addListener(new WorkerCallback(){
            boolean done = false;
            private final Object workerCallbackSync = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleResult(String workResult) {
                Object object = this.workerCallbackSync;
                synchronized (object) {
                    if (!this.done) {
                        OriginateBaseClass.this.handleId(channel, workResult);
                        this.done = true;
                    } else {
                        logger.error("This should never happen, handle result called twice " + channel);
                    }
                }
            }
        });
    }

    Runnable getTimelinessChecker(long expectedMs, final Runnable task) {
        final long expected = System.currentTimeMillis() + expectedMs + 100L;
        return new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() > expected) {
                    logger.error("Timeliness problem, task is late by " + (System.currentTimeMillis() - expected) + "ms");
                }
                task.run();
            }
        };
    }

    private String internalGetChannelOriginateId(Channel channel) throws IllegalArgumentException, IllegalStateException, IOException, TimeoutException {
        logger.info("trying to get id from asterisk");
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        GetVarAction var = new GetVarAction(channel, NJR_ORIGINATE_ID);
        ManagerResponse response = pbx.sendAction(var, 500);
        if (response.isSuccess()) {
            String __originateID = response.getAttribute("value");
            if (__originateID != null && __originateID.length() > 0) {
                logger.info("Got id of " + __originateID);
                return __originateID;
            }
            return null;
        }
        logger.warn("Giving up because: " + response.getResponse());
        return "";
    }

    private void handleId(Channel channel, String __originateID) {
        if (__originateID != null && this.originateID != null && __originateID.compareToIgnoreCase(this.originateID) == 0) {
            if (this.newChannel == null && !channel.isLocal()) {
                this.newChannel = channel;
                this.channelSeen = true;
                logger.debug("new channel name " + channel);
                if (this.listener != null) {
                    this.listener.channelUpdate(channel);
                }
                if (this.originateSeen) {
                    logger.debug("notifying success 362");
                    this.originateLatch.countDown();
                }
            }
            logger.debug("Id is " + __originateID);
        }
    }

    class Worker
    implements Runnable {
        List<WorkerCallback> listeners = new LinkedList<WorkerCallback>();
        private final Channel channel;
        int ctr = 0;
        private final Object workerSync = new Object();
        String channelsOriginateId = null;

        Worker(Channel channel) {
            this.channel = channel;
            scheduler.execute(OriginateBaseClass.this.getTimelinessChecker(0L, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(final WorkerCallback listener) {
            Object object = this.workerSync;
            synchronized (object) {
                if (this.channelsOriginateId != null) {
                    scheduler.execute(OriginateBaseClass.this.getTimelinessChecker(0L, new Runnable(){

                        @Override
                        public void run() {
                            listener.handleResult(Worker.this.channelsOriginateId);
                        }
                    }));
                } else {
                    this.listeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String tmp = OriginateBaseClass.this.internalGetChannelOriginateId(this.channel);
                Object object = this.workerSync;
                synchronized (object) {
                    boolean moreTriesRemain;
                    this.channelsOriginateId = tmp;
                    boolean bl = moreTriesRemain = this.ctr++ < 5;
                    if (this.channelsOriginateId == null) {
                        if (moreTriesRemain) {
                            logger.warn("Rescheduling checkBridge for " + this.channel + ", looking for originateID:" + OriginateBaseClass.this.originateID);
                            scheduler.schedule(OriginateBaseClass.this.getTimelinessChecker(100L, this), 100L, TimeUnit.MILLISECONDS);
                        } else {
                            this.channelsOriginateId = "";
                        }
                    }
                    if (this.channelsOriginateId != null) {
                        for (WorkerCallback listener : this.listeners) {
                            listener.handleResult(this.channelsOriginateId);
                        }
                        this.listeners.clear();
                    }
                }
            }
            catch (Exception e) {
                logger.error(e, e);
            }
        }
    }

    public static interface WorkerCallback {
        public void handleResult(String var1);
    }
}

