/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.CountDelegate;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.ObjectExtJavaValue;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.ClassConstExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.StringLiteralExpr;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.InstanceInitializer;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusClass {
    private static final L10N L = new L10N(QuercusClass.class);
    private static final Logger log = Logger.getLogger(QuercusClass.class.getName());
    private final JavaClassDef _javaClassDef;
    private final ClassDef _classDef;
    private final String _className;
    private QuercusClass _parent;
    private boolean _isJavaWrapper;
    private ClassDef[] _classDefList;
    private AbstractFunction _constructor;
    private AbstractFunction _destructor;
    private AbstractFunction _fieldGet;
    private AbstractFunction _fieldSet;
    private AbstractFunction _call;
    private ArrayDelegate _arrayDelegate;
    private TraversableDelegate _traversableDelegate;
    private CountDelegate _countDelegate;
    private final ArrayList<InstanceInitializer> _initializers;
    private final ArrayList<StringValue> _fieldNames;
    private final IntMap _fieldMap;
    private final HashMap<StringValue, Expr> _fieldInitMap;
    private final MethodMap<AbstractFunction> _methodMap;
    private final HashMap<String, Expr> _constMap;
    private final HashMap<String, ArrayList<StaticField>> _staticFieldExprMap;
    private HashMap<String, Value> _staticFieldMap;

    public QuercusClass(ClassDef classDef, QuercusClass parent) {
        this(ModuleContext.getLocalContext(Thread.currentThread().getContextClassLoader()), classDef, parent);
    }

    public QuercusClass(ModuleContext moduleContext, ClassDef classDef, QuercusClass parent) {
        ClassDef[] classDefList;
        this._classDef = classDef;
        this._className = classDef.getName();
        this._parent = parent;
        this._initializers = new ArrayList();
        this._fieldNames = new ArrayList();
        this._fieldMap = new IntMap(16);
        this._fieldInitMap = new HashMap();
        this._methodMap = new MethodMap();
        this._constMap = new HashMap();
        this._staticFieldExprMap = new LinkedHashMap<String, ArrayList<StaticField>>();
        JavaClassDef javaClassDef = null;
        if (classDef instanceof JavaClassDef) {
            javaClassDef = (JavaClassDef)classDef;
            this._isJavaWrapper = !javaClassDef.isDelegate();
        }
        for (QuercusClass cls = parent; cls != null; cls = cls.getParent()) {
            AbstractFunction cons = cls.getConstructor();
            if (cons == null) continue;
            this.addMethod(cls.getName(), cons);
        }
        if (this._parent != null) {
            classDefList = new ClassDef[parent._classDefList.length + 1];
            System.arraycopy(parent._classDefList, 0, classDefList, 1, parent._classDefList.length);
            classDefList[0] = classDef;
        } else {
            classDefList = new ClassDef[]{classDef};
        }
        this._classDefList = classDefList;
        for (int i = 0; i < classDefList.length; ++i) {
            if (!(classDefList[i] instanceof JavaClassDef)) continue;
            javaClassDef = (JavaClassDef)classDefList[i];
        }
        this._javaClassDef = javaClassDef;
        HashSet<String> ifaces = new HashSet<String>();
        for (int i = classDefList.length - 1; i >= 0; --i) {
            classDef = classDefList[i];
            if (classDef == null) {
                throw new NullPointerException("classDef:" + this._classDef + " i:" + i + " parent:" + parent);
            }
            classDef.init();
            for (String iface : classDef.getInterfaces()) {
                QuercusClass cl = Env.getInstance().findClass(iface);
                if (cl == null) {
                    throw new QuercusRuntimeException(L.l("cannot find interface {0}", (Object)iface));
                }
                ClassDef ifaceDef = cl.getClassDef();
                if (ifaceDef == null || !ifaces.add(iface)) continue;
                ifaceDef.initClass(this);
            }
            classDef.initClass(this);
        }
        if (this._constructor == null && parent != null) {
            this._constructor = parent.getConstructor();
        }
        if (this._constructor != null && !this._constructor.getName().equals("__construct")) {
            this.addMethodIfNotExist(this._className, this._constructor);
        }
        if (this._destructor == null && parent != null) {
            this._destructor = parent.getDestructor();
        }
    }

    public QuercusClass(QuercusClass cacheClass, QuercusClass parent) {
        this._javaClassDef = cacheClass._javaClassDef;
        this._classDef = cacheClass._classDef;
        this._className = cacheClass._className;
        this._isJavaWrapper = cacheClass._isJavaWrapper;
        this._classDefList = cacheClass._classDefList;
        this._parent = parent;
        this._constructor = cacheClass._constructor;
        this._destructor = cacheClass._destructor;
        this._fieldGet = cacheClass._fieldGet;
        this._fieldSet = cacheClass._fieldSet;
        this._call = cacheClass._call;
        this._arrayDelegate = cacheClass._arrayDelegate;
        this._traversableDelegate = cacheClass._traversableDelegate;
        this._countDelegate = cacheClass._countDelegate;
        this._initializers = cacheClass._initializers;
        this._fieldNames = cacheClass._fieldNames;
        this._fieldMap = cacheClass._fieldMap;
        this._fieldInitMap = cacheClass._fieldInitMap;
        this._methodMap = cacheClass._methodMap;
        this._constMap = cacheClass._constMap;
        this._staticFieldExprMap = cacheClass._staticFieldExprMap;
    }

    public ClassDef getClassDef() {
        return this._classDef;
    }

    public JavaClassDef getJavaClassDef() {
        return this._javaClassDef;
    }

    public MethodMap<AbstractFunction> getMethodMap() {
        return this._methodMap;
    }

    public String getName() {
        return this._className;
    }

    public QuercusClass getParent() {
        return this._parent;
    }

    public ClassDef[] getClassDefList() {
        return this._classDefList;
    }

    public String getExtension() {
        return this._classDef.getExtension();
    }

    public boolean isInterface() {
        return this._classDef.isInterface();
    }

    public boolean isAbstract() {
        return this._classDef.isAbstract();
    }

    public boolean isFinal() {
        return this._classDef.isFinal();
    }

    public void setConstructor(AbstractFunction fun) {
        this._constructor = fun;
    }

    public AbstractFunction getConstructor() {
        return this._constructor;
    }

    public void setDestructor(AbstractFunction fun) {
        this._destructor = fun;
    }

    public AbstractFunction getDestructor() {
        return this._destructor;
    }

    public void setArrayDelegate(ArrayDelegate delegate) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} adding array delegate {1}", (Object)this, (Object)delegate));
        }
        this._arrayDelegate = delegate;
    }

    public final ArrayDelegate getArrayDelegate() {
        return this._arrayDelegate;
    }

    public void setTraversableDelegate(TraversableDelegate delegate) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} setting traversable delegate {1}", (Object)this, (Object)delegate));
        }
        this._traversableDelegate = delegate;
    }

    public final TraversableDelegate getTraversableDelegate() {
        return this._traversableDelegate;
    }

    public void setCountDelegate(CountDelegate delegate) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} setting count delegate {1}", (Object)this, (Object)delegate));
        }
        this._countDelegate = delegate;
    }

    public final CountDelegate getCountDelegate() {
        return this._countDelegate;
    }

    public void setFieldGet(AbstractFunction fun) {
        this._fieldGet = fun;
    }

    public AbstractFunction getFieldGet() {
        return this._fieldGet;
    }

    public void setFieldSet(AbstractFunction fun) {
        this._fieldSet = fun;
    }

    public AbstractFunction getFieldSet() {
        return this._fieldSet;
    }

    public void setCall(AbstractFunction fun) {
        this._call = fun;
    }

    public AbstractFunction getCall() {
        return this._call;
    }

    public void addInitializer(InstanceInitializer init) {
        this._initializers.add(init);
    }

    public void addField(StringValue name, int index, Expr initExpr, FieldVisibility visibility) {
        this._fieldNames.add(name);
        this._fieldMap.put((Object)name, index);
        this._fieldInitMap.put(name, initExpr);
    }

    public int addFieldIndex(StringValue name) {
        int index = this._fieldMap.get((Object)name);
        if (index >= 0) {
            return index;
        }
        index = this._fieldNames.size();
        this._fieldMap.put((Object)name, index);
        this._fieldNames.add(name);
        return index;
    }

    public HashMap<StringValue, Expr> getClassVars() {
        return this._fieldInitMap;
    }

    public Iterable<AbstractFunction> getClassMethods() {
        return this._methodMap.values();
    }

    public void addMethod(String name, AbstractFunction fun) {
        AbstractFunction existingFun = this._methodMap.get(name);
        if (existingFun == null || !fun.isAbstract()) {
            this._methodMap.put(name, fun);
        }
    }

    public void addMethodIfNotExist(String name, AbstractFunction fun) {
        AbstractFunction existingFun = this._methodMap.get(name);
        if (existingFun == null && !fun.isAbstract()) {
            this._methodMap.put(name, fun);
        }
    }

    public void addStaticFieldExpr(String className, String name, Expr value) {
        ArrayList<StaticField> fieldList = this._staticFieldExprMap.get(className);
        if (fieldList == null) {
            fieldList = new ArrayList();
            this._staticFieldExprMap.put(className, fieldList);
        }
        fieldList.add(new StaticField(name, value));
    }

    public void addConstant(String name, Expr expr) {
        this._constMap.put(name, expr);
    }

    public int getFieldSize() {
        return this._fieldNames.size();
    }

    public int findFieldIndex(StringValue name) {
        return this._fieldMap.get((Object)name);
    }

    public ArrayList<StringValue> getFieldNames() {
        return this._fieldNames;
    }

    public void validate(Env env) {
        if (!this._classDef.isAbstract() && !this._classDef.isInterface()) {
            for (AbstractFunction fun : this._methodMap.values()) {
                boolean isAbstract = this._constructor != null && fun.getName().equals(this._constructor.getName()) ? this._constructor.isAbstract() : fun.isAbstract();
                if (!isAbstract) continue;
                throw env.createErrorException(this._classDef.getLocation(), L.l("Abstract function '{0}' must be implemented in concrete class {1}.", (Object)fun.getName(), (Object)this.getName()));
            }
        }
    }

    public void init(Env env) {
        if (this._staticFieldExprMap.size() == 0) {
            return;
        }
        this._staticFieldMap = new LinkedHashMap<String, Value>();
        for (Map.Entry<String, ArrayList<StaticField>> map : this._staticFieldExprMap.entrySet()) {
            if (env.isInitializedClass(map.getKey())) continue;
            for (StaticField field : map.getValue()) {
                Expr expr = field._expr;
                Value val = expr instanceof ClassConstExpr ? ((ClassConstExpr)expr).eval(env) : expr.eval(env);
                this._staticFieldMap.put(field._name, val);
            }
            env.addInitializedClass(map.getKey());
        }
    }

    public Var getStaticField(Env env, String name) {
        Value value = this._staticFieldMap != null ? this._staticFieldMap.get(name) : null;
        if (value != null) {
            String fullName = this._className + "::" + name;
            Var var = env.getGlobalRaw(fullName);
            if (var == null) {
                var = env.getGlobalVar(fullName);
                var.set(value);
            }
            return var;
        }
        QuercusClass parent = this.getParent();
        if (parent != null) {
            return parent.getStaticField(env, name);
        }
        return null;
    }

    public HashMap<String, Value> getStaticFieldMap() {
        return this._staticFieldMap;
    }

    public Value createObject(Env env) {
        if (this._classDef.isAbstract()) {
            throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", (Object)this._className));
        }
        if (this._classDef.isInterface()) {
            throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", (Object)this._className));
        }
        ObjectValue objectValue = null;
        if (this._isJavaWrapper) {
            return this._javaClassDef.callNew(env, Value.NULL_ARGS);
        }
        if (this._javaClassDef != null && this._javaClassDef.isDelegate()) {
            objectValue = new ObjectExtValue(this);
        } else if (this._javaClassDef != null && !this._javaClassDef.isDelegate()) {
            Value javaWrapper = this._javaClassDef.callNew(env, Value.NULL_ARGS);
            Object object = javaWrapper.toJavaObject();
            objectValue = new ObjectExtJavaValue(this, object, this._javaClassDef);
        } else {
            objectValue = this._classDef.createObject(env, this);
        }
        this.initObject(env, objectValue);
        return objectValue;
    }

    public void initObject(Env env, ObjectValue obj) {
        for (int i = 0; i < this._initializers.size(); ++i) {
            this._initializers.get(i).initInstance(env, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callNew(Env env, Value[] args) {
        QuercusClass oldCallingClass = env.setCallingClass(this);
        try {
            if (this._classDef.isAbstract()) {
                throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", (Object)this._className));
            }
            if (this._classDef.isInterface()) {
                throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", (Object)this._className));
            }
            ObjectValue objectValue = null;
            if (this._isJavaWrapper) {
                Value value = this._javaClassDef.callNew(env, args);
                return value;
            }
            if (this._javaClassDef != null && this._javaClassDef.isDelegate()) {
                objectValue = new ObjectExtValue(this);
            } else if (this._javaClassDef != null && !this._javaClassDef.isDelegate()) {
                Value javaWrapper = this._javaClassDef.callNew(env, args);
                Object object = javaWrapper.toJavaObject();
                objectValue = new ObjectExtJavaValue(this, object, this._javaClassDef);
            } else {
                objectValue = this._classDef.newInstance(env, this);
            }
            this.initObject(env, objectValue);
            AbstractFunction fun = this.findConstructor();
            if (fun != null) {
                fun.callMethod(env, (Value)objectValue, args);
            }
            ObjectValue objectValue2 = objectValue;
            return objectValue2;
        }
        finally {
            env.setCallingClass(oldCallingClass);
        }
    }

    public String getParentName() {
        return this._classDefList[0].getParentName();
    }

    public boolean isA(String name) {
        for (int i = this._classDefList.length - 1; i >= 0; --i) {
            if (!this._classDefList[i].isA(name)) continue;
            return true;
        }
        return false;
    }

    public ArrayValue getInterfaces(Env env, boolean autoload) {
        ArrayValueImpl array = new ArrayValueImpl();
        this.getInterfaces(env, array, autoload, true);
        return array;
    }

    private void getInterfaces(Env env, ArrayValue array, boolean autoload, boolean isTop) {
        ClassDef[] defList = this._classDefList;
        for (int i = 0; i < defList.length; ++i) {
            ClassDef def = defList[i];
            if (!isTop && def.isInterface()) {
                String name = def.getName();
                array.put(name, name);
            }
            String[] defNames = def.getInterfaces();
            for (int j = 0; j < defNames.length; ++j) {
                QuercusClass cls = env.findClass(defNames[j]);
                cls.getInterfaces(env, array, autoload, false);
            }
        }
        if (this._parent != null) {
            this._parent.getInterfaces(env, array, autoload, false);
        }
    }

    public boolean implementsInterface(Env env, String name) {
        ClassDef[] defList = this._classDefList;
        for (int i = 0; i < defList.length; ++i) {
            ClassDef def = defList[i];
            if (def.isInterface() && def.getName().equals(name)) {
                return true;
            }
            String[] defNames = def.getInterfaces();
            for (int j = 0; j < defNames.length; ++j) {
                QuercusClass cls = env.findClass(defNames[j]);
                if (!cls.implementsInterface(env, name)) continue;
                return true;
            }
        }
        if (this._parent != null) {
            return this._parent.implementsInterface(env, name);
        }
        return false;
    }

    public AbstractFunction findConstructor() {
        return this._constructor;
    }

    public Value getField(Env env, Value qThis, StringValue name) {
        if (this._fieldGet != null) {
            return this._fieldGet.callMethod(env, qThis, name);
        }
        return UnsetValue.UNSET;
    }

    public void setField(Env env, Value qThis, StringValue name, Value value) {
        if (this._fieldSet != null) {
            this._fieldSet.callMethod(env, qThis, name, value);
        }
    }

    public AbstractFunction findFunction(String name) {
        char[] key = name.toCharArray();
        int hash = MethodMap.hash(key, key.length);
        AbstractFunction fun = this._methodMap.get(hash, key, key.length);
        return fun;
    }

    public AbstractFunction findStaticFunction(String name) {
        return this.findFunction(name);
    }

    public final AbstractFunction getFunction(String name) {
        char[] key = name.toCharArray();
        int hash = MethodMap.hash(key, key.length);
        return this.getFunction(hash, key, key.length);
    }

    public final AbstractFunction getFunction(int hash, char[] name, int nameLen) {
        AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
        if (fun != null) {
            return fun;
        }
        if (this._className.equalsIgnoreCase(this.toMethod(name, nameLen)) && this._parent != null) {
            return this._parent.getFunction(this._parent.getName());
        }
        throw new QuercusRuntimeException(L.l("{0}::{1} is an unknown method", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLength, Expr[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLength);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, args);
                return value;
            }
            if (this.getCall() != null) {
                Expr[] newArgs = new Expr[args.length + 1];
                newArgs[0] = new StringLiteralExpr(this.toMethod(name, nameLength));
                System.arraycopy(args, 0, newArgs, 1, args.length);
                Value value = this.getCall().callMethod(env, thisValue, newArgs);
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}", (Object)this.getName(), (Object)this.toMethod(name, nameLength)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, StringValue methodName, Expr[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(methodName.toString());
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, args);
                return value;
            }
            if (this.getCall() != null) {
                Expr[] newArgs = new Expr[args.length + 1];
                newArgs[0] = new StringLiteralExpr(methodName.toString());
                System.arraycopy(args, 0, newArgs, 1, args.length);
                Value value = this.getCall().callMethod(env, thisValue, newArgs);
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}", (Object)this.getName(), (Object)methodName));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, args);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl(args));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, StringValue name, Value[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(name.toString());
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, args);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, name, new ArrayValueImpl(args));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)name));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl());
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, a1);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, a1, a2);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, a1, a2, a3);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, a1, a2, a3, a4);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, thisValue, a1, a2, a3, a4, a5);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethod(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4).append(a5));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Expr[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this.getFunction(hash, name, nameLen);
            Value value = fun.callMethodRef(env, thisValue, args);
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, StringValue methodName, Expr[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(methodName.toString());
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, args);
                return value;
            }
            if (this.getCall() != null) {
                Expr[] newArgs = new Expr[args.length + 1];
                newArgs[0] = new StringLiteralExpr(methodName.toString());
                System.arraycopy(args, 0, newArgs, 1, args.length);
                Value value = this.getCall().callMethodRef(env, thisValue, newArgs);
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}", (Object)this.getName(), (Object)methodName));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, args);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl(args));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, StringValue name, Value[] args) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(name.toString());
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, args);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, name, new ArrayValueImpl(args));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)name));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl());
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, a1);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, a1, a2);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, a1, a2, a3);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, a1, a2, a3, a4);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value thisValue, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        QuercusClass oldClass = env.setCallingClass(this);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, thisValue, a1, a2, a3, a4, a5);
                return value;
            }
            if (this.getCall() != null) {
                Value value = this.getCall().callMethodRef(env, thisValue, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4).append(a5));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)this.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    private String toMethod(char[] key, int keyLength) {
        return new String(key, 0, keyLength);
    }

    public AbstractFunction findStaticFunctionLowerCase(String name) {
        return null;
    }

    public final AbstractFunction getStaticFunction(String name) {
        AbstractFunction fun = this.findStaticFunction(name);
        if (fun != null) {
            return fun;
        }
        throw new QuercusRuntimeException(L.l("{0}::{1} is an unknown method", (Object)this.getName(), (Object)name));
    }

    public final Value getConstant(Env env, String name) {
        Expr expr = this._constMap.get(name);
        if (expr != null) {
            return expr.eval(env);
        }
        throw new QuercusRuntimeException(L.l("{0}::{1} is an unknown constant", (Object)this.getName(), (Object)name));
    }

    public final boolean hasConstant(String name) {
        return this._constMap.get(String.valueOf(name)) != null;
    }

    public final HashMap<String, Expr> getConstantMap() {
        return this._constMap;
    }

    public int hashCode() {
        return this._className.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuercusClass)) {
            return false;
        }
        QuercusClass qClass = (QuercusClass)o;
        if (this._classDef != qClass._classDef) {
            return false;
        }
        if (this._javaClassDef != qClass._javaClassDef) {
            return false;
        }
        if (this._parent == qClass._parent) {
            return true;
        }
        return this._parent != null && this._parent.equals(qClass._parent);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    static class StaticField {
        String _name;
        Expr _expr;

        StaticField(String name, Expr expr) {
            this._name = name;
            this._expr = expr;
        }
    }
}

