/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.util.L10N;

public class LateStaticBindingFieldGetExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(LateStaticBindingFieldGetExpr.class);
    protected final String _varName;

    public LateStaticBindingFieldGetExpr(Location location, String varName) {
        super(location);
        this._varName = varName;
    }

    public LateStaticBindingFieldGetExpr(String varName) {
        this._varName = varName;
    }

    public Value eval(Env env) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cls.getStaticField(env, this._varName).toValue();
    }

    public Value evalCopy(Env env) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cls.getStaticField(env, this._varName).copy();
    }

    public Value evalArg(Env env) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cls.getStaticField(env, this._varName);
    }

    public Value evalArray(Env env) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cls.getStaticField(env, this._varName).getArray();
    }

    public Value evalObject(Env env) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cls.getStaticField(env, this._varName).getObject(env);
    }

    public Value evalRef(Env env) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cls.getStaticField(env, this._varName);
    }

    public void evalAssign(Env env, Value value) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return;
        }
        cls.getStaticField(env, this._varName).set(value);
    }

    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)env.getCallingClass().getName(), (Object)this._varName));
    }

    public String toString() {
        return "static::$" + this._varName;
    }
}

