/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.LateStaticBindingStaticMethodExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LateStaticBindingStaticVarMethodExpr
extends Expr {
    private static final L10N L = new L10N(LateStaticBindingStaticMethodExpr.class);
    protected final Expr _nameExpr;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;
    protected AbstractFunction _fun;
    protected boolean _isMethod;

    public LateStaticBindingStaticVarMethodExpr(Location location, Expr nameExpr, ArrayList<Expr> args) {
        super(location);
        this._nameExpr = nameExpr;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public LateStaticBindingStaticVarMethodExpr(Location location, Expr nameExpr, Expr[] args) {
        super(location);
        this._nameExpr = nameExpr;
        this._args = args;
    }

    public LateStaticBindingStaticVarMethodExpr(Expr nameExpr, ArrayList<Expr> args) {
        this(Location.UNKNOWN, nameExpr, args);
    }

    public LateStaticBindingStaticVarMethodExpr(Expr nameExpr, Expr[] args) {
        this(Location.UNKNOWN, nameExpr, args);
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    @Override
    public Value eval(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        Value thisValue = env.getThis();
        StringValue methodName = this._nameExpr.evalStringValue(env);
        return cl.callMethod(env, thisValue, methodName, this._args);
    }

    @Override
    public Value evalRef(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        Value thisValue = env.getThis();
        StringValue methodName = this._nameExpr.evalStringValue(env);
        return cl.callMethodRef(env, thisValue, methodName, this._args);
    }

    @Override
    public String toString() {
        return this._nameExpr + "()";
    }
}

