/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodExpr
extends Expr {
    private static final L10N L = new L10N(StaticMethodExpr.class);
    protected final String _className;
    protected final String _methodName;
    protected final int _hash;
    protected final char[] _name;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;
    protected AbstractFunction _fun;
    protected boolean _isMethod;

    public StaticMethodExpr(Location location, String className, String name, ArrayList<Expr> args) {
        super(location);
        this._className = className.intern();
        this._methodName = name;
        this._name = name.toCharArray();
        this._hash = MethodMap.hash(this._name, this._name.length);
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public StaticMethodExpr(Location location, String className, String name, Expr[] args) {
        super(location);
        this._className = className.intern();
        this._methodName = name;
        this._name = name.toCharArray();
        this._hash = MethodMap.hash(this._name, this._name.length);
        this._args = args;
    }

    public StaticMethodExpr(String className, String name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, className, name, args);
    }

    public StaticMethodExpr(String className, String name, Expr[] args) {
        this(Location.UNKNOWN, className, name, args);
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        QuercusClass cl = env.findClass(this._className);
        if (cl == null) {
            env.error(this.getLocation(), L.l("no matching class {0}", (Object)this._className));
            return NullValue.NULL;
        }
        Value thisValue = env.getThis();
        Value[] args = new Value[this._args.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this._args[i].evalArg(env);
        }
        env.pushCall(this, thisValue, args);
        try {
            env.checkTimeout();
            Value value = cl.callMethod(env, thisValue, this._hash, this._name, this._name.length, args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value evalRef(Env env) {
        QuercusClass cl = env.findClass(this._className);
        if (cl == null) {
            env.error(this.getLocation(), L.l("no matching class {0}", (Object)this._className));
            return NullValue.NULL;
        }
        Value thisValue = env.getThis();
        env.checkTimeout();
        Value value = cl.callMethodRef(env, thisValue, this._hash, this._name, this._name.length, this._args);
        return value;
    }

    @Override
    public String toString() {
        return this._methodName + "()";
    }
}

