/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.VariableArguments;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.MailModule;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.quercus.lib.i18n.Encoder;
import com.caucho.quercus.lib.i18n.QuercusMimeUtility;
import com.caucho.quercus.lib.regexp.CauchoRegexpModule;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbstringModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(MbstringModule.class.getName());
    private static final L10N L = new L10N(MbstringModule.class);
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    public static final int MB_CASE_UPPER = 0;
    public static final int MB_CASE_LOWER = 1;
    public static final int MB_CASE_TITLE = 2;
    static final IniDefinition INI_MBSTRING_HTTP_INPUT = _iniDefinitions.add("mbstring.http_input", "pass", 7);
    static final IniDefinition INI_MBSTRING_HTTP_OUTPUT = _iniDefinitions.add("mbstring.http_output", "pass", 7);

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"mbstring"};
    }

    @Override
    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public boolean mb_check_encoding(Env env, @Optional Value var, @Optional String encoding) {
        if (encoding == null || encoding.length() == 0) {
            encoding = MbstringModule.getEncoding(env);
        }
        Decoder decoder = Decoder.create(encoding);
        if (!var.isDefault()) {
            return decoder.isDecodable(env, var.toStringValue());
        }
        throw new UnimplementedException("mb_check_encoding() with no args");
    }

    public static StringValue mb_convert_case(Env env, StringValue str, int mode, @Optional(value="") String encoding) {
        if (mode == 2) {
            encoding = MbstringModule.getEncoding(env, encoding);
            CharSequence unicodeStr = MbstringModule.decode(env, str, encoding);
            unicodeStr = MbstringModule.toUpperCaseTitle(env, unicodeStr);
            return MbstringModule.encode(env, unicodeStr, encoding);
        }
        if (mode == 1) {
            return MbstringModule.mb_strtolower(env, str, encoding);
        }
        if (mode == 0) {
            return MbstringModule.mb_strtoupper(env, str, encoding);
        }
        return str;
    }

    public static Value mb_convert_encoding(Env env, StringValue str, String destEncoding, @Optional Value fromEncodings) {
        ArrayList<String> charsetList = MbstringModule.getEncodingList(env, fromEncodings);
        CharSequence unicodeStr = null;
        for (int i = 0; i < charsetList.size(); ++i) {
            String charset = charsetList.get(i);
            try {
                unicodeStr = MbstringModule.decode(env, str, charset);
                continue;
            }
            catch (UnsupportedCharsetException e) {
                // empty catch block
            }
        }
        if (unicodeStr == null) {
            log.log(Level.FINE, L.l("unsupported character encoding {0}", (Object)fromEncodings));
            env.warning(L.l("unsupported character encoding {0}", (Object)fromEncodings));
            return str;
        }
        try {
            return MbstringModule.encode(env, unicodeStr, destEncoding);
        }
        catch (UnsupportedCharsetException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("unsupported character encoding {0}", (Object)fromEncodings));
            return BooleanValue.FALSE;
        }
    }

    public static StringValue mb_convert_kana(Env env, StringValue str, @Optional(value="") String option, @Optional(value="") String encoding) {
        throw new UnimplementedException("mb_convert_kana");
    }

    @VariableArguments
    public static StringValue mb_convert_variables(Env env, String toEncoding, String fromEncodings, @Reference Value vars) {
        int tail = fromEncodings.indexOf(44, 1);
        if (tail < 0) {
            tail = fromEncodings.length();
        }
        String srcEncoding = tail < 0 ? fromEncodings : MbstringModule.getEncoding(env, fromEncodings.substring(0, tail).trim());
        Value decoded = MbstringModule.decodeAll(env, vars, srcEncoding);
        vars.set(MbstringModule.encodeAll(env, decoded, toEncoding));
        return env.createString(srcEncoding);
    }

    public static Value mb_decode_mimeheader(Env env, StringValue str) {
        String encoding = MbstringModule.getEncoding(env);
        try {
            return QuercusMimeUtility.decodeMime(env, str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    public static StringValue mb_decode_numericentity(Env env, StringValue str, ArrayValue convmap, @Optional String encoding) {
        throw new UnimplementedException("mb_decode_numericentity");
    }

    public static Value mb_detect_encoding(Env env, StringValue str, @Optional Value encodingV, @Optional boolean isStrict) {
        ArrayList<String> encodingList = MbstringModule.getDetectOrderList(env, encodingV);
        int len = encodingList.size();
        for (int i = 0; i < len; ++i) {
            String charset = encodingList.get(i);
            Decoder decoder = Decoder.create(charset);
            if (!decoder.isDecodable(env, str)) continue;
            return env.createString(charset);
        }
        return BooleanValue.FALSE;
    }

    public static Value mb_detect_order(Env env, @Optional Value encodingV) {
        if (encodingV.isDefault()) {
            ArrayValueImpl array = new ArrayValueImpl();
            ArrayList<String> list = MbstringModule.getDetectOrderList(env, encodingV);
            for (String encoding : list) {
                array.put(encoding);
            }
            return array;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (encodingV.isArray()) {
            Iterator<Value> iter = encodingV.getValueIterator(env);
            while (iter.hasNext()) {
                list.add(iter.next().toString());
            }
        } else {
            MbstringModule.parseCommaSeparatedList(list, encodingV.toString());
        }
        env.setSpecialValue("mb.detect_order", list);
        return BooleanValue.TRUE;
    }

    private static ArrayList<String> getDetectOrderList(Env env, Value encodingV) {
        if (encodingV.isDefault() && env.getSpecialValue("mb.detect_order") != null) {
            return (ArrayList)env.getSpecialValue("mb.detect_order");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (encodingV.isDefault()) {
            String encodings = env.getIniString("mbstring.detect_order");
            if (encodings != null) {
                MbstringModule.parseCommaSeparatedList(list, encodings);
            } else {
                list.add("ASCII");
                list.add("UTF-8");
            }
        } else if (encodingV.isArray()) {
            Iterator<Value> iter = encodingV.getValueIterator(env);
            while (iter.hasNext()) {
                list.add(iter.next().toString());
            }
        } else {
            String encodings = encodingV.toString();
            if (encodings.equalsIgnoreCase("auto")) {
                list.add("ASCII");
                list.add("JIS");
                list.add("UTF-8");
                list.add("EUC-JP");
                list.add("SJIS");
            } else {
                MbstringModule.parseCommaSeparatedList(list, encodingV.toString());
            }
        }
        return list;
    }

    private static void parseCommaSeparatedList(ArrayList<String> list, String str) {
        int index;
        int start = 0;
        while ((index = str.indexOf(",", start)) >= 0) {
            String charset = str.substring(start, index).trim();
            start = index + 1;
            list.add(charset);
        }
        list.add(str.substring(start).trim());
    }

    public static StringValue mb_encode_mimeheader(Env env, StringValue str, @Optional(value="") String charset, @Optional(value="B") String transfer_encoding, @Optional(value="") String linefeed) {
        charset = MbstringModule.getEncoding(env, charset);
        try {
            String mime = QuercusMimeUtility.encodeMimeWord(str.toString(), charset, transfer_encoding, linefeed, 76);
            return env.createString(mime);
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    public static StringValue mb_encode_numericentity(Env env, StringValue str, ArrayValue convmap, @Optional String encoding) {
        throw new UnimplementedException();
    }

    public static BooleanValue mb_ereg_match(Env env, StringValue pattern, StringValue string, @Optional String option) {
        String encoding = MbstringModule.getEncoding(env);
        Value val = CauchoRegexpModule.eregImpl(env, pattern = pattern.convertToUnicode(env, encoding), string = string.convertToUnicode(env, encoding), null, false);
        if (val == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public static Value mb_ereg_replace(Env env, StringValue pattern, StringValue replacement, StringValue subject, @Optional String option) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        replacement = replacement.convertToUnicode(env, encoding);
        subject = subject.convertToUnicode(env, encoding);
        Value val = RegexpModule.eregi_replace(env, pattern, replacement, subject);
        return MbstringModule.encodeAll(env, val, encoding);
    }

    public static Value mb_ereg(Env env, StringValue pattern, StringValue string, @Optional ArrayValue regs) {
        return MbstringModule.eregImpl(env, pattern, string, regs, true);
    }

    public static Value mb_eregi_replace(Env env, StringValue pattern, StringValue replacement, StringValue subject, @Optional String option) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        replacement = replacement.convertToUnicode(env, encoding);
        subject = subject.convertToUnicode(env, encoding);
        Value val = RegexpModule.eregi_replace(env, pattern, replacement, subject);
        return MbstringModule.encodeAll(env, val, encoding);
    }

    public static Value mb_eregi(Env env, StringValue pattern, StringValue string, @Optional ArrayValue regs) {
        return MbstringModule.eregImpl(env, pattern, string, regs, false);
    }

    private static Value eregImpl(Env env, StringValue pattern, StringValue string, ArrayValue regs, boolean isCaseSensitive) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        string = string.convertToUnicode(env, encoding);
        if (regs == null) {
            if (isCaseSensitive) {
                return CauchoRegexpModule.eregImpl(env, pattern, string, null, false);
            }
            return CauchoRegexpModule.eregImpl(env, pattern, string, null, true);
        }
        Var regVar = new Var();
        Value val = isCaseSensitive ? CauchoRegexpModule.eregImpl(env, pattern, string, regVar, false) : CauchoRegexpModule.eregImpl(env, pattern, string, regVar, true);
        if (regVar.isset()) {
            regs.clear();
            ArrayValue results = regVar.toArrayValue(env);
            for (Map.Entry<Value, Value> entry : results.entrySet()) {
                Value bytes = MbstringModule.encodeAll(env, entry.getValue(), encoding);
                regs.put(entry.getKey(), bytes);
            }
            val = LongValue.create(regs.get(LongValue.ZERO).toStringValue().length());
        }
        return val;
    }

    public static LongValue mb_ereg_search_getpos(Env env) {
        EregSearch ereg = MbstringModule.getEreg(env);
        if (ereg == null) {
            return LongValue.ZERO;
        }
        return LongValue.create(ereg._position);
    }

    public static Value mb_ereg_search_getregs(Env env) {
        EregSearch ereg = MbstringModule.getEreg(env);
        if (ereg == null || ereg._lastMatch == null) {
            return BooleanValue.FALSE;
        }
        return ereg._lastMatch;
    }

    public static BooleanValue mb_ereg_search_init(Env env, StringValue string, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = new EregSearch(env, string, pattern, option);
        env.setSpecialValue("mb.search", ereg);
        return BooleanValue.TRUE;
    }

    public static Value mb_ereg_search_pos(Env env, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = MbstringModule.getEreg(env, pattern, option);
        if (ereg == null) {
            env.warning(L.l("Regular expression not set"));
            return BooleanValue.FALSE;
        }
        return ereg.search(env, true);
    }

    public static Value mb_ereg_search_regs(Env env, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = MbstringModule.getEreg(env, pattern, option);
        if (ereg == null) {
            env.warning(L.l("Regular expression not set"));
            return BooleanValue.FALSE;
        }
        if (ereg.search(env, false) == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        return ereg._lastMatch;
    }

    public static BooleanValue mb_ereg_search_setpos(Env env, int position) {
        EregSearch ereg = MbstringModule.getEreg(env);
        if (ereg == null) {
            return BooleanValue.FALSE;
        }
        ereg._position = position;
        return BooleanValue.TRUE;
    }

    public static BooleanValue mb_ereg_search(Env env, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = MbstringModule.getEreg(env, pattern, option);
        if (ereg == null) {
            env.warning(L.l("Regular expression not set"));
            return BooleanValue.FALSE;
        }
        Value result = ereg.search(env, false);
        return BooleanValue.create(result.toBoolean());
    }

    private static EregSearch getEreg(Env env) {
        Object obj = env.getSpecialValue("mb.search");
        if (obj == null) {
            return null;
        }
        return (EregSearch)obj;
    }

    private static EregSearch getEreg(Env env, Value pattern, Value option) {
        Object obj = env.getSpecialValue("mb.search");
        if (obj != null) {
            EregSearch ereg = (EregSearch)obj;
            ereg.init(env, pattern, option);
            if (ereg._isValidRegexp) {
                return ereg;
            }
            return null;
        }
        return null;
    }

    public static Value mb_get_info(Env env, @Optional(value="") String type) {
        if (type.length() == 0) {
            ArrayValueImpl array = new ArrayValueImpl();
            array.put(env.createString("internal_encoding"), env.createString(MbstringModule.getEncoding(env)));
            array.put(env.createString("http_output"), env.createString(MbstringModule.getOutputEncoding(env)));
            return array;
        }
        if (type.equals("internal_encoding")) {
            return env.createString(MbstringModule.getEncoding(env));
        }
        if (type.equals("http_output")) {
            return env.createString(MbstringModule.getOutputEncoding(env));
        }
        env.warning(L.l("unsupported option: {0}", (Object)type));
        return BooleanValue.FALSE;
    }

    public static Value mb_http_input(Env env, @Optional String type) {
        throw new UnimplementedException("mb_http_input");
    }

    public static Value mb_http_output(Env env, @Optional String encoding) {
        if (encoding.length() == 0) {
            return env.createString(MbstringModule.getOutputEncoding(env));
        }
        env.setIni("mbstring.http_output", encoding);
        return BooleanValue.TRUE;
    }

    public static Value mb_internal_encoding(Env env, @Optional String encoding) {
        if (encoding.length() == 0) {
            return env.createString(MbstringModule.getEncoding(env));
        }
        MbstringModule.setEncoding(env, encoding);
        return BooleanValue.TRUE;
    }

    public static Value mb_language(Env env, @Optional String language) {
        String encoding = MbstringModule.getEncodingLanguage(env);
        if (language == null || language.length() == 0) {
            if (encoding.equalsIgnoreCase("ISO-2022-JP")) {
                return env.createString("Japanese");
            }
            if (encoding.equalsIgnoreCase("ISO-8859-1")) {
                return env.createString("English");
            }
            if (encoding.equalsIgnoreCase("UTF-8")) {
                return env.createString("uni");
            }
            return env.createString(encoding);
        }
        if (language.equals("Japanese") || language.equals("ja")) {
            MbstringModule.setEncodingLanguage(env, "ISO-2022-JP");
        } else if (language.equals("English") || language.equals("en")) {
            MbstringModule.setEncodingLanguage(env, "ISO-8859-1");
        } else if (language.equals("uni")) {
            MbstringModule.setEncodingLanguage(env, "UTF-8");
        } else {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    private static String getEncodingLanguage(Env env) {
        String encoding = (String)env.getSpecialValue("mb.internal_encoding");
        if (encoding == null) {
            return "ISO-8859-1";
        }
        return encoding;
    }

    private static void setEncodingLanguage(Env env, String encoding) {
        env.setSpecialValue("mb.internal_encoding", encoding);
    }

    public static ArrayValue mb_list_encodings(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        SortedMap<String, Charset> charsetMap = Charset.availableCharsets();
        for (String name : charsetMap.keySet()) {
            ((ArrayValue)array).put(env.createString(name));
        }
        return array;
    }

    public static StringValue mb_output_handler(Env env, StringValue contents, int status) {
        String toEncoding = MbstringModule.getOutputEncoding(env);
        if (toEncoding.equals("pass")) {
            return contents;
        }
        String fromEncoding = MbstringModule.getEncoding(env);
        Decoder decoder = MbstringModule.getDecoder(env, fromEncoding);
        CharSequence contentsUnicode = decoder.decode(env, contents);
        Encoder encoder = MbstringModule.getEncoder(env, toEncoding);
        return encoder.encode(env, contentsUnicode);
    }

    public static BooleanValue mb_parse_str(Env env, StringValue strValue, @Optional @Reference Value result) {
        String encoding = MbstringModule.getEncoding(env);
        StringModule.parse_str(env, strValue.toString(), result);
        if (result == null) {
            return BooleanValue.TRUE;
        }
        Value array = MbstringModule.encodeAll(env, result, encoding);
        result.set(array);
        return BooleanValue.TRUE;
    }

    public static StringValue mb_preferred_mime_name(Env env, StringValue encoding) {
        String mimeName = Encoding.getMimeName((String)encoding.toString());
        return env.createString(mimeName);
    }

    public static Value mb_regex_encoding(Env env, @Optional(value="") String encoding) {
        return MbstringModule.mb_internal_encoding(env, encoding);
    }

    public static StringValue mb_regex_set_options(Env env, @Optional String options) {
        throw new UnimplementedException("mb_regex_set_options");
    }

    public static BooleanValue mb_send_mail(Env env, StringValue to, StringValue subject, StringValue message, @Optional StringValue additionalHeaders, @Optional StringValue additionalParameters) {
        String encoding = MbstringModule.getEncoding(env);
        subject = subject.toBinaryValue(env, encoding);
        message = message.toBinaryValue(env, encoding);
        additionalHeaders = additionalHeaders.toBinaryValue(env, encoding);
        boolean result = MailModule.mail(env, to.toString(), subject.toString(), message, additionalHeaders.toString(), additionalParameters.toString());
        return BooleanValue.create(result);
    }

    public static Value mb_split(Env env, StringValue pattern, StringValue string, @Optional(value="-1") long limit) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        string = string.convertToUnicode(env, encoding);
        Value val = RegexpModule.split(env, pattern, string, limit);
        return MbstringModule.encodeAll(env, val, encoding);
    }

    public static StringValue mb_strcut(Env env, StringValue str, int start, @Optional(value="7fffffff") int length, @Optional String encoding) {
        int end = start + length;
        CharSequence unicodeStr = MbstringModule.decode(env, str, encoding = MbstringModule.getEncoding(env, encoding));
        int len = unicodeStr.length();
        if (end > len) {
            end = len;
        }
        if (start < 0 || start > end) {
            return StringValue.EMPTY;
        }
        if (start < len && Character.isHighSurrogate(unicodeStr.charAt(start))) {
            --start;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(unicodeStr, start, end);
        return MbstringModule.encode(env, sb, encoding);
    }

    public static StringValue mb_strimwidth(Env env, StringValue str, int start, int width, @Optional StringValue trimmarker, @Optional(value="") String encoding) {
        int end = start + width;
        CharSequence unicodeStr = MbstringModule.decode(env, str, encoding = MbstringModule.getEncoding(env, encoding));
        int len = unicodeStr.length();
        if (end > len) {
            end = len;
        }
        if (start < 0 || start > end) {
            return StringValue.EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        if (end < len && trimmarker.length() > 0) {
            sb.append(unicodeStr, start, end - 1);
            sb.append(MbstringModule.decode(env, trimmarker, encoding));
            unicodeStr = sb;
        } else {
            sb.append(unicodeStr, start, end);
        }
        return MbstringModule.encode(env, sb, encoding);
    }

    public static LongValue mb_strlen(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        str = str.convertToUnicode(env, encoding);
        return LongValue.create(str.length());
    }

    public static Value mb_strpos(Env env, StringValue haystack, StringValue needle, @Optional(value="0") int offset, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        haystack = haystack.convertToUnicode(env, encoding);
        needle = needle.convertToUnicode(env, encoding);
        return StringModule.strpos(haystack, needle, offset);
    }

    public static Value mb_strrpos(Env env, StringValue haystack, StringValue needle, @Optional Value offsetV, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        haystack = haystack.convertToUnicode(env, encoding);
        needle = needle.convertToUnicode(env, encoding);
        return StringModule.strrpos(haystack, needle, offsetV);
    }

    public static StringValue mb_strtolower(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        StringValue unicodeStr = str.convertToUnicode(env, encoding);
        unicodeStr = StringModule.strtolower(str);
        return str.create(env, unicodeStr, encoding);
    }

    public static StringValue mb_strtoupper(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        StringValue unicodeStr = str.convertToUnicode(env, encoding);
        unicodeStr = StringModule.strtoupper(str);
        return str.create(env, unicodeStr, encoding);
    }

    public static LongValue mb_strwidth(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        str = str.convertToUnicode(env, encoding);
        return LongValue.create(str.length());
    }

    public static Value mb_substitute_character(Value substrchar) {
        throw new UnimplementedException("mb_substitute_character");
    }

    public static LongValue mb_substr_count(Env env, StringValue haystack, StringValue needle, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        haystack = haystack.convertToUnicode(env, encoding);
        needle = needle.convertToUnicode(env, encoding);
        int count = 0;
        int sublen = needle.length();
        int i = haystack.indexOf(needle);
        while (i >= 0) {
            i = haystack.indexOf(needle, i + sublen);
            ++count;
        }
        return LongValue.create(count);
    }

    public static StringValue mb_substr(Env env, StringValue str, int start, @Optional Value lengthV, @Optional String encoding) {
        StringValue unicodeStr = str.convertToUnicode(env, encoding = MbstringModule.getEncoding(env, encoding));
        Value val = StringModule.substr(env, unicodeStr, start, lengthV);
        if (val == BooleanValue.FALSE) {
            return StringValue.EMPTY;
        }
        return MbstringModule.encode(env, val.toStringValue(), encoding);
    }

    private static CharSequence toUpperCaseTitle(Env env, CharSequence str) {
        StringBuilder sb = new StringBuilder();
        int strLen = str.length();
        boolean isWordStart = true;
        block3: for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    isWordStart = true;
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    if (isWordStart) {
                        sb.append(Character.toUpperCase(ch));
                        isWordStart = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(ch));
                }
            }
        }
        return sb;
    }

    private static CharSequence decode(Env env, StringValue str, String encoding) {
        if (str.isUnicode()) {
            return str;
        }
        Decoder decoder = MbstringModule.getDecoder(env, encoding);
        return decoder.decode(env, str);
    }

    private static Decoder getDecoder(Env env, String encoding) {
        Decoder decoder = Decoder.create(encoding);
        String ini = env.getIniString("mbstring.substitute_character");
        if (ini == null) {
            decoder.setReplacement("?");
        } else if (ini.equalsIgnoreCase("none")) {
            decoder.setIgnoreErrors(true);
        } else if (ini.equalsIgnoreCase("long")) {
            decoder.setReplaceUnicode(true);
        } else {
            char ch;
            int len = ini.length();
            int value = 0;
            for (int i = 0; i < len && '0' <= (ch = ini.charAt(i)) && ch <= '9'; ++i) {
                value = value * 10 + ini.charAt(i) - 48;
            }
            decoder.setReplacement("" + (char)value);
        }
        return decoder;
    }

    private static StringValue encode(Env env, CharSequence str, String encoding) {
        Encoder encoder = MbstringModule.getEncoder(env, encoding);
        return encoder.encode(env, str);
    }

    private static Encoder getEncoder(Env env, String encoding) {
        Encoder encoder = Encoder.create(encoding);
        String ini = env.getIniString("mbstring.substitute_character");
        if (ini == null) {
            encoder.setReplacement("?");
        } else if (ini.equalsIgnoreCase("none")) {
            encoder.setIgnoreErrors(true);
        } else if (ini.equalsIgnoreCase("long")) {
            encoder.setReplaceUnicode(true);
        } else {
            char ch;
            int len = ini.length();
            int value = 0;
            for (int i = 0; i < len && '0' <= (ch = ini.charAt(i)) && ch <= '9'; ++i) {
                value = value * 10 + ini.charAt(i) - 48;
            }
            encoder.setReplacement("" + (char)value);
        }
        return encoder;
    }

    private static String getEncoding(Env env) {
        StringValue encoding = env.getIni("mbstring.internal_encoding");
        if (((Value)encoding).length() > 0) {
            return encoding.toString();
        }
        return env.getRuntimeEncoding();
    }

    private static String getEncoding(Env env, String encoding) {
        if (encoding == null || encoding.length() == 0) {
            return MbstringModule.getEncoding(env);
        }
        return encoding;
    }

    private static void setEncoding(Env env, String encoding) {
        env.setIni("mbstring.internal_encoding", encoding);
    }

    private static String getOutputEncoding(Env env) {
        StringValue encoding = env.getIni("mbstring.http_output");
        if (((Value)encoding).length() != 0) {
            return encoding.toString();
        }
        return env.getOutputEncoding();
    }

    private static ArrayList<String> getEncodingList(Env env, Value encodingV) {
        ArrayList<String> list = new ArrayList<String>();
        if (encodingV.isDefault()) {
            list.add(MbstringModule.getEncoding(env));
        } else if (encodingV.isArray()) {
            Iterator<Value> iter = encodingV.getValueIterator(env);
            while (iter.hasNext()) {
                list.add(iter.next().toString());
            }
        } else {
            String encodings = encodingV.toString();
            if (encodings.equals("auto")) {
                list.add("ASCII");
                list.add("JIS");
                list.add("UTF-8");
                list.add("EUC-JP");
                list.add("SJIS");
            } else {
                int index;
                int start = 0;
                while ((index = encodings.indexOf(",", start)) >= 0) {
                    String charset = encodings.substring(start, index).trim();
                    start = index + 1;
                    list.add(charset);
                }
                list.add(encodings.substring(start).trim());
            }
        }
        return list;
    }

    private static Value decodeAll(Env env, Value val, String encoding) {
        Decoder decoder = MbstringModule.getDecoder(env, encoding);
        return MbstringModule.decodeAll(env, val, decoder);
    }

    private static Value decodeAll(Env env, Value val, Decoder decoder) {
        decoder.reset();
        val = val.toValue();
        if (val.isString()) {
            return decoder.decodeUnicode(env, val.toStringValue());
        }
        if (val.isArray()) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : ((ArrayValue)val).entrySet()) {
                array.put(entry.getKey(), MbstringModule.decodeAll(env, entry.getValue(), decoder));
            }
            return array;
        }
        if (val.isObject()) {
            ObjectValue obj = (ObjectValue)val.toObject(env);
            for (Map.Entry<Value, Value> entry : obj.entrySet()) {
                obj.putField(env, entry.getKey().toStringValue(), MbstringModule.decodeAll(env, entry.getValue(), decoder));
            }
            return obj;
        }
        return val;
    }

    private static Value encodeAll(Env env, Value val, String encoding) {
        Encoder encoder = MbstringModule.getEncoder(env, encoding);
        return MbstringModule.encodeAll(env, val, encoder);
    }

    private static Value encodeAll(Env env, Value val, Encoder encoder) {
        if ((val = val.toValue()).isString()) {
            return encoder.encode(env, val.toStringValue(), true);
        }
        if (val.isArray()) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : ((ArrayValue)val).entrySet()) {
                array.put(entry.getKey(), MbstringModule.encodeAll(env, entry.getValue(), encoder));
            }
            return array;
        }
        if (val.isObject()) {
            ObjectValue obj = (ObjectValue)val;
            for (Map.Entry<Value, Value> entry : obj.entrySet()) {
                obj.putField(env, entry.getKey().toStringValue(), MbstringModule.encodeAll(env, entry.getValue(), encoder));
            }
            return obj;
        }
        return val;
    }

    static class EregSearch {
        private StringValue _string;
        private StringValue _pattern;
        private Value _option;
        private int _length;
        ArrayValue _lastMatch;
        int _position;
        boolean _isValidRegexp;

        EregSearch(Env env, StringValue string, Value pattern, Value option) {
            this._string = string.convertToUnicode(env, MbstringModule.getEncoding(env));
            this._position = 0;
            this._length = this._string.length();
            this.init(env, pattern, option);
        }

        void init(Env env, Value pattern, Value option) {
            this._option = option;
            this.initPattern(env, pattern);
        }

        void initPattern(Env env, Value pattern) {
            if (pattern instanceof StringValue) {
                this._pattern = pattern.toStringValue();
                this._isValidRegexp = true;
            } else {
                this._isValidRegexp = this._pattern != null;
            }
        }

        StringValue getString(Env env) {
            if (this._position == 0) {
                return this._string;
            }
            if (this._position < this._length) {
                return this._string.substring(this._position);
            }
            return StringValue.EMPTY;
        }

        Value search(Env env, boolean isArrayReturn) {
            ArrayValueImpl regs;
            StringValue string = this.getString(env);
            Value val = MbstringModule.eregImpl(env, this._pattern, string, regs = new ArrayValueImpl(), true);
            if (val == BooleanValue.FALSE) {
                return BooleanValue.FALSE;
            }
            StringValue match = ((ArrayValue)regs).get(LongValue.ZERO).toStringValue();
            int matchIndex = this._string.indexOf(match, this._position);
            int matchLength = match.length();
            this._position = matchIndex + matchLength;
            this._lastMatch = regs;
            if (isArrayReturn) {
                ArrayValueImpl array = new ArrayValueImpl();
                ((ArrayValue)array).put(LongValue.create(matchIndex));
                ((ArrayValue)array).put(LongValue.create(matchLength));
                return array;
            }
            return BooleanValue.TRUE;
        }
    }
}

