/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zip;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipEntryInputStream
extends ReadStreamInput {
    private static final L10N L = new L10N(ZipEntryInputStream.class);
    private final BinaryInput _in;
    private final long _position;

    public ZipEntryInputStream(BinaryInput in, long position) throws IOException {
        super(Env.getInstance());
        this._in = in;
        this._position = position;
        in.setPosition(this._position);
        ZipInputStream zipInputStream = new ZipInputStream(in.getInputStream());
        ZipEntry curEntry = zipInputStream.getNextEntry();
        if (curEntry == null) {
            throw new IOException(L.l("ZipEntry at position {0} not found", this._position));
        }
        this.init(new ReadStream((StreamImpl)new VfsStream((InputStream)zipInputStream, null)));
    }

    public BinaryInput openCopy() throws IOException {
        return new ZipEntryInputStream(this._in.openCopy(), this._position);
    }

    public String toString() {
        return "ZipEntryInputStream[]";
    }
}

