/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zip;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.zip.QuercusZipEntry;
import com.caucho.quercus.lib.zip.ZipDirectory;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZipModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(ZipModule.class.getName());
    private static final L10N L = new L10N(ZipModule.class);

    public String[] getLoadedExtensions() {
        return new String[]{"zip"};
    }

    @ReturnNullAsFalse
    public ZipDirectory zip_open(Env env, @NotNull StringValue filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        BinaryStream s = FileModule.fopen(env, filename, "rb", false, null);
        if (s == null) {
            return null;
        }
        return new ZipDirectory((BinaryInput)s);
    }

    @ReturnNullAsFalse
    public QuercusZipEntry zip_read(Env env, @NotNull ZipDirectory directory) {
        if (directory == null) {
            return null;
        }
        try {
            QuercusZipEntry qze = directory.zip_read();
            this.zip_entry_open(env, directory, qze, "rb");
            return qze;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public Value zip_entry_name(Env env, @NotNull QuercusZipEntry entry) {
        if (entry == null) {
            return BooleanValue.FALSE;
        }
        return env.createString(entry.zip_entry_name());
    }

    public Value zip_entry_filesize(@NotNull QuercusZipEntry entry) {
        if (entry == null) {
            return BooleanValue.FALSE;
        }
        return new LongValue(entry.zip_entry_filesize());
    }

    public boolean zip_close(@NotNull ZipDirectory directory) {
        if (directory == null) {
            return false;
        }
        return directory.zip_close();
    }

    public boolean zip_entry_open(Env env, @NotNull ZipDirectory directory, @NotNull QuercusZipEntry entry, @Optional String mode) {
        if (directory == null || entry == null) {
            return false;
        }
        return entry.zip_entry_open(env, directory);
    }

    public boolean zip_entry_close(Env env, @NotNull QuercusZipEntry entry) {
        try {
            if (entry == null) {
                return false;
            }
            return entry.zip_entry_close();
        }
        catch (IOException e) {
            env.warning(L.l(e.toString()));
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    @ReturnNullAsFalse
    public StringValue zip_entry_read(Env env, @NotNull QuercusZipEntry entry, @Optional(value="1024") int length) {
        if (entry == null) {
            return null;
        }
        return entry.zip_entry_read(env, length);
    }

    public String zip_entry_compressionmethod(@NotNull QuercusZipEntry entry) {
        if (entry == null) {
            return "";
        }
        return entry.zip_entry_compressionmethod();
    }

    public long zip_entry_compressedsize(@NotNull QuercusZipEntry entry) {
        if (entry == null) {
            return -1L;
        }
        return entry.zip_entry_compressedsize();
    }
}

