/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.quercus.lib.zlib.GZInputStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;

public class ZlibInputStream
extends ReadStreamInput {
    private Env _env;
    private BinaryInput _in;
    private GZInputStream _gzIn;

    public ZlibInputStream(Env env, BinaryInput in) throws IOException {
        super(env);
        this._env = env;
        this.init(in);
    }

    protected void init(BinaryInput in) throws IOException {
        this._in = in;
        this._gzIn = new GZInputStream(in.getInputStream());
        ReadStream rs = new ReadStream((StreamImpl)new VfsStream((InputStream)this._gzIn, null));
        this.init(rs);
    }

    public BinaryInput openCopy() throws IOException {
        return new ZlibInputStream(this._env, this._in.openCopy());
    }

    public boolean setPosition(long offset) {
        try {
            BinaryInput newIn = this._in.openCopy();
            this.close();
            this._in.close();
            this.init(newIn);
            return this.skip(offset) == offset;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public String toString() {
        return "ZlibInputStream[]";
    }
}

