/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.storage;

import java.util.List;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;

public class SequenceAsStringHelper<C extends Compound> {
    public String getSequenceAsString(List<C> parsedCompounds, CompoundSet<C> compoundSet, Integer bioBegin, Integer bioEnd, Strand strand) {
        if (parsedCompounds.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (strand.equals((Object)Strand.NEGATIVE)) {
            if (bioBegin <= bioEnd) {
                for (int index = bioEnd - 1; index >= bioBegin - 1; --index) {
                    Compound compound = (Compound)parsedCompounds.get(index);
                    builder.append(compoundSet.getStringForCompound(compound));
                }
            } else {
                Compound compound;
                int index;
                for (index = bioBegin - 1; index >= 0; --index) {
                    compound = (Compound)parsedCompounds.get(index);
                    builder.append(compoundSet.getStringForCompound(compound));
                }
                for (index = parsedCompounds.size() - 1; index >= bioEnd - 1; --index) {
                    compound = (Compound)parsedCompounds.get(index);
                    builder.append(compoundSet.getStringForCompound(compound));
                }
            }
        } else if (bioBegin <= bioEnd) {
            for (int index = bioBegin - 1; index <= bioEnd - 1; ++index) {
                Compound compound = (Compound)parsedCompounds.get(index);
                builder.append(compoundSet.getStringForCompound(compound));
            }
        } else {
            Compound compound;
            int index;
            for (index = bioBegin - 1; index <= parsedCompounds.size() - 1; ++index) {
                compound = (Compound)parsedCompounds.get(index);
                builder.append(compoundSet.getStringForCompound(compound));
            }
            for (index = 0; index <= bioEnd - 1; ++index) {
                compound = (Compound)parsedCompounds.get(index);
                builder.append(compoundSet.getStringForCompound(compound));
            }
        }
        return builder.toString();
    }
}

