/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.sequencing.io.fastq;

import java.util.HashMap;
import java.util.Map;

public enum FastqVariant {
    FASTQ_SANGER("Original or Sanger format"){

        @Override
        public int minimumQualityScore() {
            return 0;
        }

        @Override
        public int maximumQualityScore() {
            return 93;
        }

        @Override
        public int qualityScore(char c) {
            return c - 33;
        }

        @Override
        public int qualityScore(double errorProbability) {
            int phredQ = this.constrain(-10.0 * Math.log10(errorProbability));
            return phredQ;
        }

        @Override
        public char quality(int qualityScore) {
            if (qualityScore < this.minimumQualityScore()) {
                throw new IllegalArgumentException("qualityScore must be greater than or equal to minimumQualityScore()");
            }
            if (qualityScore > this.maximumQualityScore()) {
                throw new IllegalArgumentException("qualityScore must be less than or equal to maximumQualityScore()");
            }
            return (char)(qualityScore + 33);
        }

        @Override
        public double errorProbability(int qualityScore) {
            return Math.pow(10.0, (double)qualityScore / -10.0);
        }
    }
    ,
    FASTQ_SOLEXA("Solexa and early Illumina format"){

        @Override
        public int minimumQualityScore() {
            return -5;
        }

        @Override
        public int maximumQualityScore() {
            return 62;
        }

        @Override
        public int qualityScore(char c) {
            return c - 64;
        }

        @Override
        public int qualityScore(double errorProbability) {
            double phredQ = -10.0 * Math.log10(errorProbability);
            int solexaQ = this.constrain(10.0 * Math.log10(Math.pow(10.0, phredQ / 10.0) - 1.0));
            return solexaQ;
        }

        @Override
        public char quality(int qualityScore) {
            if (qualityScore < this.minimumQualityScore()) {
                throw new IllegalArgumentException("qualityScore must be greater than or equal to minimumQualityScore()");
            }
            if (qualityScore > this.maximumQualityScore()) {
                throw new IllegalArgumentException("qualityScore must be less than or equal to maximumQualityScore()");
            }
            return (char)(qualityScore + 64);
        }

        @Override
        public double errorProbability(int qualityScore) {
            double q = Math.pow(10.0, (double)qualityScore / -10.0);
            return q / (1.0 + q);
        }
    }
    ,
    FASTQ_ILLUMINA("Illumina 1.3+ format"){

        @Override
        public int minimumQualityScore() {
            return 0;
        }

        @Override
        public int maximumQualityScore() {
            return 62;
        }

        @Override
        public int qualityScore(char c) {
            return c - 64;
        }

        @Override
        public int qualityScore(double errorProbability) {
            int phredQ = this.constrain(-10.0 * Math.log10(errorProbability));
            return phredQ;
        }

        @Override
        public char quality(int qualityScore) {
            if (qualityScore < this.minimumQualityScore()) {
                throw new IllegalArgumentException("qualityScore must be greater than or equal to minimumQualityScore()");
            }
            if (qualityScore > this.maximumQualityScore()) {
                throw new IllegalArgumentException("qualityScore must be less than or equal to maximumQualityScore()");
            }
            return (char)(qualityScore + 64);
        }

        @Override
        public double errorProbability(int qualityScore) {
            return Math.pow(10.0, (double)qualityScore / -10.0);
        }
    };

    private static final Map<String, FastqVariant> FASTQ_VARIANTS;
    private final String description;

    private FastqVariant(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSanger() {
        return this == FASTQ_SANGER;
    }

    public boolean isSolexa() {
        return this == FASTQ_SOLEXA;
    }

    public boolean isIllumina() {
        return this == FASTQ_ILLUMINA;
    }

    public abstract int minimumQualityScore();

    public abstract int maximumQualityScore();

    public abstract int qualityScore(char var1);

    public abstract int qualityScore(double var1);

    public abstract char quality(int var1);

    public double errorProbability(char c) {
        return this.errorProbability(this.qualityScore(c));
    }

    public abstract double errorProbability(int var1);

    public String lowercaseName() {
        return this.name().toLowerCase().replace('_', '-');
    }

    protected int constrain(double qualityScore) {
        return Math.min(this.maximumQualityScore(), Math.max(this.minimumQualityScore(), Math.round((float)qualityScore)));
    }

    public static FastqVariant parseFastqVariant(String name) {
        return FASTQ_VARIANTS.get(name);
    }

    static {
        FASTQ_VARIANTS = new HashMap<String, FastqVariant>(6);
        for (FastqVariant fastqVariant : FastqVariant.values()) {
            FASTQ_VARIANTS.put(fastqVariant.name(), fastqVariant);
            FASTQ_VARIANTS.put(fastqVariant.lowercaseName(), fastqVariant);
        }
    }
}

