/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.TaxonomyID;
import org.biojava3.core.sequence.features.AbstractFeature;
import org.biojava3.core.sequence.features.DatabaseReferenceInterface;
import org.biojava3.core.sequence.features.FeatureInterface;
import org.biojava3.core.sequence.features.FeaturesKeyWordInterface;
import org.biojava3.core.sequence.location.SequenceLocation;
import org.biojava3.core.sequence.location.SimpleLocation;
import org.biojava3.core.sequence.storage.ArrayListSequenceReader;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceProxyView;
import org.biojava3.core.sequence.template.SequenceReader;
import org.biojava3.core.sequence.template.SequenceView;

public abstract class AbstractSequence<C extends Compound>
implements Sequence<C> {
    private TaxonomyID taxonomy;
    private AccessionID accession;
    private SequenceReader<C> sequenceStorage = null;
    private CompoundSet<C> compoundSet;
    private AnnotationType annotationType = AnnotationType.UNKNOWN;
    private String description;
    private String originalHeader;
    private Collection<Object> userCollection;
    private Integer bioBegin = null;
    private Integer bioEnd = null;
    private AbstractSequence<C> parentSequence = null;
    private String source = null;
    private ArrayList<String> notesList = new ArrayList();
    private Double sequenceScore = null;
    private FeaturesKeyWordInterface featuresKeyWord = null;
    private DatabaseReferenceInterface databaseReferences = null;
    private ArrayList<FeatureInterface<AbstractSequence<C>, C>> features = new ArrayList();
    private LinkedHashMap<String, ArrayList<FeatureInterface<AbstractSequence<C>, C>>> groupedFeatures = new LinkedHashMap();

    public AbstractSequence() {
    }

    public AbstractSequence(String seqString, CompoundSet<C> compoundSet) {
        this.setCompoundSet(compoundSet);
        this.sequenceStorage = new ArrayListSequenceReader();
        this.sequenceStorage.setCompoundSet(this.getCompoundSet());
        this.sequenceStorage.setContents(seqString);
    }

    public AbstractSequence(ProxySequenceReader<C> proxyLoader, CompoundSet<C> compoundSet) {
        this.setCompoundSet(compoundSet);
        this.setProxySequenceReader(proxyLoader);
    }

    public void setProxySequenceReader(ProxySequenceReader<C> proxyLoader) {
        this.sequenceStorage = proxyLoader;
        if (proxyLoader instanceof FeaturesKeyWordInterface) {
            this.setFeaturesKeyWord((FeaturesKeyWordInterface)((Object)this.sequenceStorage));
        }
        if (proxyLoader instanceof DatabaseReferenceInterface) {
            this.setDatabaseReferences((DatabaseReferenceInterface)((Object)this.sequenceStorage));
        }
    }

    public ProxySequenceReader<C> getProxySequenceReader() {
        return (ProxySequenceReader)this.sequenceStorage;
    }

    public Integer getBioBegin() {
        if (this.bioBegin == null) {
            return 1;
        }
        return this.bioBegin;
    }

    public void setBioBegin(Integer begin) {
        this.bioBegin = begin;
    }

    public Integer getBioEnd() {
        if (this.bioEnd == null) {
            return this.getLength();
        }
        return this.bioEnd;
    }

    public void setBioEnd(Integer end) {
        this.bioEnd = end;
    }

    public Collection<Object> getUserCollection() {
        return this.userCollection;
    }

    public void setUserCollection(Collection<Object> userCollection) {
        this.userCollection = userCollection;
    }

    public AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(AnnotationType annotationType) {
        this.annotationType = annotationType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOriginalHeader() {
        return this.originalHeader;
    }

    public void setOriginalHeader(String originalHeader) {
        this.originalHeader = originalHeader;
    }

    public AbstractSequence<C> getParentSequence() {
        return this.parentSequence;
    }

    public void setParentSequence(AbstractSequence<C> parentSequence) {
        this.parentSequence = parentSequence;
    }

    public String getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.parentSequence != null) {
            return this.parentSequence.getSource();
        }
        return null;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void addNote(String note) {
        this.notesList.add(note);
    }

    public void removeNote(String note) {
        this.notesList.remove(note);
    }

    public ArrayList<String> getNotesList() {
        return this.notesList;
    }

    public void setNotesList(ArrayList<String> notesList) {
        this.notesList = notesList;
    }

    public Double getSequenceScore() {
        return this.sequenceScore;
    }

    public void setSequenceScore(Double sequenceScore) {
        this.sequenceScore = sequenceScore;
    }

    public List<FeatureInterface<AbstractSequence<C>, C>> getFeatures(String featureType, int bioSequencePosition) {
        ArrayList<FeatureInterface<AbstractSequence<C>, C>> featureHits = new ArrayList<FeatureInterface<AbstractSequence<C>, C>>();
        List<FeatureInterface<AbstractSequence<C>, C>> features = this.getFeaturesByType(featureType);
        if (features != null) {
            for (FeatureInterface<AbstractSequence<C>, C> feature : features) {
                if (bioSequencePosition < feature.getLocations().getStart().getPosition() || bioSequencePosition > feature.getLocations().getEnd().getPosition()) continue;
                featureHits.add(feature);
            }
        }
        return featureHits;
    }

    public List<FeatureInterface<AbstractSequence<C>, C>> getFeatures(int bioSequencePosition) {
        ArrayList<FeatureInterface<AbstractSequence<C>, C>> featureHits = new ArrayList<FeatureInterface<AbstractSequence<C>, C>>();
        if (this.features != null) {
            for (FeatureInterface<AbstractSequence<C>, C> feature : this.features) {
                if (bioSequencePosition < feature.getLocations().getStart().getPosition() || bioSequencePosition > feature.getLocations().getEnd().getPosition()) continue;
                featureHits.add(feature);
            }
        }
        return featureHits;
    }

    public List<FeatureInterface<AbstractSequence<C>, C>> getFeatures() {
        return this.features;
    }

    public void addFeature(int bioStart, int bioEnd, FeatureInterface<AbstractSequence<C>, C> feature) {
        SequenceLocation sequenceLocation = new SequenceLocation(bioStart, bioEnd, this);
        feature.setLocation(sequenceLocation);
        this.addFeature(feature);
    }

    public void addFeature(FeatureInterface<AbstractSequence<C>, C> feature) {
        this.features.add(feature);
        ArrayList<FeatureInterface<AbstractSequence<Object>, C>> featureList = this.groupedFeatures.get(feature.getType());
        if (featureList == null) {
            featureList = new ArrayList();
            this.groupedFeatures.put(feature.getType(), featureList);
        }
        featureList.add(feature);
        Collections.sort(this.features, AbstractFeature.LOCATION_LENGTH);
        Collections.sort(featureList, AbstractFeature.LOCATION_LENGTH);
    }

    public void removeFeature(FeatureInterface<AbstractSequence<C>, C> feature) {
        this.features.remove(feature);
        ArrayList<FeatureInterface<AbstractSequence<C>, C>> featureList = this.groupedFeatures.get(feature.getType());
        if (featureList != null) {
            featureList.remove(feature);
            if (featureList.isEmpty()) {
                this.groupedFeatures.remove(feature.getType());
            }
        }
    }

    public List<FeatureInterface<AbstractSequence<C>, C>> getFeaturesByType(String type) {
        ArrayList features = this.groupedFeatures.get(type);
        if (features == null) {
            features = new ArrayList();
        }
        return features;
    }

    public FeaturesKeyWordInterface getFeaturesKeyWord() {
        return this.featuresKeyWord;
    }

    public void setFeaturesKeyWord(FeaturesKeyWordInterface featuresKeyWord) {
        this.featuresKeyWord = featuresKeyWord;
    }

    public DatabaseReferenceInterface getDatabaseReferences() {
        return this.databaseReferences;
    }

    public void setDatabaseReferences(DatabaseReferenceInterface databaseReferences) {
        this.databaseReferences = databaseReferences;
    }

    @Override
    public AccessionID getAccession() {
        return this.accession;
    }

    public void setAccession(AccessionID accession) {
        this.accession = accession;
    }

    public TaxonomyID getTaxonomy() {
        return this.taxonomy;
    }

    public void setTaxonomy(TaxonomyID taxonomy) {
        this.taxonomy = taxonomy;
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        if (this.compoundSet != null) {
            return this.compoundSet;
        }
        if (this.parentSequence != null) {
            return this.parentSequence.getCompoundSet();
        }
        return null;
    }

    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    private SequenceReader<C> getSequenceStorage() {
        if (this.sequenceStorage != null) {
            return this.sequenceStorage;
        }
        if (this.parentSequence != null) {
            return super.getSequenceStorage();
        }
        return null;
    }

    public String getSequenceAsString(Integer bioStart, Integer bioEnd, Strand strand) {
        SimpleLocation loc = new SimpleLocation(bioStart, bioEnd, strand);
        return loc.getSubSequence(this).getSequenceAsString();
    }

    @Override
    public String getSequenceAsString() {
        return SequenceMixin.toString(this);
    }

    @Override
    public List<C> getAsList() {
        return SequenceMixin.toList(this);
    }

    @Override
    public C getCompoundAt(int position) {
        return this.getSequenceStorage().getCompoundAt(position);
    }

    @Override
    public int getIndexOf(C compound) {
        return this.getSequenceStorage().getIndexOf(compound);
    }

    @Override
    public int getLastIndexOf(C compound) {
        return this.getSequenceStorage().getLastIndexOf(compound);
    }

    @Override
    public int getLength() {
        return this.getSequenceStorage().getLength();
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioStart, Integer bioEnd) {
        return new SequenceProxyView(this, bioStart, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        return this.getSequenceStorage().iterator();
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }

    public static enum AnnotationType {
        CURATED,
        PREDICTED,
        UNKNOWN;

    }
}

