/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> T firstElementOrNull(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static boolean collectionEquals(Collection<?> oldCollection, Collection<?> newCollection) {
        if (oldCollection == null && newCollection == null) {
            return true;
        }
        return oldCollection != null && newCollection != null && newCollection.size() == oldCollection.size() && oldCollection.containsAll(newCollection);
    }

    public static <T> Collection<T> removed(Collection<T> left, Collection<T> right) {
        if (left == null || left.isEmpty()) {
            return Collections.emptyList();
        }
        if (right == null || right.isEmpty()) {
            return new ArrayList<T>(left);
        }
        ArrayList<T> removed = new ArrayList<T>();
        for (T eachLeft : left) {
            if (right.contains(eachLeft)) continue;
            removed.add(eachLeft);
        }
        return removed;
    }

    public static <T> Collection<T> added(Collection<T> left, Collection<T> right) {
        if (right == null || right.isEmpty()) {
            return Collections.emptyList();
        }
        if (left == null || left.isEmpty()) {
            return new ArrayList<T>(right);
        }
        ArrayList<T> added = new ArrayList<T>();
        for (T eachRight : right) {
            if (left.contains(eachRight)) continue;
            added.add(eachRight);
        }
        return added;
    }
}

