/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.data.Array;
import fj.data.Either;
import fj.data.Either3;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Seq;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.TreeMap;
import fj.data.TreeZipper;
import fj.data.Validation;
import fj.data.Zipper;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;
import fj.parser.Result;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Hash<A> {
    private final F<A, Integer> f;
    public static final Hash<Boolean> booleanHash = Hash.anyHash();
    public static final Hash<Byte> byteHash = Hash.anyHash();
    public static final Hash<Character> charHash = Hash.anyHash();
    public static final Hash<Double> doubleHash = Hash.anyHash();
    public static final Hash<Float> floatHash = Hash.anyHash();
    public static final Hash<Integer> intHash = Hash.anyHash();
    public static final Hash<Long> longHash = Hash.anyHash();
    public static final Hash<Short> shortHash = Hash.anyHash();
    public static final Hash<BigInteger> bigintHash = Hash.anyHash();
    public static final Hash<BigDecimal> bigdecimalHash = Hash.anyHash();
    public static final Hash<Natural> naturalHash = bigintHash.contramap(Natural::bigIntegerValue);
    public static final Hash<String> stringHash = Hash.anyHash();
    public static final Hash<StringBuffer> stringBufferHash = Hash.hash(sb -> {
        int p = 419;
        int r = 239;
        for (int i = 0; i < sb.length(); ++i) {
            r = 419 * r + sb.charAt(i);
        }
        return r;
    });
    public static final Hash<StringBuilder> stringBuilderHash = Hash.hash(sb -> {
        int p = 419;
        int r = 239;
        for (int i = 0; i < sb.length(); ++i) {
            r = 419 * r + sb.charAt(i);
        }
        return r;
    });

    private Hash(F<A, Integer> f) {
        this.f = f;
    }

    public int hash(A a) {
        return this.f.f(a);
    }

    public <B> Hash<B> contramap(F<B, A> g) {
        return Hash.hash(Function.compose(this.f, g));
    }

    public static <A> Hash<A> hash(F<A, Integer> f) {
        return new Hash<A>(f);
    }

    public static <A> Hash<A> anyHash() {
        return Hash.hash(Object::hashCode);
    }

    public static <A, B> Hash<Either<A, B>> eitherHash(Hash<A> ha, Hash<B> hb) {
        return Hash.hash(e -> e.isLeft() ? ha.hash(e.left().value()) : hb.hash(e.right().value()));
    }

    public static <A, B, C> Hash<Either3<A, B, C>> either3Hash(Hash<A> ha, Hash<B> hb, Hash<C> hc) {
        return Hash.hash(e -> e.either(a -> ha.hash(a), b -> hb.hash(b), c -> hc.hash(c)));
    }

    public static <I, A> Hash<Result<I, A>> resultHash(Hash<A> ha, Hash<I> hi) {
        return Hash.hash(res -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(res.value());
            r = 419 * r + hi.hash(res.rest());
            return r;
        });
    }

    public static <A, B> Hash<Validation<A, B>> validationHash(Hash<A> ha, Hash<B> hb) {
        return Hash.eitherHash(ha, hb).contramap(Validation.either());
    }

    public static <A> Hash<List<A>> listHash(Hash<A> ha) {
        return Hash.hash(as -> {
            int p = 419;
            int r = 239;
            List aas = as;
            while (!aas.isEmpty()) {
                r = 419 * r + ha.hash(aas.head());
                aas = aas.tail();
            }
            return r;
        });
    }

    public static <A> Hash<NonEmptyList<A>> nonEmptyListHash(Hash<A> ha) {
        return Hash.listHash(ha).contramap(NonEmptyList.toList_());
    }

    public static <A> Hash<Option<A>> optionHash(Hash<A> ha) {
        return Hash.hash(o -> o.isNone() ? 0 : ha.hash(o.some()));
    }

    public static <A> Hash<Seq<A>> seqHash(Hash<A> h) {
        return Hash.hash(s -> Hash.streamHash(h).hash(s.toStream()));
    }

    public static <A> Hash<Set<A>> setHash(Hash<A> h) {
        return Hash.hash(s -> Hash.streamHash(h).hash(s.toStream()));
    }

    public static <A> Hash<Stream<A>> streamHash(Hash<A> ha) {
        return Hash.hash(as -> {
            int p = 419;
            int r = 239;
            Stream aas = as;
            while (!aas.isEmpty()) {
                r = 419 * r + ha.hash(aas.head());
                aas = aas.tail()._1();
            }
            return r;
        });
    }

    public static <A> Hash<Array<A>> arrayHash(Hash<A> ha) {
        return Hash.hash(as -> {
            int p = 419;
            int r = 239;
            for (int i = 0; i < as.length(); ++i) {
                r = 419 * r + ha.hash(as.get(i));
            }
            return r;
        });
    }

    public static <A> Hash<Zipper<A>> zipperHash(Hash<A> ha) {
        Hash sh = Hash.streamHash(ha);
        return Hash.hash(as -> {
            int p = 419;
            int r = 239;
            r = 419 * r + sh.hash(as.lefts());
            r = 419 * r + ha.hash(as.focus());
            r = 419 * r + sh.hash(as.rights());
            return r;
        });
    }

    public static <A> Hash<TreeZipper<A>> treeZipperHash(Hash<A> ha) {
        Hash th = Hash.treeHash(ha);
        Hash sth = Hash.streamHash(Hash.treeHash(ha));
        Hash tsp = Hash.streamHash(Hash.p3Hash(Hash.streamHash(Hash.treeHash(ha)), ha, Hash.streamHash(Hash.treeHash(ha))));
        return Hash.hash(as -> {
            int p = 419;
            int r = 239;
            r = 419 * r + th.hash(as.focus());
            r = 419 * r + sth.hash(as.lefts());
            r = 419 * r + sth.hash(as.rights());
            r = 419 * r + tsp.hash(as.parents());
            return r;
        });
    }

    public static <A> Hash<Tree<A>> treeHash(Hash<A> ha) {
        return Hash.streamHash(ha).contramap(Tree.flatten_());
    }

    public static <K, V> Hash<TreeMap<K, V>> treeMapHash(Hash<K> h, Hash<V> v) {
        return Hash.hash(t -> Hash.streamHash(Hash.p2Hash(h, v)).hash(t.toStream()));
    }

    public static <A> Hash<P1<A>> p1Hash(Hash<A> ha) {
        return ha.contramap(P1.__1());
    }

    public static <A, B> Hash<P2<A, B>> p2Hash(Hash<A> ha, Hash<B> hb) {
        return Hash.hash(p2 -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(p2._1());
            r = 419 * r + hb.hash(p2._2());
            return r;
        });
    }

    public static <A, B, C> Hash<P3<A, B, C>> p3Hash(Hash<A> ha, Hash<B> hb, Hash<C> hc) {
        return Hash.hash(p3 -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(p3._1());
            r = 419 * r + hb.hash(p3._2());
            r = 419 * r + hc.hash(p3._3());
            return r;
        });
    }

    public static <A, B, C, D> Hash<P4<A, B, C, D>> p4Hash(Hash<A> ha, Hash<B> hb, Hash<C> hc, Hash<D> hd) {
        return Hash.hash(p4 -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(p4._1());
            r = 419 * r + hb.hash(p4._2());
            r = 419 * r + hc.hash(p4._3());
            r = 419 * r + hd.hash(p4._4());
            return r;
        });
    }

    public static <A, B, C, D, E> Hash<P5<A, B, C, D, E>> p5Hash(Hash<A> ha, Hash<B> hb, Hash<C> hc, Hash<D> hd, Hash<E> he) {
        return Hash.hash(p5 -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(p5._1());
            r = 419 * r + hb.hash(p5._2());
            r = 419 * r + hc.hash(p5._3());
            r = 419 * r + hd.hash(p5._4());
            r = 419 * r + he.hash(p5._5());
            return r;
        });
    }

    public static <A, B, C, D, E, F$> Hash<P6<A, B, C, D, E, F$>> p6Hash(Hash<A> ha, Hash<B> hb, Hash<C> hc, Hash<D> hd, Hash<E> he, Hash<F$> hf) {
        return Hash.hash(p6 -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(p6._1());
            r = 419 * r + hb.hash(p6._2());
            r = 419 * r + hc.hash(p6._3());
            r = 419 * r + hd.hash(p6._4());
            r = 419 * r + he.hash(p6._5());
            r = 419 * r + hf.hash(p6._6());
            return r;
        });
    }

    public static <A, B, C, D, E, F$, G> Hash<P7<A, B, C, D, E, F$, G>> p7Hash(Hash<A> ha, Hash<B> hb, Hash<C> hc, Hash<D> hd, Hash<E> he, Hash<F$> hf, Hash<G> hg) {
        return Hash.hash(p7 -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(p7._1());
            r = 419 * r + hb.hash(p7._2());
            r = 419 * r + hc.hash(p7._3());
            r = 419 * r + hd.hash(p7._4());
            r = 419 * r + he.hash(p7._5());
            r = 419 * r + hf.hash(p7._6());
            r = 419 * r + hg.hash(p7._7());
            return r;
        });
    }

    public static <A, B, C, D, E, F$, G, H> Hash<P8<A, B, C, D, E, F$, G, H>> p8Hash(Hash<A> ha, Hash<B> hb, Hash<C> hc, Hash<D> hd, Hash<E> he, Hash<F$> hf, Hash<G> hg, Hash<H> hh) {
        return Hash.hash(p8 -> {
            int p = 419;
            int r = 239;
            r = 419 * r + ha.hash(p8._1());
            r = 419 * r + hb.hash(p8._2());
            r = 419 * r + hc.hash(p8._3());
            r = 419 * r + hd.hash(p8._4());
            r = 419 * r + he.hash(p8._5());
            r = 419 * r + hf.hash(p8._6());
            r = 419 * r + hg.hash(p8._7());
            r = 419 * r + hh.hash(p8._8());
            return r;
        });
    }

    public static <A> Hash<V2<A>> v2Hash(Hash<A> ea) {
        return Hash.streamHash(ea).contramap(V2.toStream_());
    }

    public static <A> Hash<V3<A>> v3Hash(Hash<A> ea) {
        return Hash.streamHash(ea).contramap(V3.toStream_());
    }

    public static <A> Hash<V4<A>> v4Hash(Hash<A> ea) {
        return Hash.streamHash(ea).contramap(V4.toStream_());
    }

    public static <A> Hash<V5<A>> v5Hash(Hash<A> ea) {
        return Hash.streamHash(ea).contramap(V5.toStream_());
    }

    public static <A> Hash<V6<A>> v6Hash(Hash<A> ea) {
        return Hash.streamHash(ea).contramap(V6.toStream_());
    }

    public static <A> Hash<V7<A>> v7Hash(Hash<A> ea) {
        return Hash.streamHash(ea).contramap(V7.toStream_());
    }

    public static <A> Hash<V8<A>> v8Hash(Hash<A> ea) {
        return Hash.streamHash(ea).contramap(V8.toStream_());
    }
}

