/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.Bounded;
import fj.F;
import fj.F0;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.Semigroup;
import fj.Unit;
import fj.data.Array;
import fj.data.DList;
import fj.data.Enumerator;
import fj.data.IO;
import fj.data.List;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Monoid<A> {
    private final Definition<A> def;
    public static final Monoid<Integer> intAdditionMonoid = Monoid.monoidDef(new Definition<Integer>(){

        @Override
        public Integer empty() {
            return 0;
        }

        @Override
        public Integer append(Integer a1, Integer a2) {
            return a1 + a2;
        }

        @Override
        public Integer multiply(int n, Integer i) {
            return n <= 0 ? 0 : n * i;
        }
    });
    public static final Monoid<Integer> intMultiplicationMonoid = Monoid.monoidDef(new Definition<Integer>(){

        @Override
        public Integer empty() {
            return 1;
        }

        @Override
        public Integer append(Integer i1, Integer i2) {
            return i1 * i2;
        }

        @Override
        public Integer sum(F0<Stream<Integer>> as) {
            int x;
            Stream<Integer> xs = as.f();
            for (x = 1; x != 0 && !xs.isEmpty(); x *= xs.head().intValue()) {
                xs = xs.tail()._1();
            }
            return x;
        }

        @Override
        public Integer multiply(int n, Integer integer) {
            return n <= 0 ? 1 : (int)StrictMath.pow(integer.doubleValue(), n);
        }
    });
    public static final Monoid<BigInteger> bigintAdditionMonoid = Monoid.monoidDef(new Definition<BigInteger>(){

        @Override
        public BigInteger empty() {
            return BigInteger.ZERO;
        }

        @Override
        public BigInteger append(BigInteger a1, BigInteger a2) {
            return a1.add(a2);
        }

        @Override
        public BigInteger multiply(int n, BigInteger a) {
            return n <= 0 ? BigInteger.ZERO : a.multiply(BigInteger.valueOf(n));
        }
    });
    public static final Monoid<BigInteger> bigintMultiplicationMonoid = Monoid.monoidDef(new Definition<BigInteger>(){

        @Override
        public BigInteger empty() {
            return BigInteger.ONE;
        }

        @Override
        public BigInteger append(BigInteger a1, BigInteger a2) {
            return a1.multiply(a2);
        }

        @Override
        public BigInteger multiply(int n, BigInteger a) {
            return n <= 0 ? BigInteger.ONE : a.pow(n);
        }
    });
    public static final Monoid<BigDecimal> bigdecimalAdditionMonoid = Monoid.monoidDef(new Definition<BigDecimal>(){

        @Override
        public BigDecimal empty() {
            return BigDecimal.ZERO;
        }

        @Override
        public BigDecimal append(BigDecimal a1, BigDecimal a2) {
            return a1.add(a2);
        }

        @Override
        public BigDecimal multiply(int n, BigDecimal a) {
            return n <= 0 ? BigDecimal.ZERO : a.multiply(BigDecimal.valueOf(n));
        }
    });
    public static final Monoid<BigDecimal> bigdecimalMultiplicationMonoid = Monoid.monoidDef(new Definition<BigDecimal>(){

        @Override
        public BigDecimal empty() {
            return BigDecimal.ONE;
        }

        @Override
        public BigDecimal append(BigDecimal a1, BigDecimal a2) {
            return a1.multiply(a2);
        }

        @Override
        public BigDecimal multiply(int n, BigDecimal decimal) {
            return n <= 0 ? BigDecimal.ONE : decimal.pow(n);
        }
    });
    public static final Monoid<Natural> naturalAdditionMonoid = Monoid.monoidDef(new Definition<Natural>(){

        @Override
        public Natural empty() {
            return Natural.ZERO;
        }

        @Override
        public Natural append(Natural a1, Natural a2) {
            return a1.add(a2);
        }

        @Override
        public Natural multiply(int n, Natural a) {
            return Natural.natural(n).map(positiveN -> a.multiply((Natural)positiveN)).orSome(Natural.ZERO);
        }
    });
    public static final Monoid<Natural> naturalMultiplicationMonoid = Monoid.monoidDef(new Definition<Natural>(){

        @Override
        public Natural empty() {
            return Natural.ONE;
        }

        @Override
        public Natural append(Natural a1, Natural a2) {
            return a1.multiply(a2);
        }
    });
    public static final Monoid<Long> longAdditionMonoid = Monoid.monoidDef(new Definition<Long>(){

        @Override
        public Long empty() {
            return 0L;
        }

        @Override
        public Long append(Long a1, Long a2) {
            return a1 + a2;
        }

        @Override
        public Long multiply(int n, Long a) {
            return n <= 0 ? 0L : (long)n * a;
        }
    });
    public static final Monoid<Long> longMultiplicationMonoid = Monoid.monoidDef(new Definition<Long>(){

        @Override
        public Long empty() {
            return 1L;
        }

        @Override
        public Long append(Long i1, Long i2) {
            return i1 * i2;
        }

        @Override
        public Long sum(F0<Stream<Long>> as) {
            long x;
            Stream<Long> xs = as.f();
            for (x = 1L; x != 0L && !xs.isEmpty(); x *= xs.head().longValue()) {
                xs = xs.tail()._1();
            }
            return x;
        }

        @Override
        public Long multiply(int n, Long l) {
            return n <= 0 ? 1L : (long)StrictMath.pow(l.doubleValue(), n);
        }
    });
    public static final Monoid<Boolean> disjunctionMonoid = Monoid.monoidDef(new Definition<Boolean>(){

        @Override
        public Boolean empty() {
            return false;
        }

        @Override
        public Boolean append(Boolean a1, Boolean a2) {
            return a1 | a2;
        }

        @Override
        public Boolean sum(F0<Stream<Boolean>> as) {
            return as.f().filter(Function.identity()).isNotEmpty();
        }

        @Override
        public Boolean multiply(int n, Boolean a) {
            return n <= 0 ? false : a;
        }
    });
    public static final Monoid<Boolean> exclusiveDisjunctionMonoid = Monoid.monoidDef(new Definition<Boolean>(){

        @Override
        public Boolean empty() {
            return false;
        }

        @Override
        public Boolean append(Boolean a1, Boolean a2) {
            return a1 ^ a2;
        }

        @Override
        public Boolean multiply(int n, Boolean a) {
            return a != false && n == 1;
        }
    });
    public static final Monoid<Boolean> conjunctionMonoid = Monoid.monoidDef(new Definition<Boolean>(){

        @Override
        public Boolean empty() {
            return true;
        }

        @Override
        public Boolean append(Boolean a1, Boolean a2) {
            return a1 & a2;
        }

        @Override
        public Boolean multiply(int n, Boolean a) {
            return a;
        }

        @Override
        public Boolean sum(F0<Stream<Boolean>> as) {
            return as.f().filter(a -> a == false).isEmpty();
        }
    });
    public static final Monoid<String> stringMonoid = Monoid.monoidDef(new Definition<String>(){

        @Override
        public String empty() {
            return "";
        }

        @Override
        public String append(String a1, String a2) {
            return a1.concat(a2);
        }

        @Override
        public String sum(F0<Stream<String>> as) {
            StringBuilder sb = new StringBuilder();
            as.f().foreachDoEffect(sb::append);
            return sb.toString();
        }
    });
    public static final Monoid<StringBuffer> stringBufferMonoid = Monoid.monoidDef((A s1, A s2) -> new StringBuffer((CharSequence)s1).append((StringBuffer)s2), new StringBuffer(0));
    public static final Monoid<StringBuilder> stringBuilderMonoid = Monoid.monoidDef((A s1, A s2) -> new StringBuilder((CharSequence)s1).append((CharSequence)s2), new StringBuilder(0));
    public static final Monoid<Integer> intMaxMonoid = Monoid.monoidDef(new Definition<Integer>(){

        @Override
        public Integer empty() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer append(Integer a1, Integer a2) {
            return Math.max(a1, a2);
        }

        @Override
        public Integer multiply(int n, Integer a) {
            return a;
        }
    });
    public static final Monoid<Integer> intMinMonoid = Monoid.monoidDef(new Definition<Integer>(){

        @Override
        public Integer empty() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer append(Integer a1, Integer a2) {
            return Math.min(a1, a2);
        }

        @Override
        public Integer multiply(int n, Integer a) {
            return a;
        }
    });
    public static final Monoid<Unit> unitMonoid = Monoid.monoidDef(new Definition<Unit>(){

        @Override
        public Unit empty() {
            return Unit.unit();
        }

        @Override
        public Unit append(Unit a1, Unit a2) {
            return Unit.unit();
        }
    });

    private Monoid(Definition<A> def) {
        this.def = def;
    }

    public <B> Monoid<P2<A, B>> compose(Monoid<B> m) {
        return this.compose(m, P2.__1(), P2.__2(), P::p);
    }

    public Semigroup<A> semigroup() {
        return Semigroup.semigroupDef(this.def);
    }

    public <B> Monoid<B> xmap(final F<A, B> f, final F<B, A> g) {
        final Definition<A> def = this.def;
        final B zero = f.f(def.empty());
        return Monoid.monoidDef(new Definition<B>(){

            @Override
            public B empty() {
                return zero;
            }

            @Override
            public B append(B a1, B a2) {
                return f.f(def.append(g.f(a1), g.f(a2)));
            }

            @Override
            public F<B, B> prepend(B b) {
                return def.prepend(g.f(b)).dimap(g, f);
            }

            @Override
            public B multiply(int n, B b) {
                return f.f(def.multiply(n, g.f(b)));
            }

            @Override
            public B sum(F0<Stream<B>> as) {
                return f.f(def.sum(() -> ((Stream)as.f()).map(g)));
            }
        });
    }

    public <B, C> Monoid<C> compose(Monoid<B> mb, final F<C, A> a, final F<C, B> b, final F2<A, B, C> c) {
        final Definition<A> maDef = this.def;
        final Definition<A> mbDef = mb.def;
        final C empty = c.f(maDef.empty(), mbDef.empty());
        return Monoid.monoidDef(new Definition<C>(){

            @Override
            public C empty() {
                return empty;
            }

            @Override
            public C append(C c1, C c2) {
                return c.f(maDef.append(a.f(c1), a.f(c2)), mbDef.append(b.f(c1), b.f(c2)));
            }

            @Override
            public F<C, C> prepend(C c1) {
                F prependA = maDef.prepend(a.f(c1));
                F prependB = mbDef.prepend(b.f(c1));
                return c2 -> c.f(prependA.f(a.f(c2)), prependB.f(b.f(c2)));
            }

            @Override
            public C multiply(int n, C c1) {
                return c.f(maDef.multiply(n, a.f(c1)), mbDef.multiply(n, b.f(c1)));
            }

            @Override
            public C sum(F0<Stream<C>> cs) {
                return c.f(maDef.sum(() -> ((Stream)cs.f()).map(a)), mbDef.sum(() -> ((Stream)cs.f()).map(b)));
            }
        });
    }

    public A sum(A a1, A a2) {
        return this.def.append(a1, a2);
    }

    public F<A, A> sum(A a1) {
        return this.def.prepend(a1);
    }

    public F<A, F<A, A>> sum() {
        return this.def::prepend;
    }

    public A zero() {
        return this.def.empty();
    }

    public A multiply(int n, A a) {
        return this.def.multiply(n, a);
    }

    public A sumRight(List<A> as) {
        return (A)as.foldRight(this.def::append, this.def.empty());
    }

    public A sumRight(Stream<A> as) {
        return (A)as.foldRight1(this.def::append, this.def.empty());
    }

    public A sumLeft(List<A> as) {
        return (A)as.foldLeft(this.def::append, this.def.empty());
    }

    public A sumLeft(Stream<A> as) {
        return this.def.sum(() -> as);
    }

    public F<List<A>, A> sumLeft() {
        return this::sumLeft;
    }

    public F<List<A>, A> sumRight() {
        return this::sumRight;
    }

    public F<Stream<A>, A> sumLeftS() {
        return this::sumLeft;
    }

    public A join(Iterable<A> as, A a) {
        Stream<Object> s = Stream.iterableStream(as);
        F<A, A> prependA = this.def.prepend(a);
        return (A)(s.isEmpty() ? this.def.empty() : s.foldLeft1((a1, a2) -> this.def.append(a1, prependA.f(a2))));
    }

    public Monoid<A> dual() {
        return Monoid.monoidDef(this.def.dual());
    }

    public static <A> Monoid<A> monoidDef(Definition<A> def) {
        return new Monoid<A>(def);
    }

    public static <A> Monoid<A> monoidDef(AltDefinition<A> def) {
        return new Monoid<A>(def);
    }

    public static <A> Monoid<A> monoidDef(final Semigroup.Definition<A> s, final A zero) {
        return new Monoid<A>(new Definition<A>(){

            @Override
            public A empty() {
                return zero;
            }

            @Override
            public A sum(F0<Stream<A>> as) {
                return s.sum(zero, as);
            }

            @Override
            public A sum(A a, F0<Stream<A>> as) {
                return s.sum(a, as);
            }

            @Override
            public A multiply(int n, A a) {
                return n <= 0 ? zero : s.multiply1p(n - 1, a);
            }

            @Override
            public A multiply1p(int n, A a) {
                return s.multiply1p(n, a);
            }

            @Override
            public A append(A a1, A a2) {
                return s.append(a1, a2);
            }

            @Override
            public F<A, A> prepend(A a) {
                return s.prepend(a);
            }
        });
    }

    public static <A> Monoid<A> monoidDef(Semigroup.AltDefinition<A> s, A zero) {
        return Monoid.monoidDef(s, zero);
    }

    public static <A> Monoid<A> monoid(final F<A, F<A, A>> sum, final A zero) {
        return new Monoid<A>(new AltDefinition<A>(){

            @Override
            public F<A, A> prepend(A a) {
                return (F)sum.f(a);
            }

            @Override
            public A empty() {
                return zero;
            }
        });
    }

    public static <A> Monoid<A> monoid(final F2<A, A, A> sum, final A zero) {
        return new Monoid<A>(new Definition<A>(){

            @Override
            public A empty() {
                return zero;
            }

            @Override
            public A append(A a1, A a2) {
                return sum.f(a1, a2);
            }
        });
    }

    public static <A, B> Monoid<F<A, B>> functionMonoid(Monoid<B> mb) {
        final Definition<A> mbDef = mb.def;
        return Monoid.monoidDef(new Definition<F<A, B>>(){

            @Override
            public F<A, B> empty() {
                return __ -> mbDef.empty();
            }

            @Override
            public F<A, B> append(F<A, B> a1, F<A, B> a2) {
                return a -> mbDef.append(a1.f(a), a2.f(a));
            }
        });
    }

    public static <A> Monoid<List<A>> listMonoid() {
        return Monoid.monoidDef(new Definition<List<A>>(){

            @Override
            public List<A> empty() {
                return List.nil();
            }

            @Override
            public List<A> append(List<A> a1, List<A> a2) {
                return a1.append(a2);
            }

            @Override
            public List<A> sum(F0<Stream<List<A>>> as) {
                return as.f().map(DList::listDList).foldLeft(DList::append, DList.nil()).run();
            }
        });
    }

    public static <A> Monoid<Option<A>> optionMonoid(final Semigroup<A> aSemigroup) {
        return Monoid.monoidDef(new Definition<Option<A>>(){

            @Override
            public Option<A> empty() {
                return Option.none();
            }

            @Override
            public Option<A> append(Option<A> a1, Option<A> a2) {
                return a1.liftM2(a2, aSemigroup::sum).orElse(a1).orElse(a2);
            }

            @Override
            public Option<A> multiply(int n, Option<A> oa) {
                return n > 0 ? oa.map(a -> aSemigroup.multiply1p(n - 1, a)) : Option.none();
            }

            @Override
            public Option<A> sum(F0<Stream<Option<A>>> oas) {
                Stream as = oas.f().bind(Option::toStream);
                return as.uncons(Option.none(), h -> tail -> Option.some(aSemigroup.sumStream(h, tail::_1)));
            }
        });
    }

    public static <A> Monoid<Option<A>> firstOptionMonoid() {
        return Monoid.monoidDef(new Definition<Option<A>>(){

            @Override
            public Option<A> empty() {
                return Option.none();
            }

            @Override
            public Option<A> append(Option<A> a1, Option<A> a2) {
                return a1.orElse(a2);
            }

            @Override
            public F<Option<A>, Option<A>> prepend(Option<A> a1) {
                return a1.isSome() ? __ -> a1 : Function.identity();
            }

            @Override
            public Option<A> multiply(int n, Option<A> as) {
                return as;
            }

            @Override
            public Option<A> sum(F0<Stream<Option<A>>> as) {
                return as.f().filter(Option.isSome_()).orHead(Option::none);
            }
        });
    }

    public static <A> Monoid<Option<A>> lastOptionMonoid() {
        return Monoid.monoidDef(new Definition<Option<A>>(){

            @Override
            public Option<A> empty() {
                return Option.none();
            }

            @Override
            public Option<A> append(Option<A> a1, Option<A> a2) {
                return a2.orElse(a1);
            }

            @Override
            public F<Option<A>, Option<A>> prepend(Option<A> a1) {
                return a1.isNone() ? Function.identity() : a2 -> a2.orElse(a1);
            }

            @Override
            public Option<A> multiply(int n, Option<A> as) {
                return as;
            }
        });
    }

    public static <A> Monoid<Stream<A>> streamMonoid() {
        return Monoid.monoidDef(new Definition<Stream<A>>(){

            @Override
            public Stream<A> empty() {
                return Stream.nil();
            }

            @Override
            public Stream<A> append(Stream<A> a1, Stream<A> a2) {
                return a1.append(a2);
            }

            @Override
            public Stream<A> sum(F0<Stream<Stream<A>>> as) {
                return Stream.join(as.f());
            }
        });
    }

    public static <A> Monoid<Array<A>> arrayMonoid() {
        return Monoid.monoidDef(new Definition<Array<A>>(){

            @Override
            public Array<A> empty() {
                return Array.empty();
            }

            @Override
            public Array<A> append(Array<A> a1, Array<A> a2) {
                return a1.append(a2);
            }
        });
    }

    public static <A> Monoid<IO<A>> ioMonoid(Monoid<A> ma) {
        final Definition<A> maDef = ma.def;
        return Monoid.monoidDef(new Definition<IO<A>>(){

            @Override
            public IO<A> empty() {
                return () -> maDef.empty();
            }

            @Override
            public IO<A> append(IO<A> a1, IO<A> a2) {
                return () -> maDef.append(a1.run(), a2.run());
            }
        });
    }

    public static <A> Monoid<Set<A>> setMonoid(final Ord<A> o) {
        return Monoid.monoidDef(new Definition<Set<A>>(){

            @Override
            public Set<A> empty() {
                return Set.empty(o);
            }

            @Override
            public Set<A> append(Set<A> a1, Set<A> a2) {
                return a1.union(a2);
            }
        });
    }

    public static <A> Monoid<Set<A>> setIntersectionMonoid(final Bounded<A> bounded, final Enumerator<A> enumerator) {
        return Monoid.monoidDef(new Definition<Set<A>>(){

            @Override
            public Set<A> empty() {
                return Set.iteratorSet(enumerator.order(), enumerator.toStream(bounded).iterator());
            }

            @Override
            public Set<A> append(Set<A> a1, Set<A> a2) {
                return a1.intersect(a2);
            }
        });
    }

    public static interface AltDefinition<A>
    extends Definition<A> {
        @Override
        public F<A, A> prepend(A var1);

        @Override
        default public A append(A a1, A a2) {
            return this.prepend(a1).f(a2);
        }
    }

    public static interface Definition<A>
    extends Semigroup.Definition<A> {
        public A empty();

        default public A sum(F0<Stream<A>> as) {
            return (A)as.f().foldLeft(this::append, this.empty());
        }

        @Override
        default public A sum(A a, F0<Stream<A>> as) {
            return this.sum(() -> Stream.cons(a, as));
        }

        default public A multiply(int n, A a) {
            return n <= 0 ? this.empty() : Semigroup.Definition.super.multiply1p(n - 1, a);
        }

        @Override
        default public A multiply1p(int n, A a) {
            return n == Integer.MAX_VALUE ? this.append(a, this.multiply(n, a)) : this.multiply(n + 1, a);
        }

        @Override
        default public Definition<A> dual() {
            return new Definition<A>(){

                @Override
                public A empty() {
                    return this.empty();
                }

                @Override
                public A append(A a1, A a2) {
                    return this.append(a2, a1);
                }

                @Override
                public A multiply(int n, A a) {
                    return this.multiply(n, a);
                }

                @Override
                public Definition<A> dual() {
                    return this;
                }
            };
        }
    }
}

