/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F0;
import fj.Function;
import fj.Hash;
import fj.P;
import fj.P1;
import fj.Unit;
import fj.data.Array;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Effect1;
import java.util.Collection;
import java.util.Iterator;

public abstract class Either3<A, B, C> {
    private Either3() {
    }

    public final <X> Either3<X, B, C> leftMap(F<A, X> f) {
        return this.left().map(f);
    }

    public final <X> F<F<A, X>, Either3<X, B, C>> leftMap_() {
        return this::leftMap;
    }

    public final <X> Either3<A, X, C> middleMap(F<B, X> f) {
        return this.middle().map(f);
    }

    public final <X> F<F<B, X>, Either3<A, X, C>> middleMap_() {
        return this::middleMap;
    }

    public final <X> Either3<A, B, X> rightMap(F<C, X> f) {
        return this.right().map(f);
    }

    public final <X> F<F<C, X>, Either3<A, B, X>> rightMap_() {
        return this::rightMap;
    }

    public static <A, B, C> Either3<A, B, C> left(A a) {
        return new Left(a);
    }

    public static <A, B, C> F<A, Either3<A, B, C>> left_() {
        return Either3::left;
    }

    public static <A, B, C> Either3<A, B, C> middle(B b) {
        return new Middle(b);
    }

    public static <A, B, C> Either3<A, B, C> right(C c) {
        return new Right(c);
    }

    public boolean isLeft() {
        return this.either(a -> true, b -> false, c -> false);
    }

    public boolean isMiddle() {
        return this.either(a -> false, b -> true, c -> false);
    }

    public boolean isRight() {
        return this.either(a -> false, b -> false, c -> true);
    }

    public <X, Y, Z> Either3<X, Y, Z> map3(F<A, X> fl, F<B, Y> fm, F<C, Z> fr) {
        return this.either(a -> Either3.left(fl.f(a)), b -> Either3.middle(fm.f(b)), c -> Either3.right(fr.f(c)));
    }

    public abstract <D> D either(F<A, D> var1, F<B, D> var2, F<C, D> var3);

    public static <A, B, C, D> F<Either3<A, B, C>, D> either_(F<A, D> fa, F<B, D> fb, F<C, D> fc) {
        return e -> e.either(fa, fb, fc);
    }

    public static <A, B, C> Either3<A, B, C> joinLeft(Either3<Either3<A, B, C>, B, C> e) {
        return e.left().bind(Function.identity());
    }

    public static <A, B, C> Either3<A, B, C> joinMiddle(Either3<A, Either3<A, B, C>, C> e) {
        return e.middle().bind(Function.identity());
    }

    public static <A, B, C> Either3<A, B, C> joinRight(Either3<A, B, Either3<A, B, C>> e) {
        return e.right().bind(Function.identity());
    }

    public Either3<B, C, A> moveLeft() {
        return this.either(a -> Either3.right(a), b -> Either3.left(b), c -> Either3.middle(c));
    }

    public Either3<C, A, B> moveRight() {
        return this.either(a -> Either3.middle(a), b -> Either3.right(b), c -> Either3.left(c));
    }

    public Either3<C, B, A> swap() {
        return this.either(a -> Either3.right(a), b -> Either3.middle(b), c -> Either3.left(c));
    }

    public Either3<B, A, C> swapLefts() {
        return this.either(a -> Either3.middle(a), b -> Either3.left(b), c -> Either3.right(c));
    }

    public Either3<A, C, B> swapRights() {
        return this.either(a -> Either3.left(a), b -> Either3.right(b), c -> Either3.middle(c));
    }

    public Option<A> leftOption() {
        return this.either(a -> Option.some(a), b -> Option.none(), c -> Option.none());
    }

    public Option<B> middleOption() {
        return this.either(a -> Option.none(), b -> Option.some(b), c -> Option.none());
    }

    public Option<C> rightOption() {
        return this.either(a -> Option.none(), b -> Option.none(), c -> Option.some(c));
    }

    public final LeftProjection<A, B, C> left() {
        return new LeftProjection(this);
    }

    public final MiddleProjection<A, B, C> middle() {
        return new MiddleProjection(this);
    }

    public final RightProjection<A, B, C> right() {
        return new RightProjection(this);
    }

    public final boolean equals(Object other) {
        return Equal.equals0(Either3.class, this, other, () -> Equal.either3Equal(Equal.anyEqual(), Equal.anyEqual(), Equal.anyEqual()));
    }

    public final int hashCode() {
        return Hash.either3Hash(Hash.anyHash(), Hash.anyHash(), Hash.anyHash()).hash(this);
    }

    public static final class RightProjection<A, B, C> {
        private final Either3<A, B, C> e;

        private RightProjection(Either3<A, B, C> e) {
            this.e = e;
        }

        public <X> Either3<A, B, X> apply(Either3<A, B, F<C, X>> e) {
            return e.right().bind(this::map);
        }

        public <X> Either3<A, B, X> bind(F<C, Either3<A, B, X>> f) {
            return this.e.either(a -> Either3.left(a), b -> Either3.middle(b), c -> (Either3)f.f(c));
        }

        public Either3<A, B, C> either() {
            return this.e;
        }

        public boolean exists(F<C, Boolean> f) {
            return this.e.either(a -> false, b -> false, c -> (Boolean)f.f(c));
        }

        public <X, Y> Option<Either3<X, Y, C>> filter(F<C, Boolean> f) {
            return this.e.either(a -> Option.none(), b -> Option.none(), c -> (Boolean)f.f(c) != false ? Option.some(Either3.right(c)) : Option.none());
        }

        public boolean forall(F<C, Boolean> f) {
            return this.e.either(a -> true, b -> true, c -> (Boolean)f.f(c));
        }

        public Unit foreach(F<C, Unit> f) {
            return this.e.either(a -> Unit.unit(), b -> Unit.unit(), c -> (Unit)f.f(c));
        }

        public void foreachDoEffect(Effect1<C> f) {
            this.e.either(a -> Unit.unit(), b -> Unit.unit(), c -> f.toF().f(c));
        }

        public Iterator<C> iterator() {
            return this.toList().iterator();
        }

        public <X> Either3<A, B, X> map(F<C, X> f) {
            return this.e.either(a -> Either3.left(a), b -> Either3.middle(b), c -> Either3.right(f.f(c)));
        }

        public C orValue(C value) {
            return (C)this.orValue(() -> value);
        }

        public C orValue(F0<C> f) {
            return (C)this.e.either(a -> f.f(), b -> f.f(), c -> c);
        }

        public <X> Either3<A, B, X> sequence(Either3<A, B, X> e) {
            return this.bind(Function.constant(e));
        }

        public Array<C> toArray() {
            return this.e.either(a -> Array.empty(), b -> Array.empty(), c -> Array.single(c));
        }

        public Collection<C> toCollection() {
            return this.toList().toCollection();
        }

        public List<C> toList() {
            return this.e.either(a -> List.nil(), b -> List.nil(), c -> List.single(c));
        }

        public Option<C> toOption() {
            return this.e.either(a -> Option.none(), b -> Option.none(), c -> Option.some(c));
        }

        public Stream<C> toStream() {
            return this.e.either(a -> Stream.nil(), b -> Stream.nil(), c -> Stream.single(c));
        }

        public <X> IO<Either3<A, B, X>> traverseIO(F<C, IO<X>> f) {
            return this.e.either(a -> IOFunctions.unit(Either3.left(a)), b -> IOFunctions.unit(Either3.middle(b)), c -> ((IO)f.f(c)).map(Either3::right));
        }

        public <X> List<Either3<A, B, X>> traverseList1(F<C, List<X>> f) {
            return this.e.either(a -> List.single(Either3.left(a)), b -> List.single(Either3.middle(b)), c -> ((List)f.f(c)).map(Either3::right));
        }

        public <X> Option<Either3<A, B, X>> traverseOption(F<C, Option<X>> f) {
            return this.e.either(a -> Option.some(Either3.left(a)), b -> Option.some(Either3.middle(b)), c -> ((Option)f.f(c)).map(Either3::right));
        }

        public <X> P1<Either3<A, B, X>> traverseP1(F<C, P1<X>> f) {
            return this.e.either(a -> P.p(Either3.left(a)), b -> P.p(Either3.middle(b)), c -> ((P1)f.f(c)).map(Either3::right));
        }

        public <X> Stream<Either3<A, B, X>> traverseStream(F<C, Stream<X>> f) {
            return this.e.either(a -> Stream.single(Either3.left(a)), b -> Stream.single(Either3.middle(b)), c -> ((Stream)f.f(c)).map(Either3::right));
        }
    }

    public static final class MiddleProjection<A, B, C> {
        private final Either3<A, B, C> e;

        private MiddleProjection(Either3<A, B, C> e) {
            this.e = e;
        }

        public <X> Either3<A, X, C> apply(Either3<A, F<B, X>, C> e) {
            return e.middle().bind(this::map);
        }

        public <X> Either3<A, X, C> bind(F<B, Either3<A, X, C>> f) {
            return this.e.either(a -> Either3.left(a), b -> (Either3)f.f(b), c -> Either3.right(c));
        }

        public Either3<A, B, C> either() {
            return this.e;
        }

        public boolean exists(F<B, Boolean> f) {
            return this.e.either(a -> false, b -> (Boolean)f.f(b), c -> false);
        }

        public <X, Y> Option<Either3<X, B, Y>> filter(F<B, Boolean> f) {
            return this.e.either(a -> Option.none(), b -> (Boolean)f.f(b) != false ? Option.some(Either3.middle(b)) : Option.none(), c -> Option.none());
        }

        public boolean forall(F<B, Boolean> f) {
            return this.e.either(a -> true, b -> (Boolean)f.f(b), c -> true);
        }

        public Unit foreach(F<B, Unit> f) {
            return this.e.either(a -> Unit.unit(), b -> (Unit)f.f(b), c -> Unit.unit());
        }

        public void foreachDoEffect(Effect1<B> f) {
            this.e.either(a -> Unit.unit(), b -> f.toF().f(b), c -> Unit.unit());
        }

        public Iterator<B> iterator() {
            return this.toList().iterator();
        }

        public <X> Either3<A, X, C> map(F<B, X> f) {
            return this.e.either(a -> Either3.left(a), b -> Either3.middle(f.f(b)), c -> Either3.right(c));
        }

        public B orValue(B value) {
            return (B)this.orValue(() -> value);
        }

        public B orValue(F0<B> f) {
            return (B)this.e.either(a -> f.f(), b -> b, c -> f.f());
        }

        public <X> Either3<A, X, C> sequence(Either3<A, X, C> e) {
            return this.bind(Function.constant(e));
        }

        public Array<B> toArray() {
            return this.e.either(a -> Array.empty(), b -> Array.single(b), c -> Array.empty());
        }

        public Collection<B> toCollection() {
            return this.toList().toCollection();
        }

        public List<B> toList() {
            return this.e.either(a -> List.nil(), b -> List.single(b), c -> List.nil());
        }

        public Option<B> toOption() {
            return this.e.either(a -> Option.none(), b -> Option.some(b), c -> Option.none());
        }

        public Stream<B> toStream() {
            return this.e.either(a -> Stream.nil(), b -> Stream.single(b), c -> Stream.nil());
        }

        public <X> IO<Either3<A, X, C>> traverseIO(F<B, IO<X>> f) {
            return this.e.either(a -> IOFunctions.unit(Either3.left(a)), b -> ((IO)f.f(b)).map(Either3::middle), c -> IOFunctions.unit(Either3.right(c)));
        }

        public <X> List<Either3<A, X, C>> traverseList1(F<B, List<X>> f) {
            return this.e.either(a -> List.single(Either3.left(a)), b -> ((List)f.f(b)).map(Either3::middle), c -> List.single(Either3.right(c)));
        }

        public <X> Option<Either3<A, X, C>> traverseOption(F<B, Option<X>> f) {
            return this.e.either(a -> Option.some(Either3.left(a)), b -> ((Option)f.f(b)).map(Either3::middle), c -> Option.some(Either3.right(c)));
        }

        public <X> P1<Either3<A, X, C>> traverseP1(F<B, P1<X>> f) {
            return this.e.either(a -> P.p(Either3.left(a)), b -> ((P1)f.f(b)).map(Either3::middle), c -> P.p(Either3.right(c)));
        }

        public <X> Stream<Either3<A, X, C>> traverseStream(F<B, Stream<X>> f) {
            return this.e.either(a -> Stream.single(Either3.left(a)), b -> ((Stream)f.f(b)).map(Either3::middle), c -> Stream.single(Either3.right(c)));
        }
    }

    public static final class LeftProjection<A, B, C> {
        private final Either3<A, B, C> e;

        private LeftProjection(Either3<A, B, C> e) {
            this.e = e;
        }

        public <X> Either3<X, B, C> apply(Either3<F<A, X>, B, C> e) {
            return e.left().bind(this::map);
        }

        public <X> Either3<X, B, C> bind(F<A, Either3<X, B, C>> f) {
            return this.e.either(a -> (Either3)f.f(a), b -> Either3.middle(b), c -> Either3.right(c));
        }

        public Either3<A, B, C> either() {
            return this.e;
        }

        public boolean exists(F<A, Boolean> f) {
            return this.e.either(a -> (Boolean)f.f(a), b -> false, c -> false);
        }

        public <X, Y> Option<Either3<A, X, Y>> filter(F<A, Boolean> f) {
            return this.e.either(a -> (Boolean)f.f(a) != false ? Option.some(Either3.left(a)) : Option.none(), b -> Option.none(), c -> Option.none());
        }

        public boolean forall(F<A, Boolean> f) {
            return this.e.either(a -> (Boolean)f.f(a), b -> true, c -> true);
        }

        public Unit foreach(F<A, Unit> f) {
            return this.e.either(a -> (Unit)f.f(a), b -> Unit.unit(), c -> Unit.unit());
        }

        public void foreachDoEffect(Effect1<A> f) {
            this.e.either(a -> f.toF().f(a), b -> Unit.unit(), c -> Unit.unit());
        }

        public Iterator<A> iterator() {
            return this.toList().iterator();
        }

        public <X> Either3<X, B, C> map(F<A, X> f) {
            return this.e.either(a -> Either3.left(f.f(a)), b -> Either3.middle(b), c -> Either3.right(c));
        }

        public A orValue(A value) {
            return (A)this.orValue(() -> value);
        }

        public A orValue(F0<A> f) {
            return (A)this.e.either(a -> a, b -> f.f(), c -> f.f());
        }

        public <X> Either3<X, B, C> sequence(Either3<X, B, C> e) {
            return this.bind(Function.constant(e));
        }

        public Array<A> toArray() {
            return this.e.either(a -> Array.single(a), b -> Array.empty(), c -> Array.empty());
        }

        public Collection<A> toCollection() {
            return this.toList().toCollection();
        }

        public List<A> toList() {
            return this.e.either(a -> List.single(a), b -> List.nil(), c -> List.nil());
        }

        public Option<A> toOption() {
            return this.e.either(a -> Option.some(a), b -> Option.none(), c -> Option.none());
        }

        public Stream<A> toStream() {
            return this.e.either(a -> Stream.single(a), b -> Stream.nil(), c -> Stream.nil());
        }

        public <X> IO<Either3<X, B, C>> traverseIO(F<A, IO<X>> f) {
            return this.e.either(a -> ((IO)f.f(a)).map(Either3::left), b -> IOFunctions.unit(Either3.middle(b)), c -> IOFunctions.unit(Either3.right(c)));
        }

        public <X> List<Either3<X, B, C>> traverseList1(F<A, List<X>> f) {
            return this.e.either(a -> ((List)f.f(a)).map(Either3::left), b -> List.single(Either3.middle(b)), c -> List.single(Either3.right(c)));
        }

        public <X> Option<Either3<X, B, C>> traverseOption(F<A, Option<X>> f) {
            return this.e.either(a -> ((Option)f.f(a)).map(Either3::left), b -> Option.some(Either3.middle(b)), c -> Option.some(Either3.right(c)));
        }

        public <X> P1<Either3<X, B, C>> traverseP1(F<A, P1<X>> f) {
            return this.e.either(a -> ((P1)f.f(a)).map(Either3::left), b -> P.p(Either3.middle(b)), c -> P.p(Either3.right(c)));
        }

        public <X> Stream<Either3<X, B, C>> traverseStream(F<A, Stream<X>> f) {
            return this.e.either(a -> ((Stream)f.f(a)).map(Either3::left), b -> Stream.single(Either3.middle(b)), c -> Stream.single(Either3.right(c)));
        }
    }

    private static final class Right<A, B, C>
    extends Either3<A, B, C> {
        private final C c;

        Right(C c) {
            this.c = c;
        }

        @Override
        public <D> D either(F<A, D> fa, F<B, D> fb, F<C, D> fc) {
            return fc.f(this.c);
        }
    }

    private static final class Middle<A, B, C>
    extends Either3<A, B, C> {
        private final B b;

        Middle(B b) {
            this.b = b;
        }

        @Override
        public <D> D either(F<A, D> fa, F<B, D> fb, F<C, D> fc) {
            return fb.f(this.b);
        }
    }

    private static final class Left<A, B, C>
    extends Either3<A, B, C> {
        private final A a;

        Left(A a) {
            this.a = a;
        }

        @Override
        public <D> D either(F<A, D> fa, F<B, D> fb, F<C, D> fc) {
            return fa.f(this.a);
        }
    }
}

