/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.Unit;
import fj.data.IOFunctions;
import fj.data.LazyString;
import fj.data.SafeIO;
import fj.data.Validation;
import fj.function.Try0;
import java.io.IOException;

@FunctionalInterface
public interface IO<A>
extends Try0<A, IOException> {
    public A run() throws IOException;

    @Override
    default public A f() throws IOException {
        return this.run();
    }

    default public SafeIO<Validation<IOException, A>> safe() {
        return IOFunctions.toSafeValidation(this);
    }

    default public <B> IO<B> map(F<A, B> f) {
        return IOFunctions.map(this, f);
    }

    default public <B> IO<B> bind(F<A, IO<B>> f) {
        return IOFunctions.bind(this, f);
    }

    default public <B> IO<B> append(IO<B> iob) {
        return IOFunctions.append(this, iob);
    }

    public static IO<LazyString> getContents() {
        return () -> IOFunctions.getContents().run();
    }

    public static IO<Unit> interact(F<LazyString, LazyString> f) {
        return () -> IOFunctions.interact(f).run();
    }
}

