/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F0;
import fj.F2;
import fj.Function;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.Show;
import fj.Unit;
import fj.control.Trampoline;
import fj.data.Array;
import fj.data.Either;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.List;
import fj.data.Seq;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Validation;
import fj.data.optic.PPrism;
import fj.data.optic.Prism;
import fj.function.Effect1;
import java.util.Collection;
import java.util.Iterator;

public abstract class Option<A>
implements Iterable<A> {
    public static final F<String, Option<Byte>> parseByte = s -> Validation.parseByte(s).toOption();
    public static final F<String, Option<Double>> parseDouble = s -> Validation.parseDouble(s).toOption();
    public static final F<String, Option<Float>> parseFloat = s -> Validation.parseFloat(s).toOption();
    public static final F<String, Option<Integer>> parseInt = s -> Validation.parseInt(s).toOption();
    public static final F<String, Option<Long>> parseLong = s -> Validation.parseLong(s).toOption();
    public static final F<String, Option<Short>> parseShort = s -> Validation.parseShort(s).toOption();

    private Option() {
    }

    public final String toString() {
        return Show.optionShow(Show.anyShow()).showS(this);
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A some();

    public final boolean isSome() {
        return this instanceof Some;
    }

    public final boolean isNone() {
        return this instanceof None;
    }

    public static <A> F<Option<A>, Boolean> isSome_() {
        return Option::isSome;
    }

    public static <A> F<Option<A>, Boolean> isNone_() {
        return Option::isNone;
    }

    public final <B> B option(B b, F<A, B> f) {
        return this.isSome() ? f.f(this.some()) : b;
    }

    public final <B> B option(F0<B> b, F<A, B> f) {
        return this.isSome() ? f.f(this.some()) : b.f();
    }

    public final int length() {
        return this.isSome() ? 1 : 0;
    }

    public final A orSome(F0<A> a) {
        return this.isSome() ? this.some() : a.f();
    }

    public final A orSome(A a) {
        return this.isSome() ? this.some() : a;
    }

    public final A valueE(F0<String> message) {
        if (this.isSome()) {
            return this.some();
        }
        throw Bottom.error(message.f());
    }

    public final A valueE(String message) {
        if (this.isSome()) {
            return this.some();
        }
        throw Bottom.error(message);
    }

    public final <B> Option<B> map(F<A, B> f) {
        return this.isSome() ? Option.some(f.f(this.some())) : Option.none();
    }

    public static <A, B> F<F<A, B>, F<Option<A>, Option<B>>> map() {
        return Function.curry((abf, option) -> option.map((F)abf));
    }

    public final Unit foreach(F<A, Unit> f) {
        return this.isSome() ? f.f(this.some()) : Unit.unit();
    }

    public final void foreachDoEffect(Effect1<A> f) {
        if (this.isSome()) {
            f.f(this.some());
        }
    }

    public final Option<A> filter(F<A, Boolean> f) {
        return this.isSome() ? (f.f(this.some()).booleanValue() ? this : Option.none()) : Option.none();
    }

    public final <B> Option<B> bind(F<A, Option<B>> f) {
        return this.isSome() ? f.f(this.some()) : Option.none();
    }

    public final <B, C> Option<C> bind(Option<B> ob, F<A, F<B, C>> f) {
        return ob.apply(this.map(f));
    }

    public final <B, C, D> Option<D> bind(Option<B> ob, Option<C> oc, F<A, F<B, F<C, D>>> f) {
        return oc.apply(this.bind(ob, f));
    }

    public final <B, C, D, E> Option<E> bind(Option<B> ob, Option<C> oc, Option<D> od, F<A, F<B, F<C, F<D, E>>>> f) {
        return od.apply(this.bind(ob, oc, f));
    }

    public final <B, C, D, E, F$> Option<F$> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return oe.apply(this.bind(ob, oc, od, f));
    }

    public final <B, C, D, E, F$, G> Option<G> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return of.apply(this.bind(ob, oc, od, oe, f));
    }

    public final <B, C, D, E, F$, G, H> Option<H> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, Option<G> og, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return og.apply(this.bind(ob, oc, od, oe, of, f));
    }

    public final <B, C, D, E, F$, G, H, I> Option<I> bind(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, Option<G> og, Option<H> oh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return oh.apply(this.bind(ob, oc, od, oe, of, og, f));
    }

    public final <B> Option<P2<A, B>> bindProduct(Option<B> ob) {
        return this.bind(ob, P.p2());
    }

    public final <B, C> Option<P3<A, B, C>> bindProduct(Option<B> ob, Option<C> oc) {
        return this.bind(ob, oc, P.p3());
    }

    public final <B, C, D> Option<P4<A, B, C, D>> bindProduct(Option<B> ob, Option<C> oc, Option<D> od) {
        return this.bind(ob, oc, od, P.p4());
    }

    public final <B, C, D, E> Option<P5<A, B, C, D, E>> bindProduct(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe) {
        return this.bind(ob, oc, od, oe, P.p5());
    }

    public final <B, C, D, E, F$> Option<P6<A, B, C, D, E, F$>> bindProduct(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of) {
        return this.bind(ob, oc, od, oe, of, P.p6());
    }

    public final <B, C, D, E, F$, G> Option<P7<A, B, C, D, E, F$, G>> bindProduct(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, Option<G> og) {
        return this.bind(ob, oc, od, oe, of, og, P.p7());
    }

    public final <B, C, D, E, F$, G, H> Option<P8<A, B, C, D, E, F$, G, H>> bindProduct(Option<B> ob, Option<C> oc, Option<D> od, Option<E> oe, Option<F$> of, Option<G> og, Option<H> oh) {
        return this.bind(ob, oc, od, oe, of, og, oh, P.p8());
    }

    public final <B> Option<B> sequence(Option<B> o) {
        F c = Function.constant(o);
        return this.bind(c);
    }

    public static final <L, B> Either<L, Option<B>> sequenceEither(Option<Either<L, B>> option) {
        return option.traverseEitherRight(Function.identity());
    }

    public static final <R, B> Either<Option<B>, R> sequenceEitherLeft(Option<Either<B, R>> option) {
        return option.traverseEitherLeft(Function.identity());
    }

    public static final <L, B> Either<L, Option<B>> sequenceEitherRight(Option<Either<L, B>> option) {
        return option.traverseEitherRight(Function.identity());
    }

    public static final <C, B> F<C, Option<B>> sequenceF(Option<F<C, B>> option) {
        return option.traverseF(Function.identity());
    }

    public static final <B> IO<Option<B>> sequenceIO(Option<IO<B>> option) {
        return option.traverseIO(Function.identity());
    }

    public static final <B> List<Option<B>> sequenceList(Option<List<B>> option) {
        return option.traverseList(Function.identity());
    }

    public static final <B> Option<Option<B>> sequenceOption(Option<Option<B>> option) {
        return option.traverseOption(Function.identity());
    }

    public static final <B> P1<Option<B>> sequenceP1(Option<P1<B>> option) {
        return option.traverseP1(Function.identity());
    }

    public static final <B> Seq<Option<B>> sequenceSeq(Option<Seq<B>> option) {
        return option.traverseSeq(Function.identity());
    }

    public static final <B> Set<Option<B>> sequenceSet(Ord<B> ord, Option<Set<B>> option) {
        return option.traverseSet(ord, Function.identity());
    }

    public static final <B> Stream<Option<B>> sequenceStream(Option<Stream<B>> option) {
        return option.traverseStream(Function.identity());
    }

    public static final <B> Trampoline<Option<B>> sequenceTrampoline(Option<Trampoline<B>> option) {
        return option.traverseTrampoline(Function.identity());
    }

    public static final <E, B> Validation<E, Option<B>> sequenceValidation(Option<Validation<E, B>> option) {
        return option.traverseValidation(Function.identity());
    }

    public final <L, B> Either<L, Option<B>> traverseEither(F<A, Either<L, B>> f) {
        return this.traverseEitherRight(f);
    }

    public final <R, B> Either<Option<B>, R> traverseEitherLeft(F<A, Either<B, R>> f) {
        return this.option(Either.left(Option.none()), (A a) -> ((Either)f.f(a)).left().map(Option::some));
    }

    public final <L, B> Either<L, Option<B>> traverseEitherRight(F<A, Either<L, B>> f) {
        return this.option(Either.right(Option.none()), (A a) -> ((Either)f.f(a)).right().map(Option::some));
    }

    public final <C, B> F<C, Option<B>> traverseF(F<A, F<C, B>> f) {
        return this.option(Function.constant(Option.none()), (A a) -> Function.andThen((F)f.f(a), Option::some));
    }

    public final <B> IO<Option<B>> traverseIO(F<A, IO<B>> f) {
        return this.option(IOFunctions.lazy(Option::none), (A a) -> IOFunctions.map((IO)f.f(a), Option::some));
    }

    public final <B> List<Option<B>> traverseList(F<A, List<B>> f) {
        return this.option(List.single(Option.none()), (A a) -> ((List)f.f(a)).map(Option::some));
    }

    public final <B> Option<Option<B>> traverseOption(F<A, Option<B>> f) {
        return this.option(Option.some(Option.none()), (A a) -> ((Option)f.f(a)).map(Option::some));
    }

    public final <B> P1<Option<B>> traverseP1(F<A, P1<B>> f) {
        return this.option((B)P.p(Option.none()), a -> ((P1)f.f(a)).map(Option::some));
    }

    public final <B> Seq<Option<B>> traverseSeq(F<A, Seq<B>> f) {
        return this.option(Seq.single(Option.none()), (A a) -> ((Seq)f.f(a)).map(Option::some));
    }

    public final <B> Set<Option<B>> traverseSet(Ord<B> ord, F<A, Set<B>> f) {
        Ord ordOption = Ord.optionOrd(ord);
        return this.option(Set.single(ordOption, Option.none()), (A a) -> ((Set)f.f(a)).map(ordOption, Option::some));
    }

    public final <B> Stream<Option<B>> traverseStream(F<A, Stream<B>> f) {
        return this.option(Stream.single(Option.none()), (A a) -> ((Stream)f.f(a)).map(Option::some));
    }

    public final <B> Trampoline<Option<B>> traverseTrampoline(F<A, Trampoline<B>> f) {
        return this.option(Trampoline.pure(Option.none()), (A a) -> ((Trampoline)f.f(a)).map(Option::some));
    }

    public final <E, B> Validation<E, Option<B>> traverseValidation(F<A, Validation<E, B>> f) {
        return this.option(Validation.success(Option.none()), (A a) -> ((Validation)f.f(a)).map(Option::some));
    }

    public final <B> F2<Ord<B>, F<A, Set<B>>, Set<Option<B>>> traverseSet() {
        return this::traverseSet;
    }

    public final <B> Option<B> apply(Option<F<A, B>> of) {
        return of.bind(f -> this.map((F)f));
    }

    public final Option<A> orElse(F0<Option<A>> o) {
        return this.isSome() ? this : o.f();
    }

    public final Option<A> orElse(Option<A> o) {
        return this.isSome() ? this : o;
    }

    public final <X> Either<X, A> toEither(F0<X> x) {
        return this.isSome() ? Either.right(this.some()) : Either.left(x.f());
    }

    public final <X> Either<X, A> toEither(X x) {
        return this.isSome() ? Either.right(this.some()) : Either.left(x);
    }

    public final <X> Validation<X, A> toValidation(X x) {
        return Validation.validation(this.toEither(x));
    }

    public static <A, X> F<Option<A>, F<X, Either<X, A>>> toEither() {
        return Function.curry(Option::toEither);
    }

    public final List<A> toList() {
        return this.isSome() ? List.cons(this.some(), List.nil()) : List.nil();
    }

    public final Stream<A> toStream() {
        return this.isSome() ? Stream.nil().cons(this.some()) : Stream.nil();
    }

    public final Array<A> toArray() {
        return this.isSome() ? Array.array(this.some()) : Array.empty();
    }

    public final Array<A> toArray(Class<A[]> c) {
        if (this.isSome()) {
            Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), 1);
            a[0] = this.some();
            return Array.array(a);
        }
        return Array.array((Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), 0));
    }

    public final A[] array(Class<A[]> c) {
        return this.toArray(c).array(c);
    }

    public final A toNull() {
        return this.orSome((A)null);
    }

    public final boolean forall(F<A, Boolean> f) {
        return this.isNone() || f.f(this.some()) != false;
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.isSome() && f.f(this.some()) != false;
    }

    public final boolean equals(Object other) {
        return Equal.equals0(Option.class, this, other, () -> Equal.optionEqual(Equal.anyEqual()));
    }

    public final Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <T> F<T, Option<T>> some_() {
        return Option::some;
    }

    public static <T> Option<T> some(T t) {
        return new Some<T>(t);
    }

    public static <T> F<T, Option<T>> none_() {
        return t -> Option.none();
    }

    public static <T> Option<T> none() {
        return new None();
    }

    public static <T> Option<T> fromNull(T t) {
        return t == null ? Option.none() : Option.some(t);
    }

    public static <T> F<T, Option<T>> fromNull() {
        return Option::fromNull;
    }

    public static final <A, B> F<Option<A>, B> option_(B none, F<A, B> some) {
        return o -> o.option(none, some);
    }

    public static <A> Option<A> join(Option<Option<A>> o) {
        F id = Function.identity();
        return o.bind(id);
    }

    public static <A> Option<List<A>> sequence(List<Option<A>> a) {
        return a.isEmpty() ? Option.some(List.nil()) : a.head().bind(aa -> Option.sequence(a.tail()).map(List.cons_(aa)));
    }

    public static <E, A> Option<Validation<E, A>> sequence(Validation<E, Option<A>> a) {
        return a.traverseOption(Function.identity());
    }

    public static <A> Option<A> iif(F<A, Boolean> f, A a) {
        return f.f(a) != false ? Option.some(a) : Option.none();
    }

    public static <A> Option<A> iif(boolean p, F0<A> a) {
        return p ? Option.some(a.f()) : Option.none();
    }

    public static <A> Option<A> iif(boolean p, A a) {
        return Option.iif(p, P.p(a));
    }

    public static <A> F2<F<A, Boolean>, A, Option<A>> iif() {
        return Option::iif;
    }

    public static <A> List<A> somes(List<Option<A>> as) {
        return as.filter(Option.isSome_()).map(o -> o.some());
    }

    public static <A> Stream<A> somes(Stream<Option<A>> as) {
        return as.filter(Option.isSome_()).map(o -> o.some());
    }

    public static Option<String> fromString(String s) {
        return Option.fromNull(s).bind(s1 -> {
            Option none = Option.none();
            return s.length() == 0 ? none : Option.some(s);
        });
    }

    public final int hashCode() {
        return Hash.optionHash(Hash.anyHash()).hash(this);
    }

    public static F<String, Option<String>> fromString() {
        return Option::fromString;
    }

    public static <A> F<Option<A>, A> fromSome() {
        return option -> option.some();
    }

    public static <A, B, C> F<Option<A>, F<Option<B>, Option<C>>> liftM2(F<A, F<B, C>> f) {
        return Function.curry((a, b) -> a.bind((Option)b, f));
    }

    public final <B, C> Option<C> liftM2(Option<B> ob, F2<A, B, C> f) {
        return this.bind(a -> ob.map(b -> f.f(a, b)));
    }

    public static <A, B> F<F<A, Option<B>>, F<Option<A>, Option<B>>> bind() {
        return Function.curry((f, a) -> a.bind((F)f));
    }

    public static <A> F<Option<Option<A>>, Option<A>> join() {
        return Option::join;
    }

    public static final class Optic {
        private Optic() {
            throw new UnsupportedOperationException();
        }

        public static <A> Prism<Option<A>, Unit> none() {
            return Prism.prism(o -> o.option(Option.some(Unit.unit()), a -> Option.none()), u -> Option.none());
        }

        public static <A, B> PPrism<Option<A>, Option<B>, A, B> pSome() {
            return PPrism.pPrism(o -> o.map(Either::right).orSome(Either.left(Option.none())), Option::some);
        }

        public static <A> Prism<Option<A>, A> some() {
            return new Prism(Optic.pSome());
        }
    }

    private static final class Some<A>
    extends Option<A> {
        private final A a;

        Some(A a) {
            this.a = a;
        }

        @Override
        public A some() {
            return this.a;
        }
    }

    private static final class None<A>
    extends Option<A> {
        private None() {
        }

        @Override
        public A some() {
            throw Bottom.error("some on None");
        }
    }
}

