/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;

public class Reader<A, B> {
    private final F<A, B> function;

    public Reader(F<A, B> f) {
        this.function = f;
    }

    public final F<A, B> getFunction() {
        return this.function;
    }

    public static <A, B> Reader<A, B> unit(F<A, B> f) {
        return new Reader<A, B>(f);
    }

    public static <A, B> Reader<A, B> constant(B b) {
        return Reader.unit(a -> b);
    }

    public final B f(A a) {
        return this.function.f(a);
    }

    public final <C> Reader<A, C> map(F<B, C> f) {
        return Reader.unit(this.function.andThen(f));
    }

    public final <C> Reader<A, C> andThen(F<B, C> f) {
        return this.map(f);
    }

    public final <C> Reader<A, C> flatMap(F<B, Reader<A, C>> f) {
        return Reader.unit(a -> ((Reader)f.f(this.function.f(a))).f(a));
    }

    public final <C> Reader<A, C> bind(F<B, Reader<A, C>> f) {
        return this.flatMap(f);
    }
}

