/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Hash;
import fj.Monoid;
import fj.Ord;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.Semigroup;
import fj.Show;
import fj.control.Trampoline;
import fj.data.Array;
import fj.data.Either;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.List;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Validation;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Seq<A>
implements Iterable<A> {
    private static final Measured<Integer, Object> ELEM_MEASURED = FingerTree.measured(Monoid.intAdditionMonoid, Function.constant(1));
    private static final MakeTree<Integer, Object> MK_TREE = FingerTree.mkTree(ELEM_MEASURED);
    private static final Seq<Object> EMPTY = new Seq<Object>(MK_TREE.empty());
    private final FingerTree<Integer, A> ftree;

    private static <A> MakeTree<Integer, A> mkTree() {
        return MK_TREE;
    }

    private Seq(FingerTree<Integer, A> ftree) {
        this.ftree = ftree;
    }

    private static <A> Measured<Integer, A> elemMeasured() {
        return ELEM_MEASURED;
    }

    public static <A> Seq<A> empty() {
        return EMPTY;
    }

    public boolean equals(Object other) {
        return Equal.equals0(Seq.class, this, other, () -> Equal.seqEqual(Equal.anyEqual()));
    }

    public static <A> Seq<A> single(A a) {
        return new Seq<A>(Seq.mkTree().single(a));
    }

    @SafeVarargs
    public static <A> Seq<A> seq(A ... as) {
        return Seq.arraySeq(as);
    }

    public static <A> Seq<A> listSeq(List<A> list) {
        return Seq.iterableSeq(list);
    }

    public static <A> Seq<A> iterableSeq(Iterable<A> i) {
        Seq<A> s = Seq.empty();
        for (A a : i) {
            s = s.snoc(a);
        }
        return s;
    }

    public static <A> Seq<A> iteratorSeq(Iterator<A> i) {
        return Seq.iterableSeq(() -> i);
    }

    @SafeVarargs
    public static <A> Seq<A> arraySeq(A ... as) {
        return Seq.iterableSeq(Array.array(as));
    }

    public static <A> Seq<A> fromJavaList(java.util.List<A> list) {
        return Seq.iterableSeq(list);
    }

    public Seq<A> cons(A a) {
        return new Seq<A>(this.ftree.cons(a));
    }

    public Seq<A> snoc(A a) {
        return new Seq<A>(this.ftree.snoc(a));
    }

    public A head() {
        return this.ftree.head();
    }

    public Option<A> headOption() {
        return this.ftree.headOption();
    }

    public A last() {
        return this.ftree.last();
    }

    public Seq<A> tail() {
        return this.length() == 1 ? Seq.empty() : new Seq<A>(this.ftree.tail());
    }

    public Seq<A> init() {
        return this.length() == 1 ? Seq.empty() : new Seq<A>(this.ftree.init());
    }

    public Stream<A> toStream() {
        return this.ftree.foldLeft((b, a) -> b.cons(a), Stream.nil()).reverse();
    }

    public List<A> toList() {
        List.Buffer<A> buf = List.Buffer.empty();
        for (A a : this) {
            buf.snoc(a);
        }
        return buf.toList();
    }

    public java.util.List<A> toJavaList() {
        return new AbstractList<A>(){

            @Override
            public A get(int i) {
                return Seq.this.index(i);
            }

            @Override
            public Iterator<A> iterator() {
                return Seq.this.iterator();
            }

            @Override
            public int size() {
                return Seq.this.length();
            }
        };
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            private FingerTree<Integer, A> ftree;
            {
                this.ftree = Seq.this.ftree;
            }

            @Override
            public boolean hasNext() {
                return !this.ftree.isEmpty();
            }

            @Override
            public A next() {
                if (this.ftree.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object a = this.ftree.head();
                this.ftree = this.ftree.tail();
                return a;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return Show.seqShow(Show.anyShow()).showS(this);
    }

    public Seq<A> append(Seq<A> as) {
        return new Seq<A>(this.ftree.append(as.ftree));
    }

    public boolean isEmpty() {
        return this.ftree.isEmpty();
    }

    public Seq<A> insert(int index, A a) {
        P2<Seq<A>, Seq<A>> p = this.split(index);
        return p._1().append(Seq.single(a)).append(p._2());
    }

    public boolean isNotEmpty() {
        return !this.ftree.isEmpty();
    }

    public int length() {
        return this.ftree.measure();
    }

    public P2<Seq<A>, Seq<A>> split(int i) {
        P2<FingerTree<Integer, A>, FingerTree<Integer, A>> lr = this.ftree.split(index -> index > i);
        return P.p(new Seq<A>(lr._1()), new Seq<A>(lr._2()));
    }

    public A index(int i) {
        this.checkBounds(i);
        return this.ftree.lookup(Function.identity(), i)._2();
    }

    public Seq<A> update(int i, A a) {
        this.checkBounds(i);
        P3<FingerTree<Integer, A>, A, FingerTree<Integer, A>> lxr = this.ftree.split1(index -> index > i);
        return new Seq<A>(lxr._1().append(lxr._3().cons(a)));
    }

    public Seq<A> delete(int i) {
        this.checkBounds(i);
        P3<FingerTree<Integer, A>, A, FingerTree<Integer, A>> lxr = this.ftree.split1(index -> index > i);
        return new Seq<A>(lxr._1().append(lxr._3()));
    }

    public Seq<A> take(int n) {
        return this.split(n)._1();
    }

    public Seq<A> drop(int n) {
        return this.split(n)._2();
    }

    private void checkBounds(int i) {
        if (i < 0 || i >= this.length()) {
            throw Bottom.error("Index " + i + " is out of bounds.");
        }
    }

    public <B> B foldLeft(F2<B, A, B> f, B z) {
        return this.ftree.foldLeft(f, z);
    }

    public <B> B foldRight(F2<A, B, B> f, B z) {
        return this.ftree.foldRight(f, z);
    }

    public Seq<A> filter(F<A, Boolean> f) {
        return this.foldLeft((acc, a) -> (Boolean)f.f(a) != false ? acc.snoc(a) : acc, Seq.empty());
    }

    public int hashCode() {
        return Hash.seqHash(Hash.anyHash()).hash(this);
    }

    public <B> Seq<B> map(F<A, B> f) {
        return new Seq<B>(this.ftree.map(f, Seq.elemMeasured()));
    }

    public <B> Seq<B> bind(F<A, Seq<B>> f) {
        return this.foldRight((element, accumulator) -> ((Seq)f.f(element)).append((Seq)accumulator), Seq.empty());
    }

    public static <L, B> Either<L, Seq<B>> sequenceEither(Seq<Either<L, B>> seq) {
        return seq.traverseEither(Function.identity());
    }

    public static <R, B> Either<Seq<B>, R> sequenceEitherLeft(Seq<Either<B, R>> seq) {
        return seq.traverseEitherLeft(Function.identity());
    }

    public static <L, B> Either<L, Seq<B>> sequenceEitherRight(Seq<Either<L, B>> seq) {
        return seq.traverseEitherRight(Function.identity());
    }

    public static <C, B> F<C, Seq<B>> sequenceF(Seq<F<C, B>> seq) {
        return seq.traverseF(Function.identity());
    }

    public static <B> IO<Seq<B>> sequenceIO(Seq<IO<B>> seq) {
        return seq.traverseIO(Function.identity());
    }

    public static <B> List<Seq<B>> sequenceList(Seq<List<B>> seq) {
        return seq.traverseList(Function.identity());
    }

    public static <B> Option<Seq<B>> sequenceOption(Seq<Option<B>> seq) {
        return seq.traverseOption(Function.identity());
    }

    public static <B> P1<Seq<B>> sequenceP1(Seq<P1<B>> seq) {
        return seq.traverseP1(Function.identity());
    }

    public static <B> Seq<Seq<B>> sequenceSeq(Seq<Seq<B>> seq) {
        return seq.traverseSeq(Function.identity());
    }

    public static <B> Set<Seq<B>> sequenceSet(Ord<B> ord, Seq<Set<B>> seq) {
        return seq.traverseSet(ord, Function.identity());
    }

    public static <B> Stream<Seq<B>> sequenceStream(Seq<Stream<B>> seq) {
        return seq.traverseStream(Function.identity());
    }

    public static <B> Trampoline<Seq<B>> sequenceTrampoline(Seq<Trampoline<B>> seq) {
        return seq.traverseTrampoline(Function.identity());
    }

    public static <E, B> Validation<E, Seq<B>> sequenceValidation(Seq<Validation<E, B>> seq) {
        return seq.traverseValidation(Function.identity());
    }

    public static <E, B> Validation<E, Seq<B>> sequenceValidation(Semigroup<E> semigroup, Seq<Validation<E, B>> seq) {
        return seq.traverseValidation(semigroup, Function.identity());
    }

    public <B, L> Either<L, Seq<B>> traverseEither(F<A, Either<L, B>> f) {
        return this.traverseEitherRight(f);
    }

    public <R, B> Either<Seq<B>, R> traverseEitherLeft(F<A, Either<B, R>> f) {
        return this.foldRight((element, either) -> ((Either)f.f(element)).left().bind((A elementInner) -> either.left().map((A seq) -> seq.cons(elementInner))), Either.left(Seq.empty()));
    }

    public <L, B> Either<L, Seq<B>> traverseEitherRight(F<A, Either<L, B>> f) {
        return this.foldRight((element, either) -> ((Either)f.f(element)).right().bind((B elementInner) -> either.right().map((B seq) -> seq.cons(elementInner))), Either.right(Seq.empty()));
    }

    public <C, B> F<C, Seq<B>> traverseF(F<A, F<C, B>> f) {
        return this.foldRight((element, fInner) -> Function.bind((F)f.f(element), elementInner -> Function.andThen(fInner, seq -> seq.cons(elementInner))), Function.constant(Seq.empty()));
    }

    public <B> IO<Seq<B>> traverseIO(F<A, IO<B>> f) {
        return this.foldRight((element, io) -> IOFunctions.bind((IO)f.f(element), elementInner -> IOFunctions.map(io, seq -> seq.cons(elementInner))), IOFunctions.unit(Seq.empty()));
    }

    public <B> List<Seq<B>> traverseList(F<A, List<B>> f) {
        return this.foldRight((element, list) -> ((List)f.f(element)).bind((A elementInner) -> list.map(seq -> seq.cons(elementInner))), List.single(Seq.empty()));
    }

    public <B> Option<Seq<B>> traverseOption(F<A, Option<B>> f) {
        return this.foldRight((element, option) -> ((Option)f.f(element)).bind((A elementInner) -> option.map(seq -> seq.cons(elementInner))), Option.some(Seq.empty()));
    }

    public <B> P1<Seq<B>> traverseP1(F<A, P1<B>> f) {
        return this.foldRight((element, p1) -> ((P1)f.f(element)).bind((A elementInner) -> p1.map(seq -> seq.cons(elementInner))), P.p(Seq.empty()));
    }

    public <B> Seq<Seq<B>> traverseSeq(F<A, Seq<B>> f) {
        return this.foldRight((element, seq) -> ((Seq)f.f(element)).bind(elementInner -> seq.map(seqInner -> seqInner.cons(elementInner))), Seq.single(Seq.empty()));
    }

    public <B> Set<Seq<B>> traverseSet(Ord<B> ord, F<A, Set<B>> f) {
        Ord seqOrd = Ord.seqOrd(ord);
        return this.foldRight((element, set) -> ((Set)f.f(element)).bind(seqOrd, elementInner -> set.map(seqOrd, seq -> seq.cons(elementInner))), Set.single(seqOrd, Seq.empty()));
    }

    public <B> Stream<Seq<B>> traverseStream(F<A, Stream<B>> f) {
        return this.foldRight((element, stream) -> ((Stream)f.f(element)).bind((A elementInner) -> stream.map(seq -> seq.cons(elementInner))), Stream.single(Seq.empty()));
    }

    public <B> Trampoline<Seq<B>> traverseTrampoline(F<A, Trampoline<B>> f) {
        return this.foldRight((element, trampoline) -> ((Trampoline)f.f(element)).bind((A elementInner) -> trampoline.map(seq -> seq.cons(elementInner))), Trampoline.pure(Seq.empty()));
    }

    public <E, B> Validation<E, Seq<B>> traverseValidation(F<A, Validation<E, B>> f) {
        return this.foldRight((element, validation) -> ((Validation)f.f(element)).bind((T elementInner) -> validation.map((T seq) -> seq.cons(elementInner))), Validation.success(Seq.empty()));
    }

    public <E, B> Validation<E, Seq<B>> traverseValidation(Semigroup<E> semigroup, F<A, Validation<E, B>> f) {
        return this.foldRight((element, validation) -> ((Validation)f.f(element)).map(Seq::single).accumulate(semigroup, validation, Seq::append), Validation.success(Seq.empty()));
    }
}

