/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.P;
import fj.P2;
import fj.Unit;
import fj.control.Trampoline;
import fj.data.List;

public final class State<S, A> {
    private final F<S, Trampoline<P2<S, A>>> runF;

    public static <S, A> State<S, A> unit(F<S, P2<S, A>> runF) {
        return new State<Object, A>(s -> Trampoline.pure(runF.f(s)));
    }

    public static <S> State<S, S> init() {
        return State.unit(s -> State.dup(s));
    }

    public static <S> State<S, S> units(F<S, S> f) {
        return State.unit(s -> State.dup(f.f(s)));
    }

    private static <S> P2<S, S> dup(S s) {
        return P.p(s, s);
    }

    public static <S, A> State<S, A> constant(A a) {
        return State.unit(s -> P.p(s, a));
    }

    public static <S, A> State<S, A> gets(F<S, A> f) {
        return State.unit(s -> P.p(s, f.f(s)));
    }

    public static <S> State<S, Unit> put(S s) {
        return State.unit(ignoredS -> P.p(s, Unit.unit()));
    }

    public static <S> State<S, Unit> modify(F<S, S> f) {
        return State.unit(s -> P.p(f.f(s), Unit.unit()));
    }

    public static <S, A, B> State<S, B> flatMap(State<S, A> ts, F<A, State<S, B>> f) {
        return ts.flatMap(f);
    }

    public static <S, A> State<S, List<A>> sequence(List<State<S, A>> list) {
        return list.foldLeft((acc, ts) -> acc.flatMap(as -> ts.map(a -> List.cons(a, as))), State.constant(List.nil())).map(as -> as.reverse());
    }

    public static <S, A, B> State<S, List<B>> traverse(List<A> list, F<A, State<S, B>> f) {
        return list.foldLeft((acc, a) -> acc.flatMap(bs -> ((State)f.f(a)).map(b -> List.cons(b, bs))), State.constant(List.nil())).map(bs -> bs.reverse());
    }

    private static <S, A> State<S, A> suspended(F<S, Trampoline<P2<S, A>>> runF) {
        return new State<Object, A>(s -> Trampoline.suspend(() -> (Trampoline)runF.f(s)));
    }

    private State(F<S, Trampoline<P2<S, A>>> runF) {
        this.runF = runF;
    }

    public P2<S, A> run(S s) {
        return this.runF.f(s).run();
    }

    public A eval(S s) {
        return this.run(s)._2();
    }

    public S exec(S s) {
        return this.run(s)._1();
    }

    public State<S, S> gets() {
        return this.mapState(result -> P.p(result._1(), result._1()));
    }

    public <B> State<S, B> map(F<A, B> f) {
        return this.mapState(result -> P.p(result._1(), f.f(result._2())));
    }

    public <B> State<S, B> mapState(F<P2<S, A>, P2<S, B>> f) {
        return State.suspended(s -> this.runF.f(s).map(result -> (P2)f.f((P2)result)));
    }

    public State<S, A> withs(F<S, S> f) {
        return State.suspended(s -> this.runF.f(f.f(s)));
    }

    public <B> State<S, B> bind(F<A, State<S, B>> f) {
        return this.flatMap(f);
    }

    public <B> State<S, B> flatMap(F<A, State<S, B>> f) {
        return State.suspended(s -> this.runF.f(s).bind((A result) -> Trampoline.pure(((State)f.f(result._2())).run(result._1()))));
    }
}

