/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F0;
import fj.F2;
import fj.Function;
import fj.Hash;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Semigroup;
import fj.Show;
import fj.Unit;
import fj.control.Trampoline;
import fj.control.parallel.Promise;
import fj.control.parallel.Strategy;
import fj.data.Array;
import fj.data.Either;
import fj.data.Enumerator;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Seq;
import fj.data.Set;
import fj.data.Validation;
import fj.function.Booleans;
import fj.function.Effect1;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public abstract class Stream<A>
implements Iterable<A> {
    private Stream() {
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract P1<Stream<A>> tail();

    public final boolean isEmpty() {
        return this instanceof Nil;
    }

    public final boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public final <B> B uncons(B nil, F<A, F<P1<Stream<A>>, B>> cons) {
        return this.isEmpty() ? nil : cons.f(this.head()).f(this.tail());
    }

    public final <B> B foldRight(F<A, F<P1<B>, B>> f, B b) {
        return this.foldRight(Function.uncurryF2(f), b);
    }

    public final <B> B foldRight(F2<A, P1<B>, B> f, B b) {
        return this.isEmpty() ? b : f.f(this.head(), P.lazy(() -> this.tail()._1().foldRight(f, b)));
    }

    public final <B> B foldRight1(F<A, F<B, B>> f, B b) {
        return this.foldRight1(Function.uncurryF2(f), b);
    }

    public final <B> B foldRight1(F2<A, B, B> f, B b) {
        return this.isEmpty() ? b : f.f(this.head(), this.tail()._1().foldRight1(f, b));
    }

    public final <B> B foldLeft(F<B, F<A, B>> f, B b) {
        return this.foldLeft(Function.uncurryF2(f), b);
    }

    public final <B> B foldLeft(F2<B, A, B> f, B b) {
        B x = b;
        Stream<A> xs = this;
        while (!xs.isEmpty()) {
            x = f.f(x, xs.head());
            xs = xs.tail()._1();
        }
        return x;
    }

    public final A foldLeft1(F2<A, A, A> f) {
        if (this.isEmpty()) {
            throw Bottom.error("Undefined: foldLeft1 on empty list");
        }
        return this.tail()._1().foldLeft(f, this.head());
    }

    public final A foldLeft1(F<A, F<A, A>> f) {
        return this.foldLeft1(Function.uncurryF2(f));
    }

    public final A orHead(F0<A> a) {
        return this.isEmpty() ? a.f() : this.head();
    }

    public final P1<Stream<A>> orTail(F0<Stream<A>> as) {
        return this.isEmpty() ? P.lazy(as) : this.tail();
    }

    public final Stream<A> intersperse(final A a) {
        return this.isEmpty() ? this : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return this.prefix(a, Stream.this.tail()._1());
            }

            public Stream<A> prefix(A x, Stream<A> xs) {
                return xs.isEmpty() ? xs : Stream.cons(x, P.p(Stream.cons(xs.head(), () -> this.prefix(a, xs.tail()._1()))));
            }
        });
    }

    public final <B> Stream<B> map(F<A, B> f) {
        return this.isEmpty() ? Stream.nil() : Stream.cons(f.f(this.head()), () -> this.tail()._1().map(f));
    }

    public static <A, B> F<F<A, B>, F<Stream<A>, Stream<B>>> map_() {
        return f -> as -> as.map((F)f);
    }

    public final Unit foreach(F<A, Unit> f) {
        Stream<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail()._1();
        }
        return Unit.unit();
    }

    public final void foreachDoEffect(Effect1<A> f) {
        Stream<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail()._1();
        }
    }

    public final Stream<A> filter(F<A, Boolean> f) {
        Stream as = this.dropWhile(Booleans.not(f));
        return as.isNotEmpty() ? Stream.cons(as.head(), () -> as.tail()._1().filter(f)) : as;
    }

    public final Stream<A> append(Stream<A> as) {
        return this.isEmpty() ? as : Stream.cons(this.head(), () -> this.tail()._1().append(as));
    }

    public final Stream<A> append(F0<Stream<A>> as) {
        return this.isEmpty() ? as.f() : Stream.cons(this.head(), () -> this.tail()._1().append(as));
    }

    public final Stream<A> minus(Equal<A> eq, Stream<A> xs) {
        return this.removeAll(Function.compose(Monoid.disjunctionMonoid.sumLeftS(), xs.mapM(Function.curry(eq.eq()))));
    }

    public final Stream<A> removeAll(F<A, Boolean> f) {
        return this.filter(Function.compose(Booleans.not, f));
    }

    public static <A, B> F<B, Stream<A>> sequence_(Stream<F<B, A>> fs) {
        return fs.foldRight((A baf, P1<B> p1) -> Function.bind(baf, (F)p1._1(), Function.curry((a, stream) -> Stream.cons(a, P.p(stream)))), Function.constant(Stream.nil()));
    }

    public final <B, C> F<B, Stream<C>> mapM(F<A, F<B, C>> f) {
        return Stream.sequence_(this.map(f));
    }

    public final <B> Stream<B> bind(F<A, Stream<B>> f) {
        return this.foldRight((A h) -> t -> ((Stream)f.f(h)).append((F0)t), Stream.nil());
    }

    public final <B, C> Stream<C> bind(Stream<B> sb, F<A, F<B, C>> f) {
        return sb.apply(this.map(f));
    }

    public final <B, C> Stream<C> bind(Stream<B> sb, F2<A, B, C> f) {
        return this.bind(sb, Function.curry(f));
    }

    public final <B, C, D> Stream<D> bind(Stream<B> sb, Stream<C> sc, F<A, F<B, F<C, D>>> f) {
        return sc.apply(this.bind(sb, f));
    }

    public final <B, C, D, E> Stream<E> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, F<A, F<B, F<C, F<D, E>>>> f) {
        return sd.apply(this.bind(sb, sc, f));
    }

    public final <B, C, D, E, F$> Stream<F$> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return se.apply(this.bind(sb, sc, sd, f));
    }

    public final <B, C, D, E, F$, G> Stream<G> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return sf.apply(this.bind(sb, sc, sd, se, f));
    }

    public final <B, C, D, E, F$, G, H> Stream<H> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, Stream<G> sg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return sg.apply(this.bind(sb, sc, sd, se, sf, f));
    }

    public final <B, C, D, E, F$, G, H, I> Stream<I> bind(Stream<B> sb, Stream<C> sc, Stream<D> sd, Stream<E> se, Stream<F$> sf, Stream<G> sg, Stream<H> sh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return sh.apply(this.bind(sb, sc, sd, se, sf, sg, f));
    }

    public final <B> Stream<B> sequence(Stream<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public static <A> Stream<IO<A>> sequence(IO<Stream<A>> io) {
        return IOFunctions.runSafe(io).map(IOFunctions::unit);
    }

    public static <A> Stream<P1<A>> sequence(F0<Stream<A>> p) {
        return p.f().map(P::p);
    }

    public static <A> Stream<Option<A>> sequence(Option<Stream<A>> o) {
        return o.isNone() ? Stream.nil() : o.some().map(Option::some);
    }

    public final <B> Stream<B> apply(Stream<F<A, B>> sf) {
        return sf.bind(this::map);
    }

    public final Stream<A> interleave(Stream<A> as) {
        return this.isEmpty() ? as : (as.isEmpty() ? this : Stream.cons(this.head(), () -> as.interleave(this.tail()._1())));
    }

    public static <A> Stream<A> enumerationStream(Enumeration<A> e) {
        if (e.hasMoreElements()) {
            return Stream.cons(e.nextElement(), () -> Stream.enumerationStream(e));
        }
        return Stream.nil();
    }

    public final Stream<A> sort(Ord<A> o) {
        return Stream.mergesort(o, this.map(Function.flip(Stream.cons()).f(P.p(Stream.nil()))));
    }

    private static <A> Stream<A> mergesort(Ord<A> o, Stream<Stream<A>> s) {
        if (s.isEmpty()) {
            return Stream.nil();
        }
        Stream<Stream<A>> xss = s;
        while (xss.tail()._1().isNotEmpty()) {
            xss = Stream.mergePairs(o, xss);
        }
        return xss.head();
    }

    private static <A> Stream<Stream<A>> mergePairs(Ord<A> o, Stream<Stream<A>> s) {
        if (s.isEmpty() || s.tail()._1().isEmpty()) {
            return s;
        }
        Stream t = s.tail()._1();
        return Stream.cons(Stream.merge(o, s.head(), t.head()), () -> Stream.mergePairs(o, t.tail()._1()));
    }

    private static <A> Stream<A> merge(Ord<A> o, Stream<A> xs, Stream<A> ys) {
        A y;
        if (xs.isEmpty()) {
            return ys;
        }
        if (ys.isEmpty()) {
            return xs;
        }
        A x = xs.head();
        if (o.isGreaterThan(x, y = ys.head())) {
            return Stream.cons(y, () -> Stream.merge(o, xs, ys.tail()._1()));
        }
        return Stream.cons(x, () -> Stream.merge(o, xs.tail()._1(), ys));
    }

    public final Stream<A> sort(Ord<A> o, Strategy<Unit> s) {
        return this.qs(o, s).claim();
    }

    private Promise<Stream<A>> qs(Ord<A> o, Strategy<Unit> s) {
        if (this.isEmpty()) {
            return Promise.promise(s, P.p(this));
        }
        F<Boolean, Boolean> id = Function.identity();
        A x = this.head();
        P1<Stream<Stream<A>>> xs = this.tail();
        Promise left = Promise.join(s, xs.map(Stream.flt(o, s, x, id)));
        Promise<Stream<Stream<A>>> right = xs.map(Stream.flt(o, s, x, Booleans.not))._1();
        Monoid<Stream<Stream<A>>> m = Monoid.streamMonoid();
        return right.fmap(m.sum(Stream.single(x))).apply(left.fmap(m.sum()));
    }

    private static <A> F<Stream<A>, Promise<Stream<A>>> qs_(Ord<A> o, Strategy<Unit> s) {
        return xs -> xs.qs(o, s);
    }

    private static <A> F<Stream<A>, Promise<Stream<A>>> flt(Ord<A> o, Strategy<Unit> s, A x, F<Boolean, Boolean> f) {
        F<F<F<A, Boolean>, Boolean>, F<Stream<F<A, Boolean>>, Stream<F<A, Boolean>>>> filter = Stream.filter();
        F<A, Boolean> lt = o.isLessThan(x);
        return Function.compose(Stream.qs_(o, s), filter.f(Function.compose(f, lt)));
    }

    public final Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private Stream<A> xs;
                    {
                        this.xs = Stream.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail()._1();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Stream.this.length();
            }
        };
    }

    public static Stream<Integer> range(int from, long to) {
        return (long)from >= to ? Stream.nil() : Stream.cons(from, () -> Stream.range(from + 1, to));
    }

    @SafeVarargs
    public static <A> Stream<A> stream(A ... as) {
        return Stream.arrayStream(as);
    }

    public static <A> Stream<A> iteratorStream(Iterator<A> it) {
        if (it.hasNext()) {
            A a = it.next();
            return Stream.cons(a, () -> Stream.iteratorStream(it));
        }
        return Stream.nil();
    }

    public static <A> Stream<A> forever(Enumerator<A> e, A from) {
        return Stream.forever(e, from, 1L);
    }

    public static <A> Stream<A> forever(Enumerator<A> e, A from, long step) {
        return Stream.cons(from, () -> e.plus(from, step).map(a -> Stream.forever(e, a, step)).orSome(Stream.nil()));
    }

    public static <A> Stream<A> range(Enumerator<A> e, A from, A to) {
        return Stream.range(e, from, to, 1L);
    }

    public static <A> Stream<A> range(Enumerator<A> e, A from, A to, long step) {
        Ordering o = e.order().compare(from, to);
        return o == Ordering.EQ || step > 0L && o == Ordering.GT || step < 0L && o == Ordering.LT ? Stream.single(from) : Stream.cons(from, () -> Stream.join(e.plus(from, step).filter(a -> !(o != Ordering.LT ? e.order().isGreaterThan(to, a) : e.order().isLessThan(to, a))).map(a1 -> Stream.range(e, a1, to, step)).toStream()));
    }

    public static Stream<Integer> range(int from) {
        return Stream.cons(from, () -> Stream.range(from + 1));
    }

    public static <A> F<F<A, Boolean>, F<Stream<A>, Stream<A>>> filter() {
        return Function.curry((f, as) -> as.filter((F)f));
    }

    public final <B> Stream<B> zapp(Stream<F<A, B>> fs) {
        return fs.isEmpty() || this.isEmpty() ? Stream.nil() : Stream.cons(fs.head().f(this.head()), () -> this.tail()._1().zapp(fs.tail()._1()));
    }

    public final <B, C> Stream<C> zipWith(Stream<B> bs, F<A, F<B, C>> f) {
        return bs.zapp(this.zapp(Stream.repeat(f)));
    }

    public final <B, C> Stream<C> zipWith(Stream<B> bs, F2<A, B, C> f) {
        return this.zipWith(bs, Function.curry(f));
    }

    public final <B, C> F<Stream<B>, Stream<C>> zipWith(F<A, F<B, C>> f) {
        return stream -> this.zipWith((Stream)stream, f);
    }

    public final <B> Stream<P2<A, B>> zip(Stream<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public final Stream<P2<A, Integer>> zipIndex() {
        return this.zipWith(Stream.range(0), P::p);
    }

    public final <X> Either<X, A> toEither(F0<X> x) {
        return this.isEmpty() ? Either.left(x.f()) : Either.right(this.head());
    }

    public final Option<A> toOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public final List<A> toList() {
        List.Buffer buf = List.Buffer.empty();
        this.foreachDoEffect(buf::snoc);
        return buf.toList();
    }

    public final java.util.List<A> toJavaList() {
        return new LinkedList<A>(this.toCollection());
    }

    public final Array<A> toArray() {
        int l = this.length();
        Object[] a = new Object[l];
        Stream<A> x = this;
        for (int i = 0; i < l; ++i) {
            a[i] = x.head();
            x = x.tail()._1();
        }
        return Array.mkArray(a);
    }

    public final Array<A> toArray(Class<A[]> c) {
        Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), this.length());
        int i = 0;
        for (A x : this) {
            a[i] = x;
            ++i;
        }
        return Array.array(a);
    }

    public final A[] array(Class<A[]> c) {
        return this.toArray(c).array(c);
    }

    public final Stream<A> cons(A a) {
        return new Cons<A>(a, () -> this);
    }

    public static String asString(Stream<Character> cs) {
        StringBuilder sb = new StringBuilder();
        cs.foreachDoEffect(sb::append);
        return sb.toString();
    }

    public static Stream<Character> fromString(String s) {
        return LazyString.str(s).toStream();
    }

    public final Stream<A> snoc(A a) {
        return this.snoc(P.p(a));
    }

    public final Stream<A> snoc(F0<A> a) {
        return this.append(() -> Stream.single(a.f()));
    }

    public final Stream<A> take(int n) {
        return n <= 0 || this.isEmpty() ? Stream.nil() : Stream.cons(this.head(), () -> n <= 1 ? Stream.nil() : this.tail()._1().take(n - 1));
    }

    public final Stream<A> drop(int i) {
        Stream<A> xs = this;
        for (int c = 0; xs.isNotEmpty() && c < i; ++c) {
            xs = xs.tail()._1();
        }
        return xs;
    }

    public final Stream<A> takeWhile(F<A, Boolean> f) {
        return this.isEmpty() ? this : (f.f(this.head()) != false ? Stream.cons(this.head(), () -> this.tail()._1().takeWhile(f)) : Stream.nil());
    }

    public final Stream<A> dropWhile(F<A, Boolean> f) {
        Stream<A> as = this;
        while (!as.isEmpty() && f.f(as.head()).booleanValue()) {
            as = as.tail()._1();
        }
        return as;
    }

    public final P2<Stream<A>, Stream<A>> span(F<A, Boolean> p) {
        if (this.isEmpty()) {
            return P.p(this, this);
        }
        if (p.f(this.head()).booleanValue()) {
            P1<P2> yszs = P.lazy(() -> this.tail()._1().span(p));
            return P.lazy(() -> Stream.cons(this.head(), yszs.map(P2.__1())), () -> (Stream)((P2)yszs._1())._2());
        }
        return P.p(Stream.nil(), this);
    }

    public final Stream<A> replace(F<A, Boolean> p, A a) {
        if (this.isEmpty()) {
            return Stream.nil();
        }
        P2 s = this.span(p);
        return s._1().append(Stream.cons(a, () -> ((Stream)s._2()).tail()._1().replace(p, a)));
    }

    public final P2<Stream<A>, Stream<A>> split(F<A, Boolean> p) {
        return this.span(Function.compose(Booleans.not, p));
    }

    public final Stream<A> reverse() {
        return this.foldLeft((B as, A a) -> Stream.cons(a, () -> as), Stream.nil());
    }

    public final A last() {
        return this.reverse().head();
    }

    public final int length() {
        Stream<A> xs = this;
        int i = 0;
        while (!xs.isEmpty()) {
            xs = xs.tail()._1();
            ++i;
        }
        return i;
    }

    public final A index(int i) {
        if (i < 0) {
            throw Bottom.error("index " + i + " out of range on stream");
        }
        Stream<A> xs = this;
        for (int c = 0; c < i; ++c) {
            if (xs.isEmpty()) {
                throw Bottom.error("index " + i + " out of range on stream");
            }
            xs = xs.tail()._1();
        }
        if (xs.isEmpty()) {
            throw Bottom.error("index " + i + " out of range on stream");
        }
        return xs.head();
    }

    public final boolean forall(F<A, Boolean> f) {
        for (A a : this) {
            if (f.f(a).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object other) {
        return Equal.equals0(Stream.class, this, other, () -> Equal.streamEqual(Equal.anyEqual()));
    }

    public final int hashCode() {
        return Hash.streamHash(Hash.anyHash()).hash(this);
    }

    public final String toString() {
        return this.toStringLazy();
    }

    public final String toStringLazy() {
        return this.isEmpty() ? "Nil()" : "Cons(" + Show.anyShow().showS(this.head()) + ", ?)";
    }

    public final String toStringEager() {
        return Show.streamShow(Show.anyShow()).showS(this);
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.dropWhile(Booleans.not(f)).isNotEmpty();
    }

    public final Option<A> find(F<A, Boolean> f) {
        Stream<A> as = this;
        while (as.isNotEmpty()) {
            if (f.f(as.head()).booleanValue()) {
                return Option.some(as.head());
            }
            as = as.tail()._1();
        }
        return Option.none();
    }

    public final <B> Stream<B> cobind(F<Stream<A>, B> k) {
        return this.substreams().map(k);
    }

    public final Stream<Stream<A>> tails() {
        return this.isEmpty() ? Stream.nil() : Stream.cons(this, () -> this.tail()._1().tails());
    }

    public final Stream<Stream<A>> inits() {
        Stream<Stream<Stream<A>>> nil = Stream.cons(Stream.nil(), Stream::nil);
        return this.isEmpty() ? nil : nil.append(() -> this.tail()._1().inits().map(Stream.cons_().f(this.head())));
    }

    public final Stream<Stream<A>> substreams() {
        return this.tails().bind(Stream::inits);
    }

    public final Option<Integer> indexOf(F<A, Boolean> p) {
        return this.zipIndex().find(p2 -> (Boolean)p.f(p2._1())).map(P2.__2());
    }

    public final <B> Stream<B> sequenceW(Stream<F<Stream<A>, B>> fs) {
        return fs.isEmpty() ? Stream.nil() : Stream.cons(fs.head().f(this), () -> this.sequenceW(fs.tail()._1()));
    }

    public final F<Integer, A> toFunction() {
        return this::index;
    }

    public static <A> Stream<A> fromFunction(F<Natural, A> f) {
        return Stream.fromFunction(Enumerator.naturalEnumerator, f, Natural.ZERO);
    }

    public static <A, B> Stream<A> fromFunction(Enumerator<B> e, F<B, A> f, B i) {
        return Stream.cons(f.f(i), () -> {
            Option<Object> s = e.successor(i);
            return s.isSome() ? Stream.fromFunction(e, f, s.some()) : Stream.nil();
        });
    }

    public static <A, B> P2<Stream<A>, Stream<B>> unzip(Stream<P2<A, B>> xs) {
        return xs.foldRight((A p, P1<B> ps) -> {
            P2 pp = (P2)ps._1();
            return P.p(Stream.cons(p._1(), P.p(pp._1())), Stream.cons(p._2(), P.p(pp._2())));
        }, P.p(Stream.nil(), Stream.nil()));
    }

    public static <A, B, C> F<Stream<A>, F<Stream<B>, F<F<A, F<B, C>>, Stream<C>>>> zipWith() {
        return Function.curry(Stream::zipWith);
    }

    public static <A> F<A, F<P1<Stream<A>>, Stream<A>>> cons() {
        return a -> list -> Stream.cons(a, list);
    }

    public static <A> F<A, F<Stream<A>, Stream<A>>> cons_() {
        return Function.curry((a, as) -> as.cons(a));
    }

    public static <A> Stream<A> nil() {
        return new Nil();
    }

    public static <A> P1<Stream<A>> nil_() {
        return P.lazy(() -> new Nil());
    }

    public static <A> F<Stream<A>, Boolean> isEmpty_() {
        return Stream::isEmpty;
    }

    public static <A> F<Stream<A>, Boolean> isNotEmpty_() {
        return Stream::isNotEmpty;
    }

    public static <A> Stream<A> single(A a) {
        return Stream.cons(a, Stream::nil);
    }

    public static <A> F<A, Stream<A>> single() {
        return Stream::single;
    }

    public static <A> Stream<A> cons(A head, F0<Stream<A>> tail) {
        return new Cons<A>(head, tail);
    }

    public static <A> Stream<A> join(Stream<Stream<A>> o) {
        return o.bind(Function.identity());
    }

    public static <A> F<Stream<Stream<A>>, Stream<A>> join() {
        return Stream::join;
    }

    public static <A, B> Stream<A> unfold(F<B, Option<P2<A, B>>> f, B b) {
        Option<P2<A, B>> o = f.f(b);
        if (o.isNone()) {
            return Stream.nil();
        }
        P2 p = o.some();
        return Stream.cons(p._1(), () -> Stream.unfold(f, p._2()));
    }

    public static <A> Stream<A> iterateWhile(F<A, A> f, F<A, Boolean> p, A a) {
        return Stream.unfold(o -> Option.iif(p2 -> (Boolean)p.f(o), P.p(o, f.f(o))), a);
    }

    public static <A> Stream<A> iterableStream(Iterable<A> i) {
        return Stream.iteratorStream(i.iterator());
    }

    @SafeVarargs
    public static <A> Stream<A> arrayStream(A ... as) {
        return as.length == 0 ? Stream.nil() : Stream.unfold(P2.tuple((as1, i) -> i >= as.length ? Option.none() : Option.some(P.p(as[i], P.p(as, i + 1)))), P.p(as, 0));
    }

    public static <A> Stream<A> repeat(A a) {
        return Stream.cons(a, () -> Stream.repeat(a));
    }

    public static <A> Stream<A> cycle(Stream<A> as) {
        if (as.isEmpty()) {
            throw Bottom.error("cycle on empty list");
        }
        return as.append(() -> Stream.cycle(as));
    }

    public static <A> Stream<A> iterate(F<A, A> f, A a) {
        return Stream.cons(a, () -> Stream.iterate(f, f.f(a)));
    }

    public static <A> F<F<A, A>, F<A, Stream<A>>> iterate() {
        return Function.curry(Stream::iterate);
    }

    public static <A, B> F<F<A, Stream<B>>, F<Stream<A>, Stream<B>>> bind_() {
        return Function.curry((f, as) -> as.bind((F)f));
    }

    public static <A, B> F<F<A, F<P1<B>, B>>, F<B, F<Stream<A>, B>>> foldRight() {
        return Function.curry((f, b, as) -> as.foldRight((F)f, (Object)b));
    }

    public static <L, B> Either<L, Stream<B>> sequenceEither(Stream<Either<L, B>> stream) {
        return stream.traverseEither(Function.identity());
    }

    public static <R, B> Either<Stream<B>, R> sequenceEitherLeft(Stream<Either<B, R>> stream) {
        return stream.traverseEitherLeft(Function.identity());
    }

    public static <L, B> Either<L, Stream<B>> sequenceEitherRight(Stream<Either<L, B>> stream) {
        return stream.traverseEitherRight(Function.identity());
    }

    public static <C, B> F<C, Stream<B>> sequenceF(Stream<F<C, B>> stream) {
        return stream.traverseF(Function.identity());
    }

    public static <B> IO<Stream<B>> sequenceIO(Stream<IO<B>> stream) {
        return stream.traverseIO(Function.identity());
    }

    public static <B> List<Stream<B>> sequenceList(Stream<List<B>> stream) {
        return stream.traverseList(Function.identity());
    }

    public static <B> Option<Stream<B>> sequenceOption(Stream<Option<B>> stream) {
        return stream.traverseOption(Function.identity());
    }

    public static <B> P1<Stream<B>> sequenceP1(Stream<P1<B>> stream) {
        return stream.traverseP1(Function.identity());
    }

    public static <B> Seq<Stream<B>> sequenceSeq(Stream<Seq<B>> stream) {
        return stream.traverseSeq(Function.identity());
    }

    public static <B> Set<Stream<B>> sequenceSet(Ord<B> ord, Stream<Set<B>> stream) {
        return stream.traverseSet(ord, Function.identity());
    }

    public static <B> Stream<Stream<B>> sequenceStream(Stream<Stream<B>> stream) {
        return stream.traverseStream(Function.identity());
    }

    public static <B> Trampoline<Stream<B>> sequenceTrampoline(Stream<Trampoline<B>> stream) {
        return stream.traverseTrampoline(Function.identity());
    }

    public static <E, B> Validation<E, Stream<B>> sequenceValidation(Stream<Validation<E, B>> stream) {
        return stream.traverseValidation(Function.identity());
    }

    public static <E, B> Validation<E, Stream<B>> sequenceValidation(Semigroup<E> semigroup, Stream<Validation<E, B>> stream) {
        return stream.traverseValidation(semigroup, Function.identity());
    }

    public <B, L> Either<L, Stream<B>> traverseEither(F<A, Either<L, B>> f) {
        return this.traverseEitherRight(f);
    }

    public <R, B> Either<Stream<B>, R> traverseEitherLeft(F<A, Either<B, R>> f) {
        return this.foldRight1((A element, B either) -> ((Either)f.f(element)).left().bind((A elementInner) -> either.left().map((A stream) -> stream.cons(elementInner))), Either.left(Stream.nil()));
    }

    public <L, B> Either<L, Stream<B>> traverseEitherRight(F<A, Either<L, B>> f) {
        return this.foldRight1((A element, B either) -> ((Either)f.f(element)).right().bind((B elementInner) -> either.right().map((B stream) -> stream.cons(elementInner))), Either.right(Stream.nil()));
    }

    public <C, B> F<C, Stream<B>> traverseF(F<A, F<C, B>> f) {
        return this.foldRight1((A element, B fInner) -> Function.bind((F)f.f(element), elementInner -> Function.andThen(fInner, stream -> stream.cons(elementInner))), Function.constant(Stream.nil()));
    }

    public <B> IO<Stream<B>> traverseIO(F<A, IO<B>> f) {
        return this.foldRight1((A element, B io) -> IOFunctions.bind((IO)f.f(element), elementInner -> IOFunctions.map(io, stream -> stream.cons(elementInner))), IOFunctions.unit(Stream.nil()));
    }

    public <B> List<Stream<B>> traverseList(F<A, List<B>> f) {
        return this.foldRight1((A element, B list) -> ((List)f.f(element)).bind((A elementInner) -> list.map(stream -> stream.cons(elementInner))), List.single(Stream.nil()));
    }

    public <B> Option<Stream<B>> traverseOption(F<A, Option<B>> f) {
        return this.foldRight1((A element, B option) -> ((Option)f.f(element)).bind((A elementInner) -> option.map(stream -> stream.cons(elementInner))), Option.some(Stream.nil()));
    }

    public <B> P1<Stream<B>> traverseP1(F<A, P1<B>> f) {
        return this.foldRight1((A element, B p1) -> ((P1)f.f(element)).bind((A elementInner) -> p1.map(stream -> stream.cons(elementInner))), P.p(Stream.nil()));
    }

    public <B> Seq<Stream<B>> traverseSeq(F<A, Seq<B>> f) {
        return this.foldRight1((A element, B seq) -> ((Seq)f.f(element)).bind((A elementInner) -> seq.map(stream -> stream.cons(elementInner))), Seq.single(Stream.nil()));
    }

    public <B> Set<Stream<B>> traverseSet(Ord<B> ord, F<A, Set<B>> f) {
        Ord seqOrd = Ord.streamOrd(ord);
        return this.foldRight1((A element, B set) -> ((Set)f.f(element)).bind(seqOrd, (A elementInner) -> set.map(seqOrd, seq -> seq.cons(elementInner))), Set.single(seqOrd, Stream.nil()));
    }

    public <B> Stream<Stream<B>> traverseStream(F<A, Stream<B>> f) {
        return this.foldRight1((A element, B stream) -> ((Stream)f.f(element)).bind(elementInner -> stream.map(seq -> seq.cons(elementInner))), Stream.single(Stream.nil()));
    }

    public <B> Trampoline<Stream<B>> traverseTrampoline(F<A, Trampoline<B>> f) {
        return this.foldRight1((A element, B trampoline) -> ((Trampoline)f.f(element)).bind((A elementInner) -> trampoline.map(seq -> seq.cons(elementInner))), Trampoline.pure(Stream.nil()));
    }

    public final <E, B> Validation<E, Stream<B>> traverseValidation(F<A, Validation<E, B>> f) {
        return this.foldRight1((A element, B validation) -> ((Validation)f.f(element)).bind((T elementInner) -> validation.map((T stream) -> stream.cons(elementInner))), Validation.success(Stream.nil()));
    }

    public final <E, B> Validation<E, Stream<B>> traverseValidation(Semigroup<E> semigroup, F<A, Validation<E, B>> f) {
        return this.foldRight1((A element, B validation) -> ((Validation)f.f(element)).map(Stream::single).accumulate(semigroup, validation, (stream1, stream2) -> stream1.append((Stream)stream2)), Validation.success(Stream.nil()));
    }

    private static final class Cons<A>
    extends Stream<A> {
        private final A head;
        private final P1<Stream<A>> tail;

        Cons(A head, F0<Stream<A>> tail) {
            this.head = head;
            this.tail = P.weakMemo(tail);
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public P1<Stream<A>> tail() {
            return this.tail;
        }
    }

    private static final class Nil<A>
    extends Stream<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty stream");
        }

        @Override
        public P1<Stream<A>> tail() {
            throw Bottom.error("tail on empty stream");
        }
    }
}

