/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.Function;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Array;
import fj.data.IterableW;
import fj.data.List;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public final class TreeMap<K, V>
implements Iterable<P2<K, V>> {
    private final Set<P2<K, Option<V>>> tree;

    private TreeMap(Set<P2<K, Option<V>>> tree) {
        this.tree = tree;
    }

    private static <K, V> Ord<P2<K, V>> ord(Ord<K> keyOrd) {
        return keyOrd.contramap(P2.__1());
    }

    public static <K, V> TreeMap<K, V> empty(Ord<K> keyOrd) {
        return new TreeMap<K, V>(Set.empty(TreeMap.ord(keyOrd)));
    }

    public boolean equals(Object other) {
        return Equal.equals0(TreeMap.class, this, other, () -> Equal.treeMapEqual(Equal.anyEqual(), Equal.anyEqual()));
    }

    public int hashCode() {
        return Hash.treeMapHash(Hash.anyHash(), Hash.anyHash()).hash(this);
    }

    public String toString() {
        return Show.treeMapShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    @SafeVarargs
    public static <K, V> TreeMap<K, V> treeMap(Ord<K> keyOrd, P2<K, V> ... p2s) {
        return TreeMap.arrayTreeMap(keyOrd, p2s);
    }

    public static <K, V> TreeMap<K, V> iterableTreeMap(Ord<K> keyOrd, Iterable<P2<K, V>> it) {
        TreeMap<K, V> tm = TreeMap.empty(keyOrd);
        for (P2<K, V> p2 : it) {
            tm = tm.set(p2._1(), p2._2());
        }
        return tm;
    }

    public static <K, V> TreeMap<K, V> iteratorTreeMap(Ord<K> keyOrd, Iterator<P2<K, V>> it) {
        return TreeMap.iterableTreeMap(keyOrd, () -> it);
    }

    @SafeVarargs
    public static <K, V> TreeMap<K, V> arrayTreeMap(Ord<K> keyOrd, P2<K, V> ... ps) {
        return TreeMap.iterableTreeMap(keyOrd, Array.array(ps));
    }

    public Option<V> get(K k) {
        return this.tree.lookup(P.p(k, Option.none())).bind(P2::_2);
    }

    public TreeMap<K, V> set(K k, V v) {
        return new TreeMap<K, V>(this.tree.insert(P.p(k, Option.some(v))));
    }

    public TreeMap<K, V> delete(K k) {
        return new TreeMap<K, V>(this.tree.delete(P.p(k, Option.none())));
    }

    public int size() {
        return this.tree.size();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public List<V> values() {
        return List.iterableList(IterableW.join(this.tree.toList().map(Function.compose(IterableW.wrap(), P2.__2()))));
    }

    public List<K> keys() {
        return this.tree.toList().map(P2.__1());
    }

    public boolean contains(K k) {
        return this.tree.member(P.p(k, Option.none()));
    }

    @Override
    public Iterator<P2<K, V>> iterator() {
        return IterableW.join(this.tree.toStream().map(P2.map2_(IterableW.wrap())).map(P2.tuple(Function.compose(IterableW.map(), P.p2())))).iterator();
    }

    public Map<K, V> toMutableMap() {
        F<Object, P2> fakePair = k -> P.p(k, Option.none());
        Comparator<Object> comparator = this.tree.ord().contramap(fakePair).toComparator();
        java.util.TreeMap<Object, V> m = new java.util.TreeMap<Object, V>(comparator);
        for (P2<K, V> e : this) {
            m.put(e._1(), e._2());
        }
        return m;
    }

    public Stream<P2<K, V>> toStream() {
        return this.tree.toStream().map((A p) -> p.map2(o -> o.some()));
    }

    public Stream<P2<K, V>> toStreamReverse() {
        return this.tree.toStreamReverse().map((A p) -> p.map2(o -> o.some()));
    }

    public List<P2<K, V>> toList() {
        return this.tree.toList().map((A p) -> p.map2(o -> o.some()));
    }

    public List<P2<K, V>> toListReverse() {
        return this.tree.toListReverse().map((A p) -> p.map2(o -> o.some()));
    }

    public static <K, V> TreeMap<K, V> fromMutableMap(Ord<K> ord, Map<K, V> m) {
        TreeMap<K, V> t = TreeMap.empty(ord);
        for (Map.Entry<K, V> e : m.entrySet()) {
            t = t.set(e.getKey(), e.getValue());
        }
        return t;
    }

    public F<K, Option<V>> get() {
        return this::get;
    }

    public P2<Boolean, TreeMap<K, V>> update(K k, F<V, V> f) {
        P2 up = this.tree.update(P.p(k, Option.none()), Function.compose(P2.tuple(P.p2()), P2.map2_(Option.map().f(f))));
        return P.p(up._1(), new TreeMap<K, V>(up._2()));
    }

    public TreeMap<K, V> update(K k, F<V, V> f, V v) {
        P2<Boolean, TreeMap<K, V>> up = this.update(k, f);
        return up._1() != false ? up._2() : this.set(k, v);
    }

    public P3<Set<V>, Option<V>, Set<V>> split(Ord<V> ord, K k) {
        F getSome = Option.fromSome().o(P2.__2()).mapSet(ord);
        return this.tree.split(P.p(k, Option.none())).map1(getSome).map3(getSome).map2(Option.join().o(P2.__2().mapOption()));
    }

    public static <K, V> TreeMap<K, V> setTreeMap(Ord<K> ord, Set<P2<K, Option<V>>> s) {
        TreeMap<K, V> empty = TreeMap.empty(ord);
        TreeMap<K, V> tree = s.toList().foldLeft((tm, p2) -> {
            Option opt = (Option)p2._2();
            if (opt.isSome()) {
                return tm.set(p2._1(), opt.some());
            }
            return tm;
        }, empty);
        return tree;
    }

    public P3<TreeMap<K, V>, Option<V>, TreeMap<K, V>> splitLookup(K k) {
        P3<Set<P2<K, Option<V>>>, Option<P2<K, Option<V>>>, Set<P2<K, Option<V>>>> p3 = this.tree.split(P.p(k, this.get(k)));
        Ord<Object> o = this.tree.ord().contramap(k2 -> P.p(k2, Option.none()));
        return P.p(TreeMap.setTreeMap(o, p3._1()), this.get(k), TreeMap.setTreeMap(o, p3._3()));
    }

    public <W> TreeMap<K, W> map(F<V, W> f) {
        F g = Function.compose(p2 -> P.p(p2._1(), p2._2()), P2.map2_(f.mapOption()));
        F coord = Function.flip(P.p2()).f(Option.none());
        Ord o = this.tree.ord().contramap(coord);
        return new TreeMap<K, V>(this.tree.map(TreeMap.ord(o), g));
    }

    public Option<P2<K, V>> min() {
        return this.tree.min().map((A p) -> P.p(p._1(), ((Option)p._2()).some()));
    }

    public Option<K> minKey() {
        return this.tree.min().map(P2::_1);
    }

    public Option<P2<K, V>> max() {
        return this.tree.max().map((A p) -> P.p(p._1(), ((Option)p._2()).some()));
    }

    public Option<K> maxKey() {
        return this.tree.max().map(P2::_1);
    }

    public TreeMap<K, V> union(TreeMap<K, V> t2) {
        TreeMap<K, V> result = t2;
        for (P2<K, V> p : this) {
            result = result.set(p._1(), p._2());
        }
        return result;
    }

    public TreeMap<K, V> union(Iterable<P2<K, V>> t2) {
        TreeMap<K, V> result = this;
        for (P2<K, V> p : t2) {
            if (this.contains(p._1())) continue;
            result = result.set(p._1(), p._2());
        }
        return result;
    }
}

