/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.Function;
import fj.Monoid;
import fj.Semigroup;
import fj.data.List;
import fj.data.Option;

public final class Longs {
    public static final F<Long, F<Long, Long>> add = Semigroup.longAdditionSemigroup.sum();
    public static final F<Long, F<Long, Long>> multiply = Semigroup.longMultiplicationSemigroup.sum();
    public static final F<Long, F<Long, Long>> subtract = Function.curry((x, y) -> x - y);
    public static final F<Long, Long> negate = x -> x * -1L;
    public static final F<Long, Long> abs = Math::abs;
    public static final F<Long, F<Long, Long>> remainder = Function.curry((a, b) -> a % b);

    private Longs() {
        throw new UnsupportedOperationException();
    }

    public static long sum(List<Long> longs) {
        return Monoid.longAdditionMonoid.sumLeft(longs);
    }

    public static long product(List<Long> longs) {
        return Monoid.longMultiplicationMonoid.sumLeft(longs);
    }

    public static F<String, Option<Long>> fromString() {
        return s -> {
            try {
                return Option.some(Long.valueOf(s));
            }
            catch (NumberFormatException ignored) {
                return Option.none();
            }
        };
    }
}

