/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.util.Iterator;
import org.atp.api.Typeable;
import org.sql.generation.api.grammar.common.ColumnNameList;
import org.sql.generation.api.grammar.query.ColumnReferenceByExpression;
import org.sql.generation.api.grammar.query.ColumnReferenceByName;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.ProcessorUtils;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class ColumnProcessor {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnNamesProcessor
    extends AbstractProcessor<ColumnNameList> {
        public ColumnNamesProcessor() {
            super(ColumnNameList.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, ColumnNameList object, StringBuilder builder) {
            Iterator iter = object.getColumnNames().iterator();
            while (iter.hasNext()) {
                builder.append((String)iter.next());
                if (!iter.hasNext()) continue;
                builder.append(",").append(" ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnReferenceByExpressionProcessor
    extends AbstractProcessor<ColumnReferenceByExpression> {
        public ColumnReferenceByExpressionProcessor() {
            super(ColumnReferenceByExpression.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, ColumnReferenceByExpression columnRef, StringBuilder builder) {
            processor.process((Typeable<?>)columnRef.getExpression(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnReferenceByNameProcessor
    extends AbstractProcessor<ColumnReferenceByName> {
        public ColumnReferenceByNameProcessor() {
            super(ColumnReferenceByName.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, ColumnReferenceByName columnRef, StringBuilder builder) {
            String tableName = columnRef.getTableName();
            if (ProcessorUtils.notNullAndNotEmpty(tableName).booleanValue()) {
                builder.append(tableName).append(".");
            }
            builder.append(columnRef.getColumnName());
        }
    }
}

