/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.factories;

import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.builders.query.TableReferenceBuilder;
import org.sql.generation.api.grammar.common.ColumnNameList;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.query.QueryExpression;
import org.sql.generation.api.grammar.query.TableAlias;
import org.sql.generation.api.grammar.query.TableReferenceByExpression;
import org.sql.generation.api.grammar.query.TableReferenceByName;
import org.sql.generation.api.grammar.query.TableReferencePrimary;
import org.sql.generation.api.grammar.query.joins.JoinCondition;
import org.sql.generation.api.grammar.query.joins.NamedColumnsJoin;
import org.sql.generation.api.vendor.SQLVendor;
import org.sql.generation.implementation.grammar.builders.query.TableReferenceBuilderImpl;
import org.sql.generation.implementation.grammar.common.TableNameImpl;
import org.sql.generation.implementation.grammar.factories.AbstractTableRefFactory;
import org.sql.generation.implementation.grammar.query.TableAliasImpl;
import org.sql.generation.implementation.grammar.query.TableReferenceByExpressionImpl;
import org.sql.generation.implementation.grammar.query.TableReferenceByNameImpl;
import org.sql.generation.implementation.grammar.query.joins.JoinConditionImpl;
import org.sql.generation.implementation.grammar.query.joins.NamedColumnsJoinImpl;

public class DefaultTableRefFactory
extends AbstractTableRefFactory {
    private final SQLVendor _vendor;

    public DefaultTableRefFactory(SQLVendor vendor) {
        NullArgumentException.validateNotNull((String)"vendor", (Object)vendor);
        this._vendor = vendor;
    }

    public JoinCondition jc(BooleanExpression condition) {
        return new JoinConditionImpl(condition);
    }

    public NamedColumnsJoin nc(ColumnNameList columnNames) {
        return new NamedColumnsJoinImpl(columnNames);
    }

    public TableReferenceByName table(TableName tableName, TableAlias alias) {
        return new TableReferenceByNameImpl(tableName, alias);
    }

    public TableName tableName(String schemaName, String tableName) {
        return new TableNameImpl(schemaName, tableName);
    }

    public TableAlias tableAliasWithCols(String tableNameAlias, String ... colNames) {
        ColumnNameList colNameList = null;
        if (colNames.length > 0) {
            colNameList = this._vendor.getColumnsFactory().colNames(colNames);
        }
        return new TableAliasImpl(tableNameAlias, colNameList);
    }

    public TableReferenceByExpression table(QueryExpression query, TableAlias alias) {
        return new TableReferenceByExpressionImpl(query, alias);
    }

    public TableReferenceBuilder tableBuilder(TableReferencePrimary firstTable) {
        return new TableReferenceBuilderImpl(firstTable);
    }
}

