/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.atp.api.Typeable;
import org.slf4j.LoggerFactory;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.literals.LiteralExpression;
import org.sql.generation.api.grammar.query.ColumnReferences;
import org.sql.generation.api.grammar.query.CorrespondingSpec;
import org.sql.generation.api.grammar.query.FromClause;
import org.sql.generation.api.grammar.query.GroupByClause;
import org.sql.generation.api.grammar.query.LimitSpecification;
import org.sql.generation.api.grammar.query.OffsetSpecification;
import org.sql.generation.api.grammar.query.OrderByClause;
import org.sql.generation.api.grammar.query.Ordering;
import org.sql.generation.api.grammar.query.OrdinaryGroupingSet;
import org.sql.generation.api.grammar.query.QueryExpression;
import org.sql.generation.api.grammar.query.QueryExpressionBody;
import org.sql.generation.api.grammar.query.QueryExpressionBodyBinary;
import org.sql.generation.api.grammar.query.QuerySpecification;
import org.sql.generation.api.grammar.query.RowDefinition;
import org.sql.generation.api.grammar.query.RowSubQuery;
import org.sql.generation.api.grammar.query.SelectColumnClause;
import org.sql.generation.api.grammar.query.SetOperation;
import org.sql.generation.api.grammar.query.SortSpecification;
import org.sql.generation.api.grammar.query.TableReference;
import org.sql.generation.api.grammar.query.TableValueConstructor;
import org.sql.generation.implementation.grammar.booleans.BooleanUtils;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.ProcessorUtils;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryProcessing {
    public static void processOptionalBooleanExpression(SQLProcessorAggregator processor, StringBuilder builder, BooleanExpression expression, String prefix, String name) {
        if (expression != null && !BooleanUtils.isEmpty(expression).booleanValue()) {
            QueryProcessing.processOptional(processor, builder, expression, prefix, name);
        }
    }

    public static void processOptional(SQLProcessorAggregator processor, StringBuilder builder, Typeable<?> element, String prefix, String name) {
        if (element != null) {
            builder.append(prefix);
            if (name != null) {
                builder.append(name).append(" ");
            }
            processor.process(element, builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LimitSpecificationProcessor
    extends AbstractProcessor<LimitSpecification> {
        public LimitSpecificationProcessor() {
            super(LimitSpecification.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, LimitSpecification object, StringBuilder builder) {
            NonBooleanExpression count = this.getRealCount(object.getCount());
            if (count != null) {
                String postfix;
                boolean isComplex;
                String prefix = this.getPrefix(aggregator);
                if (prefix != null) {
                    builder.append(prefix).append(" ");
                }
                boolean bl = isComplex = !(count instanceof LiteralExpression);
                if (isComplex) {
                    builder.append("(").append("\n");
                }
                aggregator.process((Typeable<?>)count, builder);
                if (isComplex) {
                    builder.append(")");
                }
                if ((postfix = this.getPostfix(aggregator)) != null) {
                    builder.append(" ").append(postfix);
                }
            }
        }

        protected NonBooleanExpression getRealCount(NonBooleanExpression limitCount) {
            return limitCount;
        }

        protected String getPrefix(SQLProcessorAggregator processor) {
            return "FETCH FIRST";
        }

        protected String getPostfix(SQLProcessorAggregator processor) {
            return "ROWS ONLY";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OffsetSpecificationProcessor
    extends AbstractProcessor<OffsetSpecification> {
        public OffsetSpecificationProcessor() {
            super(OffsetSpecification.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, OffsetSpecification object, StringBuilder builder) {
            String postfix;
            NonBooleanExpression skip;
            boolean isComplex;
            String prefix = this.getPrefix(aggregator);
            if (prefix != null) {
                builder.append(prefix).append(" ");
            }
            boolean bl = isComplex = !((skip = object.getSkip()) instanceof LiteralExpression);
            if (isComplex) {
                builder.append("(").append("\n");
            }
            aggregator.process((Typeable<?>)skip, builder);
            if (isComplex) {
                builder.append(")");
            }
            if ((postfix = this.getPostfix(aggregator)) != null) {
                builder.append(" ").append(postfix);
            }
        }

        protected String getPrefix(SQLProcessorAggregator processor) {
            return "OFFSET";
        }

        protected String getPostfix(SQLProcessorAggregator processor) {
            return "ROWS";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RowDefinitionProcessor
    extends AbstractProcessor<RowDefinition> {
        public RowDefinitionProcessor() {
            super(RowDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, RowDefinition object, StringBuilder builder) {
            builder.append("(");
            Iterator vals = object.getRowElements().iterator();
            while (vals.hasNext()) {
                aggregator.process((Typeable)vals.next(), builder);
                if (!vals.hasNext()) continue;
                builder.append(",").append(" ");
            }
            builder.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RowSubQueryProcessor
    extends AbstractProcessor<RowSubQuery> {
        public RowSubQueryProcessor() {
            super(RowSubQuery.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, RowSubQuery object, StringBuilder builder) {
            builder.append("(");
            aggregator.process((Typeable<?>)object.getQueryExpression(), builder);
            builder.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableValueConstructorProcessor
    extends AbstractProcessor<TableValueConstructor> {
        public TableValueConstructorProcessor() {
            super(TableValueConstructor.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, TableValueConstructor object, StringBuilder builder) {
            builder.append("VALUES").append(" ");
            Iterator iter = object.getRows().iterator();
            while (iter.hasNext()) {
                aggregator.process((Typeable)iter.next(), builder);
                if (!iter.hasNext()) continue;
                builder.append(",").append(" ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderByProcessor
    extends AbstractProcessor<OrderByClause> {
        public OrderByProcessor() {
            super(OrderByClause.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, OrderByClause orderBy, StringBuilder builder) {
            if (!orderBy.getOrderingColumns().isEmpty()) {
                builder.append("\n").append("ORDER BY").append(" ");
                Iterator iter = orderBy.getOrderingColumns().iterator();
                while (iter.hasNext()) {
                    aggregator.process((Typeable)iter.next(), builder);
                    if (!iter.hasNext()) continue;
                    builder.append(",").append(" ");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupByProcessor
    extends AbstractProcessor<GroupByClause> {
        public GroupByProcessor() {
            super(GroupByClause.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, GroupByClause groupBy, StringBuilder builder) {
            if (!groupBy.getGroupingElements().isEmpty()) {
                builder.append("\n").append("GROUP BY").append(" ");
                Iterator iter = groupBy.getGroupingElements().iterator();
                while (iter.hasNext()) {
                    aggregator.process((Typeable)iter.next(), builder);
                    if (!iter.hasNext()) continue;
                    builder.append(",").append(" ");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrdinaryGroupingSetProcessor
    extends AbstractProcessor<OrdinaryGroupingSet> {
        public OrdinaryGroupingSetProcessor() {
            super(OrdinaryGroupingSet.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, OrdinaryGroupingSet object, StringBuilder builder) {
            Iterator iter = object.getColumns().iterator();
            while (iter.hasNext()) {
                processor.process((Typeable)iter.next(), builder);
                if (!iter.hasNext()) continue;
                builder.append(",").append(" ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortSpecificationProcessor
    extends AbstractProcessor<SortSpecification> {
        private static final Map<Ordering, String> _defaultOrderingStrings;
        private final Map<Ordering, String> _orderingStrings;

        public SortSpecificationProcessor() {
            this(_defaultOrderingStrings);
        }

        public SortSpecificationProcessor(Map<Ordering, String> orderingStrings) {
            super(SortSpecification.class);
            NullArgumentException.validateNotNull((String)"ordering strings", orderingStrings);
            this._orderingStrings = orderingStrings;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, SortSpecification object, StringBuilder builder) {
            processor.process((Typeable<?>)object.getValueExpression(), builder);
            builder.append(" ").append(this._orderingStrings.get(object.getOrderingSpecification()));
        }

        static {
            HashMap<Ordering, String> map = new HashMap<Ordering, String>();
            map.put(Ordering.ASCENDING, "ASC");
            map.put(Ordering.DESCENDING, "DESC");
            _defaultOrderingStrings = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CorrespondingSpecProcessor
    extends AbstractProcessor<CorrespondingSpec> {
        public CorrespondingSpecProcessor() {
            super(CorrespondingSpec.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, CorrespondingSpec object, StringBuilder builder) {
            builder.append("CORRESPONDING");
            if (object.getColumnList() != null) {
                builder.append(" ").append("BY").append(" ");
                processor.process((Typeable<?>)object.getColumnList(), builder);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryExpressionProcessor
    extends AbstractProcessor<QueryExpression> {
        public QueryExpressionProcessor() {
            super(QueryExpression.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, QueryExpression object, StringBuilder builder) {
            processor.process((Typeable<?>)object.getQueryExpressionBody(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FromProcessor
    extends AbstractProcessor<FromClause> {
        public FromProcessor() {
            super(FromClause.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, FromClause from, StringBuilder builder) {
            if (!from.getTableReferences().isEmpty()) {
                builder.append("\n").append("FROM").append(" ");
                Iterator iter = from.getTableReferences().iterator();
                while (iter.hasNext()) {
                    aggregator.process(((TableReference)iter.next()).asTypeable(), builder);
                    if (!iter.hasNext()) continue;
                    builder.append(",").append(" ");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectColumnsProcessor
    extends AbstractProcessor<SelectColumnClause> {
        public SelectColumnsProcessor() {
            super(SelectColumnClause.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SelectColumnClause select, StringBuilder builder) {
            builder.append("SELECT").append(" ");
            ProcessorUtils.processSetQuantifier(select.getSetQuantifier(), builder);
            builder.append(" ");
            if (select instanceof ColumnReferences) {
                Iterator iter = ((ColumnReferences)select).getColumns().iterator();
                while (iter.hasNext()) {
                    ColumnReferences.ColumnReferenceInfo info = (ColumnReferences.ColumnReferenceInfo)iter.next();
                    aggregator.process((Typeable<?>)info.getReference(), builder);
                    String alias = info.getAlias();
                    if (ProcessorUtils.notNullAndNotEmpty(alias).booleanValue()) {
                        builder.append(" ").append("AS").append(" ").append(alias);
                    }
                    if (!iter.hasNext()) continue;
                    builder.append(",").append(" ");
                }
            } else {
                builder.append("*");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuerySpecificationProcessor
    extends AbstractProcessor<QuerySpecification> {
        public QuerySpecificationProcessor() {
            this((Class<? extends QuerySpecification>)QuerySpecification.class);
        }

        public QuerySpecificationProcessor(Class<? extends QuerySpecification> queryClass) {
            super(queryClass);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, QuerySpecification query, StringBuilder builder) {
            processor.process((Typeable<?>)query.getColumns(), builder);
            processor.process((Typeable<?>)query.getFrom(), builder);
            QueryProcessing.processOptionalBooleanExpression(processor, builder, query.getWhere(), "\n", "WHERE");
            processor.process((Typeable<?>)query.getGroupBy(), builder);
            QueryProcessing.processOptionalBooleanExpression(processor, builder, query.getHaving(), "\n", "HAVING");
            processor.process((Typeable<?>)query.getOrderBy(), builder);
            OffsetSpecification first = null;
            LimitSpecification second = null;
            if (this.isOffsetBeforeLimit(processor)) {
                first = query.getOffsetSpecification();
                second = query.getLimitSpecification();
            } else {
                first = query.getLimitSpecification();
                second = query.getOffsetSpecification();
            }
            if (first != null || second != null) {
                this.processLimitAndOffset(processor, builder, (Typeable<?>)first, (Typeable<?>)second);
            }
            if (query.getOrderBy() == null && (query.getOffsetSpecification() != null || query.getLimitSpecification() != null)) {
                LoggerFactory.getLogger((String)this.getClass().getName()).warn("Spotted query with OFFSET and/or FETCH FIRST clause, but without ORDER BY. The result will be unpredictable!\nQuery: " + builder.toString());
            }
        }

        protected boolean isOffsetBeforeLimit(SQLProcessorAggregator processor) {
            return true;
        }

        protected void processLimitAndOffset(SQLProcessorAggregator processor, StringBuilder builder, Typeable<?> first, Typeable<?> second) {
            QueryProcessing.processOptional(processor, builder, first, "\n", null);
            QueryProcessing.processOptional(processor, builder, second, "\n", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryExpressionBinaryProcessor
    extends AbstractProcessor<QueryExpressionBodyBinary> {
        private static final Map<SetOperation, String> _defaultSetOperations;
        private final Map<SetOperation, String> _setOperations;

        public QueryExpressionBinaryProcessor() {
            this(_defaultSetOperations);
        }

        public QueryExpressionBinaryProcessor(Map<SetOperation, String> setOperations) {
            super(QueryExpressionBodyBinary.class);
            NullArgumentException.validateNotNull((String)"set operations", setOperations);
            this._setOperations = setOperations;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, QueryExpressionBodyBinary body, StringBuilder builder) {
            Boolean leftIsNotEmpty = body.getLeft() != QueryExpressionBody.EmptyQueryExpressionBody.INSTANCE;
            if (leftIsNotEmpty.booleanValue()) {
                builder.append("(");
                processor.process((Typeable<?>)body.getLeft(), builder);
                builder.append(")").append("\n");
                this.processSetOperation(body.getSetOperation(), builder);
                builder.append(" ");
                ProcessorUtils.processSetQuantifier(body.getSetQuantifier(), builder);
                CorrespondingSpec correspondingCols = body.getCorrespondingColumns();
                if (correspondingCols != null) {
                    builder.append(" ");
                    processor.process((Typeable<?>)correspondingCols, builder);
                }
                builder.append("\n").append("(");
            }
            processor.process((Typeable<?>)body.getRight(), builder);
            if (leftIsNotEmpty.booleanValue()) {
                builder.append(")");
            }
        }

        protected void processSetOperation(SetOperation operation, StringBuilder builder) {
            builder.append(this._setOperations.get(operation));
        }

        static {
            HashMap<SetOperation, String> operations = new HashMap<SetOperation, String>();
            operations.put(SetOperation.EXCEPT, "EXCEPT");
            operations.put(SetOperation.INTERSECT, "INTERSECT");
            operations.put(SetOperation.UNION, "UNION");
            _defaultSetOperations = operations;
        }
    }
}

