/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation.mysql;

import org.atp.api.Typeable;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.query.OffsetSpecification;
import org.sql.generation.api.vendor.MySQLVendor;
import org.sql.generation.implementation.transformation.QueryProcessing;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class QueryProcessing {
    private static final String MYSQL_LIMIT_PREFIX = "LIMIT";
    private static final String MYSQL_LIMIT_POSTFIX = null;
    private static final String MYSQL_OFFSET_PREFIX = "OFFSET";
    private static final String MYSQL_OFFSET_POSTFIX = null;

    public static class MySQLLimitSpecificationProcessor
    extends QueryProcessing.LimitSpecificationProcessor {
        protected String getPrefix(SQLProcessorAggregator processor) {
            return QueryProcessing.MYSQL_LIMIT_PREFIX;
        }

        protected String getPostfix(SQLProcessorAggregator processor) {
            return MYSQL_LIMIT_POSTFIX;
        }
    }

    public static class MySQLOffsetSpecificationProcessor
    extends QueryProcessing.OffsetSpecificationProcessor {
        protected String getPrefix(SQLProcessorAggregator processor) {
            return QueryProcessing.MYSQL_OFFSET_PREFIX;
        }

        protected String getPostfix(SQLProcessorAggregator processor) {
            return MYSQL_OFFSET_POSTFIX;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MySQLQuerySpecificationProcessor
    extends QueryProcessing.QuerySpecificationProcessor {
        @Override
        protected boolean isOffsetBeforeLimit(SQLProcessorAggregator processor) {
            return false;
        }

        @Override
        protected void processLimitAndOffset(SQLProcessorAggregator processor, StringBuilder builder, Typeable<?> first, Typeable<?> second) {
            MySQLVendor vendor = (MySQLVendor)processor.getVendor();
            if (vendor.legacyLimit()) {
                builder.append("\n").append(QueryProcessing.MYSQL_LIMIT_PREFIX).append(" ");
                if (second != null) {
                    processor.process((Typeable<?>)((OffsetSpecification)second).getSkip(), builder);
                    builder.append(",");
                }
                if (first != null && first.getCount() != null) {
                    processor.process((Typeable<?>)first.getCount(), builder);
                } else if (second != null) {
                    builder.append(Long.MAX_VALUE);
                }
            } else {
                if (first == null && second != null) {
                    first = vendor.getQueryFactory().limit((NonBooleanExpression)vendor.getLiteralFactory().n((Number)Long.MAX_VALUE));
                }
                super.processLimitAndOffset(processor, builder, (Typeable<?>)first, second);
            }
        }
    }
}

