/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.util.Arrays;
import javax.media.j3d.Behavior;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.IndexedUnorderSet;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnActivation;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnDeactivation;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOnSensorEntry;
import javax.media.j3d.WakeupOnSensorExit;
import javax.media.j3d.WakeupOnViewPlatformEntry;
import javax.media.j3d.WakeupOnViewPlatformExit;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class BehaviorStructure
extends J3dStructure {
    IndexedUnorderSet behaviors;
    IndexedUnorderSet viewPlatforms;
    IndexedUnorderSet scheduleList;
    UnorderList[] processList = new UnorderList[10];
    Point3d vpCenter = new Point3d();
    Point3d vpTransCenter = new Point3d();
    WakeupIndexedList boundsEntryList;
    WakeupIndexedList boundsExitList;
    WakeupIndexedList currentSensorEntryList;
    WakeupIndexedList currentSensorExitList;
    WakeupIndexedList wakeupOnAWTEvent;
    WakeupIndexedList wakeupOnActivation;
    WakeupIndexedList wakeupOnDeactivation;
    WakeupIndexedList wakeupOnBehaviorPost;
    WakeupIndexedList wakeupOnElapsedFrames;
    WakeupIndexedList wakeupOnViewPlatformEntry;
    WakeupIndexedList wakeupOnViewPlatformExit;
    WakeupIndexedList wakeupOnSensorEntry;
    WakeupIndexedList wakeupOnSensorExit;
    UnorderList transformViewPlatformList = new UnorderList(ViewPlatformRetained.class);
    int activeWakeupOnFrameCount = 0;
    int activeWakeupOnSensorCount = 0;
    UnorderList awtEventsBuffer = new UnorderList(AWTEvent.class);
    int[] postIDBuffer = new int[10];
    int[] clonePostIDBuffer = new int[this.postIDBuffer.length];
    UnorderList behaviorPostBuffer = new UnorderList(Behavior.class);
    Transform3D sensorTransform = new Transform3D();
    Vector3d sensorLoc = new Vector3d();
    Point3d ptSensorLoc = new Point3d();
    UnorderList physicalEnvironments = new UnorderList(1, PhysicalEnvironment.class);
    UnorderList pendingBehaviors = new UnorderList(BehaviorRetained.class);
    boolean branchDetach = false;
    long awtEventTimestamp = 1L;
    boolean transformMsg = false;
    UpdateTargets targets = null;

    BehaviorStructure(VirtualUniverse u) {
        super(u, 256);
        for (int i = 9; i >= 0; --i) {
            this.processList[i] = new UnorderList(BehaviorRetained.class);
        }
        this.behaviors = new IndexedUnorderSet(BehaviorRetained.class, 0, u);
        this.viewPlatforms = new IndexedUnorderSet(ViewPlatformRetained.class, 0, u);
        this.scheduleList = new IndexedUnorderSet(BehaviorRetained.class, 1, u);
        this.boundsEntryList = new WakeupIndexedList(WakeupOnViewPlatformEntry.class, 1, u);
        this.boundsExitList = new WakeupIndexedList(WakeupOnViewPlatformExit.class, 1, u);
        this.currentSensorEntryList = new WakeupIndexedList(WakeupOnSensorEntry.class, 1, u);
        this.currentSensorExitList = new WakeupIndexedList(WakeupOnSensorExit.class, 1, u);
        this.wakeupOnAWTEvent = new WakeupIndexedList(WakeupOnAWTEvent.class, 0, u);
        this.wakeupOnActivation = new WakeupIndexedList(WakeupOnActivation.class, 0, u);
        this.wakeupOnDeactivation = new WakeupIndexedList(WakeupOnDeactivation.class, 0, u);
        this.wakeupOnBehaviorPost = new WakeupIndexedList(WakeupOnBehaviorPost.class, 0, u);
        this.wakeupOnElapsedFrames = new WakeupIndexedList(WakeupOnElapsedFrames.class, 0, u);
        this.wakeupOnViewPlatformEntry = new WakeupIndexedList(WakeupOnViewPlatformEntry.class, 0, u);
        this.wakeupOnViewPlatformExit = new WakeupIndexedList(WakeupOnViewPlatformExit.class, 0, u);
        this.wakeupOnSensorEntry = new WakeupIndexedList(WakeupOnSensorEntry.class, 0, u);
        this.wakeupOnSensorExit = new WakeupIndexedList(WakeupOnSensorExit.class, 0, u);
    }

    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg > 0) {
            for (int i = 0; i < nMsg; ++i) {
                J3dMessage m = messages[i];
                switch (m.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 28: {
                        this.processConditionMet((BehaviorRetained)m.args[0], (Boolean)m.args[1]);
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])m.args[0]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(m);
                        break;
                    }
                    case 49: {
                        this.activateBehaviors();
                        break;
                    }
                    case 29: {
                        this.addToScheduleList((BehaviorRetained)m.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 30: {
                        this.removeFromScheduleList((BehaviorRetained)m.args[1]);
                        this.reEvaluateWakeupCount();
                        break;
                    }
                    case 55: {
                        ((BehaviorRetained)m.args[1]).schedulingInterval = (Integer)m.args[2];
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(m);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged((Object[])m.args[3], (Bounds)m.args[2]);
                        break;
                    }
                    case 4: {
                        this.reEvaluatePhysicalEnvironments();
                        ViewPlatform v = ((View)m.args[0]).getViewPlatform();
                        if (v == null) break;
                        this.processViewPlatformTransform((ViewPlatformRetained)v.retained);
                        break;
                    }
                    case 48: {
                        ViewPlatformRetained vp = (ViewPlatformRetained)m.args[0];
                        vp.updateActivationRadius(((Float)m.args[1]).floatValue());
                        this.processViewPlatformTransform(vp);
                        break;
                    }
                    case 35: {
                        BehaviorRetained behav = (BehaviorRetained)m.args[1];
                        behav.updateTransformRegion();
                        this.processBehaviorTransform(behav);
                        break;
                    }
                    case 60: {
                        BehaviorRetained behav = (BehaviorRetained)m.args[0];
                        behav.active = false;
                        this.addToScheduleList(behav);
                    }
                }
                m.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                UnorderList arrList = this.targets.targetList[2];
                if (arrList != null) {
                    this.processBehXformChanged(arrList);
                }
                if ((arrList = this.targets.targetList[4]) != null) {
                    this.processVpfXformChanged(arrList);
                }
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(messages, 0, nMsg, null);
        }
        if (this.activeWakeupOnSensorCount <= 0) {
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 17);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 1);
            }
        } else {
            this.checkSensorEntryExit();
            if (this.activeWakeupOnFrameCount > 0) {
                VirtualUniverse.mc.sendRunMessage(this.universe, 273);
            } else {
                VirtualUniverse.mc.sendRunMessage(this.universe, 257);
            }
        }
    }

    void insertNodes(Object[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (node instanceof BehaviorRetained) {
                this.pendingBehaviors.add(node);
                continue;
            }
            if (!(node instanceof ViewPlatformRetained)) continue;
            this.addViewPlatform((ViewPlatformRetained)node);
        }
    }

    void activateBehaviors() {
        BehaviorRetained[] behavArr = (BehaviorRetained[])this.pendingBehaviors.toArray(false);
        for (int i = this.pendingBehaviors.arraySize() - 1; i >= 0; --i) {
            BehaviorRetained behav = behavArr[i];
            behav.wakeupCondition = behav.newWakeupCondition;
            if (behav.wakeupCondition == null) continue;
            behav.wakeupCondition.buildTree(null, 0, behav);
            behav.conditionSet = true;
            this.behaviors.add(behav);
            behav.updateTransformRegion();
            this.addToScheduleList(behav);
        }
        this.pendingBehaviors.clear();
    }

    void addViewPlatform(ViewPlatformRetained vp) {
        int i;
        BehaviorRetained[] behavArr = (BehaviorRetained[])this.behaviors.toArray(false);
        this.viewPlatforms.add(vp);
        vp.updateTransformRegion();
        if (!vp.isActiveViewPlatform()) {
            return;
        }
        for (i = this.behaviors.arraySize() - 1; i >= 0; --i) {
            this.addToScheduleList(behavArr[i]);
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArr = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (i = this.wakeupOnViewPlatformEntry.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformEntry wentry = wakeupOnViewPlatformEntryArr[i];
            if (this.boundsEntryList.contains(wentry) || !wentry.transformedRegion.intersect(vp.center)) continue;
            this.boundsEntryList.add(wentry);
            wentry.triggeredVP = vp;
            wentry.setTriggered();
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArr = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (i = this.wakeupOnViewPlatformExit.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformExit wexit = wakeupOnViewPlatformExitArr[i];
            if (this.boundsExitList.contains(wexit) || !wexit.transformedRegion.intersect(vp.center)) continue;
            wexit.triggeredVP = vp;
            this.boundsExitList.add(wexit);
        }
    }

    @Override
    void removeNodes(J3dMessage m) {
        Object[] nodes = (Object[])m.args[0];
        boolean behavRemove = false;
        for (int i = 0; i < nodes.length; ++i) {
            Object node = nodes[i];
            if (node instanceof BehaviorRetained) {
                behavRemove = true;
                this.removeBehavior((BehaviorRetained)node);
                continue;
            }
            if (!(node instanceof ViewPlatformRetained)) continue;
            this.removeViewPlatform((ViewPlatformRetained)node);
        }
        this.wakeupOnAWTEvent.clearMirror();
        this.awtEventsBuffer.clearMirror();
        this.wakeupOnBehaviorPost.clearMirror();
        this.behaviorPostBuffer.clearMirror();
        this.wakeupOnSensorEntry.clearMirror();
        this.wakeupOnSensorExit.clearMirror();
        this.branchDetach = true;
        if (behavRemove) {
            WakeupOnAWTEvent[] awtConds = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
            int eventSize = this.wakeupOnAWTEvent.arraySize();
            boolean focusEnable = false;
            boolean keyEnable = false;
            boolean mouseMotionEnable = false;
            boolean mouseEnable = false;
            boolean mouseWheelEnable = false;
            boolean incTimestamp = false;
            for (int i = 0; i < eventSize; ++i) {
                WakeupOnAWTEvent awtCond = awtConds[i];
                int awtId = awtCond.AwtId;
                long eventMask = awtCond.EventMask;
                if (awtId >= 1004 && awtId <= 1005 || (eventMask & 4L) != 0L) {
                    focusEnable = true;
                }
                if (awtId >= 400 && awtId <= 402 || (eventMask & 8L) != 0L) {
                    keyEnable = true;
                }
                if (awtId >= 500 && awtId <= 507) {
                    if (awtId == 506 || awtId == 503) {
                        mouseMotionEnable = true;
                        continue;
                    }
                    if (awtId == 504 || awtId == 505 || awtId == 500 || awtId == 501 || awtId == 502) {
                        mouseEnable = true;
                        continue;
                    }
                    if (awtId != 507) continue;
                    mouseWheelEnable = true;
                    continue;
                }
                if ((eventMask & 0x10L) != 0L) {
                    mouseEnable = true;
                }
                if ((eventMask & 0x20L) != 0L) {
                    mouseMotionEnable = true;
                }
                if ((eventMask & 0x20000L) == 0L) continue;
                mouseWheelEnable = true;
            }
            if (!focusEnable && this.universe.enableFocus) {
                incTimestamp = true;
                this.universe.disableFocusEvents();
            }
            if (!keyEnable && this.universe.enableKey) {
                incTimestamp = true;
                this.universe.disableKeyEvents();
            }
            if (!mouseWheelEnable && this.universe.enableMouseWheel) {
                incTimestamp = true;
                this.universe.disableMouseWheelEvents();
            }
            if (!mouseMotionEnable && this.universe.enableMouseMotion) {
                incTimestamp = true;
                this.universe.disableMouseMotionEvents();
            }
            if (!mouseEnable && this.universe.enableMouse) {
                incTimestamp = true;
                this.universe.disableMouseEvents();
            }
            if (incTimestamp) {
                ++this.awtEventTimestamp;
            }
        }
    }

    void removeViewPlatform(ViewPlatformRetained vp) {
        ViewPlatformRetained triggeredVP;
        int i;
        this.viewPlatforms.remove(vp);
        BehaviorRetained[] scheduleArr = (BehaviorRetained[])this.scheduleList.toArray(false);
        for (i = this.scheduleList.arraySize() - 1; i >= 0; --i) {
            BehaviorRetained behav = scheduleArr[i];
            if (this.intersectVPRegion(behav.transformedRegion)) continue;
            this.removeFromScheduleList(behav);
        }
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (i = this.boundsEntryList.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i];
            triggeredVP = this.intersectVPCenter(wentry.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsEntryList.remove(wentry);
        }
        WakeupOnViewPlatformExit[] boundsExitArr = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (i = this.boundsExitList.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformExit wexit = boundsExitArr[i];
            triggeredVP = this.intersectVPCenter(wexit.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsExitList.remove(wexit);
            wexit.setTriggered();
        }
    }

    void removeBehavior(BehaviorRetained behav) {
        this.behaviors.remove(behav);
        if (behav.wakeupCondition != null && behav.wakeupCondition.behav != null) {
            behav.wakeupCondition.cleanTree(this);
            if (behav.universe == this.universe) {
                behav.conditionSet = false;
            }
        }
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i = this.boundsEntryList.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i];
            if (wentry.behav != behav) continue;
            this.boundsEntryList.remove(wentry);
        }
        WakeupOnViewPlatformExit[] boundsExitArr = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (int i = this.boundsExitList.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformExit wexit = boundsExitArr[i];
            if (wexit.behav != behav) continue;
            this.boundsExitList.remove(wexit);
        }
        WakeupOnSensorEntry[] currentSensorEntryArr = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i = this.currentSensorEntryList.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorEntry sentry = currentSensorEntryArr[i];
            if (sentry.behav != behav) continue;
            this.currentSensorEntryList.remove(sentry);
        }
        WakeupOnSensorExit[] currentSensorExitArr = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        for (int i = this.currentSensorExitList.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorExit sexit = currentSensorExitArr[i];
            if (sexit.behav != behav) continue;
            this.currentSensorExitList.remove(sexit);
        }
        this.removeFromScheduleList(behav);
    }

    void handleAWTEvent(AWTEvent evt) {
        this.awtEventsBuffer.add(evt);
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAWTEvent() {
        int awtBufferSize;
        AWTEvent[] events;
        WakeupOnAWTEvent[] awtConds = (WakeupOnAWTEvent[])this.wakeupOnAWTEvent.toArray();
        int eventSize = this.wakeupOnAWTEvent.arraySize();
        UnorderList unorderList = this.awtEventsBuffer;
        synchronized (unorderList) {
            events = (AWTEvent[])this.awtEventsBuffer.toArray();
            awtBufferSize = this.awtEventsBuffer.size();
            this.awtEventsBuffer.clear();
        }
        for (int i = 0; i < eventSize; ++i) {
            WakeupOnAWTEvent awtCond = awtConds[i];
            for (int j = 0; j < awtBufferSize; ++j) {
                AWTEvent evt = events[j];
                int id = evt.getID();
                if (awtCond.AwtId != 0) {
                    if (awtCond.AwtId != id) continue;
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id >= 100 && id <= 103 && (awtCond.EventMask & 1L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id >= 1004 && id <= 1005 && (awtCond.EventMask & 4L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id >= 400 && id <= 402 && (awtCond.EventMask & 8L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if ((id == 500 || id == 504 || id == 505 || id == 501 || id == 502) && (awtCond.EventMask & 0x10L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if ((id == 506 || id == 503) && (awtCond.EventMask & 0x20L) != 0L) {
                    awtCond.addAWTEvent(evt);
                    continue;
                }
                if (id != 507 || (awtCond.EventMask & 0x20000L) == 0L) continue;
                awtCond.addAWTEvent(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost(Behavior behav, int postid) {
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            int size = this.behaviorPostBuffer.size();
            if (this.postIDBuffer.length == size) {
                int[] oldbuffer = this.postIDBuffer;
                this.postIDBuffer = new int[size << 1];
                System.arraycopy(oldbuffer, 0, this.postIDBuffer, 0, size);
            }
            this.postIDBuffer[size] = postid;
            this.behaviorPostBuffer.add(behav);
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBehaviorPost() {
        int behavBufferSize;
        Behavior[] behavArr;
        WakeupOnBehaviorPost[] wakeupConds = (WakeupOnBehaviorPost[])this.wakeupOnBehaviorPost.toArray();
        UnorderList unorderList = this.behaviorPostBuffer;
        synchronized (unorderList) {
            behavArr = (Behavior[])this.behaviorPostBuffer.toArray();
            behavBufferSize = this.behaviorPostBuffer.size();
            if (this.clonePostIDBuffer.length < behavBufferSize) {
                this.clonePostIDBuffer = new int[behavBufferSize];
            }
            System.arraycopy(this.postIDBuffer, 0, this.clonePostIDBuffer, 0, behavBufferSize);
            this.behaviorPostBuffer.clear();
        }
        int size = this.wakeupOnBehaviorPost.arraySize();
        for (int i = 0; i < size; ++i) {
            WakeupOnBehaviorPost wakeup = wakeupConds[i];
            for (int j = 0; j < behavBufferSize; ++j) {
                Behavior behav = behavArr[j];
                int postid = this.clonePostIDBuffer[j];
                if (wakeup.post != postid && wakeup.post != 0 || behav != wakeup.armingBehavior && wakeup.armingBehavior != null) continue;
                wakeup.triggeringBehavior = behav;
                wakeup.triggeringPost = postid;
                wakeup.setTriggered();
            }
        }
    }

    void incElapsedFrames() {
        WakeupOnElapsedFrames[] wakeupConds = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int size = this.wakeupOnElapsedFrames.arraySize();
        int i = 0;
        while (i < size) {
            wakeupConds[i++].newFrame();
        }
        if (size > 0) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 257);
        }
        if (this.branchDetach) {
            this.wakeupOnElapsedFrames.clearMirror();
            this.branchDetach = false;
        }
    }

    void removeVPEntryCondition(WakeupCondition w) {
        this.wakeupOnViewPlatformEntry.remove(w);
    }

    void addVPEntryCondition(WakeupOnViewPlatformEntry w) {
        boolean needTrigger = true;
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i = this.boundsEntryList.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            this.boundsEntryList.remove(i);
            needTrigger = false;
            break;
        }
        this.wakeupOnViewPlatformEntry.add(w);
        ViewPlatformRetained triggeredVP = this.intersectVPCenter(w.transformedRegion);
        if (triggeredVP != null) {
            this.boundsEntryList.add(w);
        }
        if (needTrigger && triggeredVP != null) {
            w.triggeredVP = triggeredVP;
            w.setTriggered();
        }
    }

    void removeVPExitCondition(WakeupOnViewPlatformExit w) {
        this.wakeupOnViewPlatformExit.remove(w);
    }

    void addVPExitCondition(WakeupOnViewPlatformExit w) {
        boolean needTrigger = true;
        WakeupOnViewPlatformExit[] boundsExitArr = (WakeupOnViewPlatformExit[])this.boundsExitList.toArray(false);
        for (int i = this.boundsExitList.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformExit wexit = boundsExitArr[i];
            if (wexit.behav != w.behav || !wexit.region.equals(w.region)) continue;
            this.boundsExitList.remove(i);
            needTrigger = false;
            break;
        }
        ViewPlatformRetained triggeredVP = this.intersectVPCenter(w.transformedRegion);
        this.wakeupOnViewPlatformExit.add(w);
        if (triggeredVP != null) {
            w.triggeredVP = triggeredVP;
            this.boundsExitList.add(w);
        }
        if (!needTrigger) {
            return;
        }
        WakeupOnViewPlatformEntry[] boundsEntryArr = (WakeupOnViewPlatformEntry[])this.boundsEntryList.toArray(false);
        for (int i = this.boundsEntryList.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformEntry wentry = boundsEntryArr[i];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            if (triggeredVP != null) break;
            w.setTriggered();
            break;
        }
    }

    void removeSensorEntryCondition(WakeupOnSensorEntry w) {
        this.wakeupOnSensorEntry.remove(w);
    }

    void addSensorEntryCondition(WakeupOnSensorEntry w) {
        boolean needTrigger = true;
        WakeupOnSensorEntry[] sensorEntryArr = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i = this.currentSensorEntryList.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorEntry wentry = sensorEntryArr[i];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            this.currentSensorEntryList.remove(i);
            needTrigger = false;
            break;
        }
        this.wakeupOnSensorEntry.add(w);
        w.updateTransformRegion();
        Sensor target = this.sensorIntersect(w.transformedRegion);
        if (target != null) {
            w.setTarget(target);
            this.currentSensorEntryList.add(w);
        }
        if (needTrigger && target != null) {
            w.setTriggered();
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void removeSensorExitCondition(WakeupOnSensorExit w) {
        this.wakeupOnSensorExit.remove(w);
    }

    void addSensorExitCondition(WakeupOnSensorExit w) {
        boolean needTrigger = true;
        WakeupOnSensorExit[] currentSensorExitArr = (WakeupOnSensorExit[])this.currentSensorExitList.toArray(false);
        for (int i = this.currentSensorExitList.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorExit wexit = currentSensorExitArr[i];
            if (wexit.behav != w.behav || !wexit.region.equals(w.region)) continue;
            this.currentSensorExitList.remove(i);
            needTrigger = false;
            break;
        }
        w.updateTransformRegion();
        Sensor target = this.sensorIntersect(w.transformedRegion);
        this.wakeupOnSensorExit.add(w);
        if (target != null) {
            w.setTarget(target);
            this.currentSensorExitList.add(w);
        }
        if (!needTrigger) {
            return;
        }
        WakeupOnSensorEntry[] sensorEntryArr = (WakeupOnSensorEntry[])this.currentSensorEntryList.toArray(false);
        for (int i = this.currentSensorEntryList.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorEntry wentry = sensorEntryArr[i];
            if (wentry.behav != w.behav || !wentry.region.equals(w.region)) continue;
            if (target != null) break;
            w.setTriggered();
            break;
        }
        VirtualUniverse.mc.sendRunMessage(this.universe, 256);
    }

    void processConditionMet(BehaviorRetained behav, Boolean checkSchedulingRegion) {
        if (!behav.inCallback && (checkSchedulingRegion == Boolean.FALSE || behav.active)) {
            this.processList[behav.schedulingInterval].add(behav);
        } else if ((behav.wakeupMask & 0x10) != 0 && behav.source != null && behav.source.isLive() && behav.wakeupCondition != null) {
            behav.wakeupCondition.reInsertElapseTimeCond();
        }
    }

    final void processBehXformChanged(UnorderList arrList) {
        int size = arrList.size();
        Object[] nodesArr = arrList.toArray(false);
        for (int i = 0; i < size; ++i) {
            Object[] nodes = (Object[])nodesArr[i];
            for (int j = 0; j < nodes.length; ++j) {
                BehaviorRetained beh = (BehaviorRetained)nodes[j];
                beh.updateTransformRegion();
                this.processBehaviorTransform(beh);
            }
        }
    }

    final void processVpfXformChanged(UnorderList arrList) {
        int size = arrList.size();
        Object[] nodesArr = arrList.toArray(false);
        for (int i = 0; i < size; ++i) {
            Object[] nodes = (Object[])nodesArr[i];
            for (int j = 0; j < nodes.length; ++j) {
                this.processViewPlatformTransform((ViewPlatformRetained)nodes[j]);
            }
        }
    }

    final void processTransformChanged(Object[] leaf) {
        int i;
        for (i = 0; i < leaf.length; ++i) {
            Object node = leaf[i];
            if (node instanceof BehaviorRetained) {
                ((BehaviorRetained)node).updateTransformRegion();
                this.processBehaviorTransform((BehaviorRetained)node);
                continue;
            }
            if (!(node instanceof ViewPlatformRetained)) continue;
            ((ViewPlatformRetained)node).updateTransformRegion();
            this.transformViewPlatformList.add(node);
        }
        if (this.transformViewPlatformList.size() > 0) {
            ViewPlatformRetained[] vpArr = (ViewPlatformRetained[])this.transformViewPlatformList.toArray(false);
            int size = this.transformViewPlatformList.arraySize();
            for (i = 0; i < size; ++i) {
                this.processViewPlatformTransform(vpArr[i]);
            }
            this.transformViewPlatformList.clear();
        }
    }

    final void processBehaviorTransform(BehaviorRetained behav) {
        if ((behav.wakeupMask & 4) != 0) {
            this.updateVPEntryTransformRegion(behav);
        }
        if ((behav.wakeupMask & 8) != 0) {
            this.updateVPExitTransformRegion(behav);
        }
        if (behav.active) {
            if (!this.intersectVPRegion(behav.transformedRegion)) {
                this.removeFromScheduleList(behav);
            }
        } else {
            this.addToScheduleList(behav);
        }
    }

    void processViewPlatformTransform(ViewPlatformRetained vp) {
        ViewPlatformRetained triggeredVP;
        int idx;
        int i;
        vp.updateTransformRegion();
        if (!vp.isActiveViewPlatform()) {
            return;
        }
        BehaviorRetained[] behavArr = (BehaviorRetained[])this.behaviors.toArray(false);
        for (i = this.behaviors.arraySize() - 1; i >= 0; --i) {
            BehaviorRetained behav = behavArr[i];
            if (behav.active) {
                if (this.intersectVPRegion(behav.transformedRegion)) continue;
                this.removeFromScheduleList(behav);
                continue;
            }
            this.addToScheduleList(behav);
        }
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArr = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (i = this.wakeupOnViewPlatformEntry.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformEntry wentry = wakeupOnViewPlatformEntryArr[i];
            idx = this.boundsEntryList.indexOf(wentry);
            if (idx < 0) {
                if (!wentry.transformedRegion.intersect(vp.center)) continue;
                this.boundsEntryList.add(wentry);
                wentry.triggeredVP = vp;
                wentry.setTriggered();
                continue;
            }
            triggeredVP = this.intersectVPCenter(wentry.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsEntryList.remove(idx);
        }
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArr = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (i = this.wakeupOnViewPlatformExit.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformExit wexit = wakeupOnViewPlatformExitArr[i];
            idx = this.boundsExitList.indexOf(wexit);
            if (idx < 0) {
                if (!wexit.transformedRegion.intersect(vp.center)) continue;
                wexit.triggeredVP = vp;
                this.boundsExitList.add(wexit);
                continue;
            }
            triggeredVP = this.intersectVPCenter(wexit.transformedRegion);
            if (triggeredVP != null) continue;
            this.boundsExitList.remove(idx);
            wexit.setTriggered();
        }
    }

    void updateVPEntryTransformRegion(BehaviorRetained behav) {
        WakeupOnViewPlatformEntry[] wakeupOnViewPlatformEntryArr = (WakeupOnViewPlatformEntry[])this.wakeupOnViewPlatformEntry.toArray(false);
        for (int i = this.wakeupOnViewPlatformEntry.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformEntry wentry = wakeupOnViewPlatformEntryArr[i];
            if (wentry.behav != behav) continue;
            wentry.updateTransformRegion(behav);
            int idx = this.boundsEntryList.indexOf(wentry);
            ViewPlatformRetained triggeredVP = this.intersectVPCenter(wentry.transformedRegion);
            if (triggeredVP != null) {
                if (idx >= 0) continue;
                this.boundsEntryList.add(wentry);
                wentry.triggeredVP = triggeredVP;
                wentry.setTriggered();
                continue;
            }
            if (idx < 0) continue;
            this.boundsEntryList.remove(idx);
        }
    }

    void updateVPExitTransformRegion(BehaviorRetained behav) {
        WakeupOnViewPlatformExit[] wakeupOnViewPlatformExitArr = (WakeupOnViewPlatformExit[])this.wakeupOnViewPlatformExit.toArray(false);
        for (int i = this.wakeupOnViewPlatformExit.arraySize() - 1; i >= 0; --i) {
            WakeupOnViewPlatformExit wexit = wakeupOnViewPlatformExitArr[i];
            if (wexit.behav != behav) continue;
            wexit.updateTransformRegion(behav);
            wexit = wakeupOnViewPlatformExitArr[i];
            int idx = this.boundsExitList.indexOf(wexit);
            ViewPlatformRetained triggeredVP = this.intersectVPCenter(wexit.transformedRegion);
            if (triggeredVP != null) {
                if (idx >= 0) continue;
                wexit.triggeredVP = triggeredVP;
                this.boundsExitList.add(wexit);
                continue;
            }
            if (idx < 0) continue;
            this.boundsExitList.remove(idx);
            wexit.setTriggered();
        }
    }

    void reEvaluatePhysicalEnvironments() {
        ViewPlatformRetained[] vpr = this.universe.getViewPlatformList();
        this.physicalEnvironments.clear();
        for (int i = vpr.length - 1; i >= 0; --i) {
            View[] views = vpr[i].getViewList();
            for (int j = views.length - 1; j >= 0; --j) {
                View v = views[j];
                if (!v.active || this.physicalEnvironments.contains(v.physicalEnvironment)) continue;
                this.physicalEnvironments.add(v.physicalEnvironment);
            }
        }
    }

    void checkSensorEntryExit() {
        Sensor target;
        int idx;
        int i;
        WakeupOnSensorEntry[] wentryArr = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        for (i = this.wakeupOnSensorEntry.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorEntry wentry = wentryArr[i];
            idx = this.currentSensorEntryList.indexOf(wentry);
            wentry.updateTransformRegion();
            target = this.sensorIntersect(wentry.transformedRegion);
            if (target != null) {
                if (idx >= 0) continue;
                this.currentSensorEntryList.add(wentry);
                wentry.setTarget(target);
                wentry.setTriggered();
                continue;
            }
            if (idx < 0) continue;
            this.currentSensorEntryList.remove(idx);
        }
        WakeupOnSensorExit[] wexitArr = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        for (i = this.wakeupOnSensorExit.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorExit wexit = wexitArr[i];
            idx = this.currentSensorExitList.indexOf(wexit);
            wexit.updateTransformRegion();
            target = this.sensorIntersect(wexit.transformedRegion);
            if (target != null) {
                if (idx >= 0) continue;
                this.currentSensorExitList.add(wexit);
                wexit.setTarget(target);
                continue;
            }
            if (idx < 0) continue;
            this.currentSensorExitList.remove(idx);
            wexit.setTriggered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Sensor sensorIntersect(Bounds behregion) {
        if (behregion == null) {
            return null;
        }
        PhysicalEnvironment[] env = (PhysicalEnvironment[])this.physicalEnvironments.toArray(false);
        int i = this.physicalEnvironments.arraySize() - 1;
        while (i >= 0) {
            Sensor[] sensors;
            if (env[i].activeViewRef > 0 && (sensors = env[i].getSensorList()) != null) {
                for (int j = env[i].users.size() - 1; j >= 0; --j) {
                    View v = env[i].users.get(j);
                    Sensor[] sensorArray = sensors;
                    // MONITORENTER : sensors
                    for (int k = sensors.length - 1; k >= 0; --k) {
                        Sensor s = sensors[k];
                        if (s == null) continue;
                        v.getSensorToVworld(s, this.sensorTransform);
                        this.sensorTransform.get(this.sensorLoc);
                        this.ptSensorLoc.set((Tuple3d)this.sensorLoc);
                        if (!behregion.intersect(this.ptSensorLoc)) continue;
                        // MONITOREXIT : sensorArray
                        return s;
                    }
                    // MONITOREXIT : sensorArray
                }
            }
            --i;
        }
        return null;
    }

    final boolean intersectVPRegion(Bounds behregion) {
        if (behregion == null) {
            return false;
        }
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i = this.viewPlatforms.arraySize() - 1; i >= 0; --i) {
            ViewPlatformRetained vp = vpLists[i];
            if (!vp.isActiveViewPlatform() || !vp.schedSphere.intersect(behregion)) continue;
            return true;
        }
        return false;
    }

    final ViewPlatformRetained intersectVPCenter(Bounds behregion) {
        if (behregion == null) {
            return null;
        }
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i = this.viewPlatforms.arraySize() - 1; i >= 0; --i) {
            ViewPlatformRetained vp = vpLists[i];
            if (!vp.isActiveViewPlatform() || !behregion.intersect(vp.center)) continue;
            return vp;
        }
        return null;
    }

    void notifyDeactivationCondition(BehaviorRetained behav) {
        WakeupOnDeactivation[] wakeupConds = (WakeupOnDeactivation[])this.wakeupOnDeactivation.toArray(false);
        for (int i = this.wakeupOnDeactivation.arraySize() - 1; i >= 0; --i) {
            WakeupOnDeactivation wakeup = wakeupConds[i];
            if (wakeup.behav != behav) continue;
            wakeup.setTriggered();
        }
    }

    void notifyActivationCondition(BehaviorRetained behav) {
        WakeupOnActivation[] wakeupConds = (WakeupOnActivation[])this.wakeupOnActivation.toArray(false);
        for (int i = this.wakeupOnActivation.arraySize() - 1; i >= 0; --i) {
            WakeupOnActivation wakeup = wakeupConds[i];
            if (wakeup.behav != behav) continue;
            wakeup.setTriggered();
        }
    }

    void processSwitchChanged(J3dMessage m) {
        int i;
        Object[] nodes;
        int j;
        Object[] nodesArr;
        int size;
        UpdateTargets targets = (UpdateTargets)m.args[0];
        UnorderList arrList = targets.targetList[4];
        if (arrList != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j = 0; j < size; ++j) {
                nodes = (Object[])nodesArr[j];
                for (i = nodes.length - 1; i >= 0; --i) {
                    ViewPlatformRetained vp = (ViewPlatformRetained)nodes[i];
                    vp.processSwitchChanged();
                }
            }
        }
        if ((arrList = targets.targetList[2]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (j = 0; j < size; ++j) {
                nodes = (Object[])nodesArr[j];
                for (i = nodes.length - 1; i >= 0; --i) {
                    BehaviorRetained behav = (BehaviorRetained)nodes[i];
                    if (behav.switchState.currentSwitchOn) {
                        this.addToScheduleList(behav);
                        continue;
                    }
                    this.removeFromScheduleList(behav);
                }
            }
        }
        if ((arrList = targets.targetList[5]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            Object[] objArr = (Object[])m.args[1];
            for (int h = 0; h < size; ++h) {
                nodes = (Object[])nodesArr[h];
                Object[] obj = (Object[])objArr[h];
                for (i = nodes.length - 1; i >= 0; --i) {
                    Object[] users = (Object[])obj[i];
                    Object[] leafObj = new Object[1];
                    for (j = 0; j < users.length; ++j) {
                        if (!(users[j] instanceof BehaviorRetained)) continue;
                        leafObj[0] = users[j];
                        this.processTransformChanged(leafObj);
                    }
                }
            }
        }
    }

    void processBoundingLeafChanged(Object[] users, Bounds bound) {
        for (int i = users.length - 1; i >= 0; --i) {
            Object leaf = users[i];
            if (!(leaf instanceof BehaviorRetained)) continue;
            BehaviorRetained behav = (BehaviorRetained)leaf;
            behav.updateTransformRegion(bound);
            this.processBehaviorTransform(behav);
        }
    }

    final void removeFromScheduleList(BehaviorRetained behav) {
        if (behav.active) {
            if ((behav.wakeupMask & 2) != 0) {
                this.notifyDeactivationCondition(behav);
            }
            this.scheduleList.remove(behav);
            behav.active = false;
            if (behav.universe != this.universe) {
                J3dMessage m = new J3dMessage();
                m.threads = 256;
                m.type = 60;
                m.universe = behav.universe;
                m.args[0] = behav;
                VirtualUniverse.mc.processMessage(m);
            }
        }
    }

    final void addToScheduleList(BehaviorRetained behav) {
        if (!behav.inCallback && !behav.active && behav.enable && behav.switchState.currentSwitchOn && behav.wakeupCondition != null && ((Behavior)behav.source).isLive() && this.intersectVPRegion(behav.transformedRegion)) {
            this.scheduleList.add(behav);
            behav.active = true;
            if ((behav.wakeupMask & 1) != 0) {
                this.notifyActivationCondition(behav);
            }
            if (behav.wakeupCondition != null) {
                behav.wakeupCondition.conditionMet = false;
            }
        }
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnAWTEvent);
        BehaviorStructure.resetConditionMet(this.wakeupOnActivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnDeactivation);
        BehaviorStructure.resetConditionMet(this.wakeupOnBehaviorPost);
        BehaviorStructure.resetConditionMet(this.wakeupOnElapsedFrames);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnViewPlatformExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnSensorExit);
    }

    static void resetConditionMet(WakeupIndexedList list) {
        WakeupCondition[] wakeups = (WakeupCondition[])list.toArray(false);
        int i = list.size() - 1;
        while (i >= 0) {
            wakeups[i--].conditionMet = false;
        }
    }

    void reEvaluateWakeupCount() {
        WakeupOnElapsedFrames[] wakeupConds = (WakeupOnElapsedFrames[])this.wakeupOnElapsedFrames.toArray(true);
        int size = this.wakeupOnElapsedFrames.arraySize();
        int i = 0;
        this.activeWakeupOnFrameCount = 0;
        while (i < size) {
            WakeupOnElapsedFrames cond = wakeupConds[i++];
            if (cond.passive || cond.behav == null || !cond.behav.enable) continue;
            ++this.activeWakeupOnFrameCount;
        }
        this.activeWakeupOnSensorCount = 0;
        WakeupOnSensorEntry[] wentryArr = (WakeupOnSensorEntry[])this.wakeupOnSensorEntry.toArray();
        for (i = this.wakeupOnSensorEntry.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorEntry wentry = wentryArr[i];
            if (wentry.behav == null || !wentry.behav.enable) continue;
            ++this.activeWakeupOnSensorCount;
        }
        WakeupOnSensorExit[] wexitArr = (WakeupOnSensorExit[])this.wakeupOnSensorExit.toArray();
        for (i = this.wakeupOnSensorExit.arraySize() - 1; i >= 0; --i) {
            WakeupOnSensorExit wexit = wexitArr[i];
            if (wexit.behav == null || !wexit.behav.enable) continue;
            ++this.activeWakeupOnSensorCount;
        }
    }

    @Override
    void cleanup() {
        this.behaviors.clear();
        this.viewPlatforms.clear();
        this.scheduleList.clear();
        this.boundsEntryList.clear();
        this.boundsExitList.clear();
        this.currentSensorEntryList.clear();
        this.currentSensorExitList.clear();
        this.wakeupOnAWTEvent.clear();
        this.wakeupOnActivation.clear();
        this.wakeupOnDeactivation.clear();
        this.wakeupOnBehaviorPost.clear();
        this.wakeupOnElapsedFrames.clear();
        this.wakeupOnViewPlatformEntry.clear();
        this.wakeupOnViewPlatformExit.clear();
        this.wakeupOnSensorEntry.clear();
        this.wakeupOnSensorExit.clear();
    }
}

