/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class Bounds
implements Cloneable {
    static final double EPSILON = 1.0E-6;
    static final boolean debug = false;
    static final int BOUNDING_BOX = 1;
    static final int BOUNDING_SPHERE = 2;
    static final int BOUNDING_POLYTOPE = 4;
    boolean boundsIsEmpty = false;
    boolean boundsIsInfinite = false;
    int boundId = 0;

    public abstract Object clone();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean intersect(Point3d var1, Vector3d var2);

    public abstract boolean intersect(Point3d var1);

    abstract boolean intersect(Point3d var1, Vector3d var2, Point4d var3);

    abstract boolean intersect(Point3d var1, Point4d var2);

    abstract boolean intersect(Point3d var1, Point3d var2, Point4d var3);

    abstract boolean intersect(Bounds var1, Point4d var2);

    public abstract boolean intersect(Bounds var1);

    public abstract boolean intersect(Bounds[] var1);

    public abstract Bounds closestIntersection(Bounds[] var1);

    abstract Point3d getCenter();

    public abstract void getCenter(Point3d var1);

    public abstract void combine(Bounds var1);

    public abstract void combine(Bounds[] var1);

    public abstract void combine(Point3d var1);

    public abstract void combine(Point3d[] var1);

    public abstract void transform(Transform3D var1);

    public abstract void transform(Bounds var1, Transform3D var2);

    public abstract boolean isEmpty();

    public abstract void set(Bounds var1);

    abstract Bounds copy(Bounds var1);

    private void test_point(Vector4d[] planes, Point3d new_point) {
        for (int i = 0; i < planes.length; ++i) {
            double dist = new_point.x * planes[i].x + new_point.y * planes[i].y + new_point.z * planes[i].z + planes[i].w;
            if (!(dist > 1.0E-6)) continue;
            System.err.println("new point is outside of plane[" + i + "] dist = " + dist);
        }
    }

    boolean closest_point(Point3d g, Vector4d[] planes, Point3d new_point) {
        Point3d n = new Point3d();
        Point3d p = new Point3d();
        Object delta = null;
        double w = 1.0E8;
        int count = 0;
        p.set((Tuple3d)g);
        boolean converged = false;
        boolean firstPoint = true;
        boolean firstInside = false;
        while (!converged) {
            double y3;
            double dist;
            boolean inside = true;
            double aa = 0.0;
            double bb = 0.0;
            double cc = 0.0;
            double ab = 0.0;
            double ac = 0.0;
            double bc = 0.0;
            double ad = 0.0;
            double bd = 0.0;
            double cd = 0.0;
            for (int i = 0; i < planes.length; ++i) {
                Vector4d pln = planes[i];
                dist = p.x * pln.x + p.y * pln.y + p.z * pln.z + pln.w;
                if (dist > -1.0E-6) {
                    aa += pln.x * pln.x;
                    bb += pln.y * pln.y;
                    cc += pln.z * pln.z;
                    ab += pln.x * pln.y;
                    ac += pln.x * pln.z;
                    bc += pln.y * pln.z;
                    ad += pln.x * pln.w;
                    bd += pln.y * pln.w;
                    cd += pln.z * pln.w;
                }
                if (!(dist > 1.0E-6)) continue;
                inside = false;
            }
            if (inside) {
                if (firstPoint) {
                    firstInside = true;
                }
                new_point.set((Tuple3d)p);
                converged = true;
                continue;
            }
            firstPoint = false;
            double h11 = 1.0 + aa * w;
            double h12 = ab * w;
            double h13 = ac * w;
            double h22 = 1.0 + bb * w;
            double h23 = bc * w;
            double h33 = 1.0 + cc * w;
            double b1 = g.x - w * ad;
            double b2 = g.y - w * bd;
            double b3 = g.z - w * cd;
            double d1 = 1.0 / h11;
            double l12 = d1 * h12;
            double l13 = d1 * h13;
            double s = h22 - l12 * h12;
            double d2 = 1.0 / s;
            double t = h23 - h12 * l13;
            double l23 = d2 * t;
            double d3 = 1.0 / (h33 - h13 * l13 - t * l23);
            double y1 = d1 * b1;
            double y2 = d2 * (b2 - h12 * y1);
            n.z = y3 = d3 * (b3 - h13 * y1 - t * y2);
            n.y = y2 - l23 * n.z;
            n.x = y1 - l13 * n.z - l12 * n.y;
            dist = (p.x - n.x) * (p.x - n.x) + (p.y - n.y) * (p.y - n.y) + (p.z - n.z) * (p.z - n.z);
            if (dist < 1.0E-6) {
                converged = true;
                new_point.set((Tuple3d)n);
                continue;
            }
            p.set((Tuple3d)n);
            if (++count <= 4) continue;
            new_point.set((Tuple3d)n);
            converged = true;
        }
        return firstInside;
    }

    boolean intersect_ptope_sphere(BoundingPolytope polyTope, BoundingSphere sphere) {
        Point3d p = new Point3d();
        boolean inside = this.closest_point(sphere.center, polyTope.planes, p);
        if (!inside) {
            return !(p.distanceSquared(sphere.center) > sphere.radius * sphere.radius);
        }
        return true;
    }

    boolean intersect_ptope_abox(BoundingPolytope polyTope, BoundingBox box) {
        Vector4d[] planes = new Vector4d[]{new Vector4d(-1.0, 0.0, 0.0, box.lower.x), new Vector4d(1.0, 0.0, 0.0, -box.upper.x), new Vector4d(0.0, -1.0, 0.0, box.lower.y), new Vector4d(0.0, 1.0, 0.0, -box.upper.y), new Vector4d(0.0, 0.0, -1.0, box.lower.z), new Vector4d(0.0, 0.0, 1.0, -box.upper.z)};
        BoundingPolytope pbox = new BoundingPolytope(planes);
        boolean result = this.intersect_ptope_ptope(polyTope, pbox);
        return result;
    }

    boolean intersect_ptope_ptope(BoundingPolytope poly1, BoundingPolytope poly2) {
        Point3d p = new Point3d();
        Point3d g = new Point3d();
        Point3d gnew = new Point3d();
        Point3d pnew = new Point3d();
        boolean intersect = false;
        p.x = 0.0;
        p.y = 0.0;
        p.z = 0.0;
        this.closest_point(p, poly1.planes, g);
        intersect = this.closest_point(g, poly2.planes, p);
        if (intersect) {
            return true;
        }
        intersect = this.closest_point(p, poly1.planes, gnew);
        double prevDist = p.distanceSquared(g);
        while (!intersect) {
            double dist = p.distanceSquared(gnew);
            if (!(dist < prevDist)) {
                g.set((Tuple3d)gnew);
                break;
            }
            g.set((Tuple3d)gnew);
            intersect = this.closest_point(g, poly2.planes, pnew);
            prevDist = dist;
            dist = pnew.distanceSquared(g);
            if (dist < prevDist) {
                p.set((Tuple3d)pnew);
                if (!intersect) {
                    intersect = this.closest_point(p, poly1.planes, gnew);
                }
            } else {
                p.set((Tuple3d)pnew);
                break;
            }
            prevDist = dist;
        }
        return intersect;
    }

    synchronized void setWithLock(Bounds b) {
        this.set(b);
    }

    synchronized void getWithLock(Bounds b) {
        b.set(this);
    }

    abstract int getPickType();
}

