/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;

public class Clip
extends Leaf {
    public static final int ALLOW_APPLICATION_BOUNDS_READ = 12;
    public static final int ALLOW_APPLICATION_BOUNDS_WRITE = 13;
    public static final int ALLOW_BACK_DISTANCE_READ = 14;
    public static final int ALLOW_BACK_DISTANCE_WRITE = 15;
    private static final int[] readCapabilities = new int[]{12, 14};

    public Clip() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Clip(double backDistance) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ClipRetained)this.retained).initBackDistance(backDistance);
    }

    public void setBackDistance(double backDistance) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip0"));
        }
        if (this.isLive()) {
            ((ClipRetained)this.retained).setBackDistance(backDistance);
        } else {
            ((ClipRetained)this.retained).initBackDistance(backDistance);
        }
    }

    public double getBackDistance() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip1"));
        }
        return ((ClipRetained)this.retained).getBackDistance();
    }

    public void setApplicationBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip2"));
        }
        if (this.isLive()) {
            ((ClipRetained)this.retained).setApplicationBounds(region);
        } else {
            ((ClipRetained)this.retained).initApplicationBounds(region);
        }
    }

    public Bounds getApplicationBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip3"));
        }
        return ((ClipRetained)this.retained).getApplicationBounds();
    }

    public void setApplicationBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip2"));
        }
        if (this.isLive()) {
            ((ClipRetained)this.retained).setApplicationBoundingLeaf(region);
        } else {
            ((ClipRetained)this.retained).initApplicationBoundingLeaf(region);
        }
    }

    public BoundingLeaf getApplicationBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Clip3"));
        }
        return ((ClipRetained)this.retained).getApplicationBoundingLeaf();
    }

    @Override
    void createRetained() {
        this.retained = new ClipRetained();
        this.retained.setSource(this);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Clip c = new Clip();
        c.duplicateNode(this, forceDuplicate);
        return c;
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        ClipRetained rt = (ClipRetained)this.retained;
        BoundingLeaf bl = rt.getApplicationBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.initApplicationBoundingLeaf((BoundingLeaf)o);
        }
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ClipRetained attr = (ClipRetained)originalNode.retained;
        ClipRetained rt = (ClipRetained)this.retained;
        rt.initBackDistance(attr.getBackDistance());
        rt.initApplicationBounds(attr.getApplicationBounds());
        rt.initApplicationBoundingLeaf(attr.getApplicationBoundingLeaf());
    }
}

