/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.media.j3d.J3dI18N;

public class NioImageBuffer {
    int width;
    int height;
    ImageType imageType;
    Buffer buffer;
    BufferType bufferType;
    int bytesPerPixel;
    int elementsPerPixel;

    public NioImageBuffer(int width, int height, ImageType imageType) {
        this.processParams(width, height, imageType);
        ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(width * height * this.bytesPerPixel);
        switch (this.bufferType) {
            case BYTE_BUFFER: {
                this.buffer = tmpBuffer;
                break;
            }
            case INT_BUFFER: {
                this.buffer = tmpBuffer.order(ByteOrder.nativeOrder()).asIntBuffer();
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
    }

    public NioImageBuffer(int width, int height, ImageType imageType, Buffer dataBuffer) {
        this.processParams(width, height, imageType);
        this.setDataBuffer(dataBuffer);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setDataBuffer(Buffer dataBuffer) {
        if (dataBuffer == null) {
            throw new NullPointerException();
        }
        if (dataBuffer.limit() != this.width * this.height * this.elementsPerPixel) {
            throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer3"));
        }
        switch (this.bufferType) {
            case BYTE_BUFFER: {
                if (!(dataBuffer instanceof ByteBuffer)) {
                    throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer4"));
                }
                this.buffer = ((ByteBuffer)dataBuffer).duplicate().rewind();
                break;
            }
            case INT_BUFFER: {
                if (!(dataBuffer instanceof IntBuffer)) {
                    throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer4"));
                }
                if (((IntBuffer)dataBuffer).order() != ByteOrder.nativeOrder()) {
                    throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer5"));
                }
                this.buffer = ((IntBuffer)dataBuffer).duplicate().rewind();
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
    }

    public Buffer getDataBuffer() {
        Buffer tmpBuffer = null;
        switch (this.bufferType) {
            case BYTE_BUFFER: {
                tmpBuffer = ((ByteBuffer)this.buffer).duplicate();
                break;
            }
            case INT_BUFFER: {
                tmpBuffer = ((IntBuffer)this.buffer).duplicate();
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
        return tmpBuffer.rewind();
    }

    private void processParams(int width, int height, ImageType imageType) {
        if (width < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer0"));
        }
        if (height < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer1"));
        }
        switch (imageType) {
            case TYPE_3BYTE_BGR: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 3;
                this.elementsPerPixel = 3;
                break;
            }
            case TYPE_3BYTE_RGB: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 3;
                this.elementsPerPixel = 3;
                break;
            }
            case TYPE_4BYTE_ABGR: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 4;
                this.elementsPerPixel = 4;
                break;
            }
            case TYPE_4BYTE_RGBA: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 4;
                this.elementsPerPixel = 4;
                break;
            }
            case TYPE_BYTE_GRAY: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 1;
                this.elementsPerPixel = 1;
                break;
            }
            case TYPE_INT_ARGB: 
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: {
                this.bufferType = BufferType.INT_BUFFER;
                this.bytesPerPixel = 4;
                this.elementsPerPixel = 1;
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
        this.width = width;
        this.height = height;
        this.imageType = imageType;
    }

    static enum BufferType {
        BYTE_BUFFER,
        INT_BUFFER;

    }

    public static enum ImageType {
        TYPE_3BYTE_BGR,
        TYPE_3BYTE_RGB,
        TYPE_4BYTE_ABGR,
        TYPE_4BYTE_RGBA,
        TYPE_BYTE_GRAY,
        TYPE_INT_ARGB,
        TYPE_INT_BGR,
        TYPE_INT_RGB;

    }
}

