/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class OrientedShape3D
extends Shape3D {
    public static final int ROTATE_ABOUT_AXIS = 0;
    public static final int ROTATE_ABOUT_POINT = 1;
    public static final int ROTATE_NONE = 2;
    public static final int ALLOW_MODE_READ = 20;
    public static final int ALLOW_MODE_WRITE = 21;
    public static final int ALLOW_AXIS_READ = 22;
    public static final int ALLOW_AXIS_WRITE = 23;
    public static final int ALLOW_POINT_READ = 24;
    public static final int ALLOW_POINT_WRITE = 25;
    public static final int ALLOW_SCALE_READ = 26;
    public static final int ALLOW_SCALE_WRITE = 27;
    private static final int[] readCapabilities = new int[]{20, 22, 24, 26};

    public OrientedShape3D() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int mode, Vector3f axis) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(mode);
        ((OrientedShape3DRetained)this.retained).initAlignmentAxis(axis);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int mode, Point3f point) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(mode);
        ((OrientedShape3DRetained)this.retained).initRotationPoint(point);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int mode, Vector3f axis, boolean constantScaleEnable, double scale) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(mode);
        ((OrientedShape3DRetained)this.retained).initAlignmentAxis(axis);
        ((OrientedShape3DRetained)this.retained).initConstantScaleEnable(constantScaleEnable);
        ((OrientedShape3DRetained)this.retained).initScale(scale);
    }

    public OrientedShape3D(Geometry geometry, Appearance appearance, int mode, Point3f point, boolean constantScaleEnable, double scale) {
        super(geometry, appearance);
        this.setDefaultReadCapabilities(readCapabilities);
        ((OrientedShape3DRetained)this.retained).initAlignmentMode(mode);
        ((OrientedShape3DRetained)this.retained).initRotationPoint(point);
        ((OrientedShape3DRetained)this.retained).initConstantScaleEnable(constantScaleEnable);
        ((OrientedShape3DRetained)this.retained).initScale(scale);
    }

    @Override
    void createRetained() {
        this.retained = new OrientedShape3DRetained();
        this.retained.setSource(this);
    }

    public void setAlignmentMode(int mode) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D0"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setAlignmentMode(mode);
        } else {
            ((OrientedShape3DRetained)this.retained).initAlignmentMode(mode);
        }
    }

    public int getAlignmentMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D1"));
        }
        return ((OrientedShape3DRetained)this.retained).getAlignmentMode();
    }

    public void setAlignmentAxis(Vector3f axis) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D2"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setAlignmentAxis(axis);
        } else {
            ((OrientedShape3DRetained)this.retained).initAlignmentAxis(axis);
        }
    }

    public void setAlignmentAxis(float x, float y, float z) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D2"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setAlignmentAxis(x, y, z);
        } else {
            ((OrientedShape3DRetained)this.retained).initAlignmentAxis(x, y, z);
        }
    }

    public void getAlignmentAxis(Vector3f axis) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D3"));
        }
        ((OrientedShape3DRetained)this.retained).getAlignmentAxis(axis);
    }

    public void setRotationPoint(Point3f point) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D4"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setRotationPoint(point);
        } else {
            ((OrientedShape3DRetained)this.retained).initRotationPoint(point);
        }
    }

    public void setRotationPoint(float x, float y, float z) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D4"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setRotationPoint(x, y, z);
        } else {
            ((OrientedShape3DRetained)this.retained).initRotationPoint(x, y, z);
        }
    }

    public void getRotationPoint(Point3f point) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D5"));
        }
        ((OrientedShape3DRetained)this.retained).getRotationPoint(point);
    }

    public void setConstantScaleEnable(boolean constantScaleEnable) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D6"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setConstantScaleEnable(constantScaleEnable);
        } else {
            ((OrientedShape3DRetained)this.retained).initConstantScaleEnable(constantScaleEnable);
        }
    }

    public boolean getConstantScaleEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D7"));
        }
        return ((OrientedShape3DRetained)this.retained).getConstantScaleEnable();
    }

    public void setScale(double scale) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D8"));
        }
        if (this.isLive()) {
            ((OrientedShape3DRetained)this.retained).setScale(scale);
        } else {
            ((OrientedShape3DRetained)this.retained).initScale(scale);
        }
    }

    public double getScale() {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrientedShape3D9"));
        }
        return ((OrientedShape3DRetained)this.retained).getScale();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        OrientedShape3D s = new OrientedShape3D();
        s.duplicateNode(this, forceDuplicate);
        return s;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.checkDuplicateNode(originalNode, forceDuplicate);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        OrientedShape3DRetained attr = (OrientedShape3DRetained)originalNode.retained;
        OrientedShape3DRetained rt = (OrientedShape3DRetained)this.retained;
        rt.setAlignmentMode(attr.getAlignmentMode());
        Vector3f axis = new Vector3f();
        attr.getAlignmentAxis(axis);
        rt.setAlignmentAxis(axis);
        Point3f point = new Point3f();
        attr.getRotationPoint(point);
        rt.setRotationPoint(point);
    }
}

