/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsDevice;
import java.io.PrintStream;
import javax.media.j3d.Canvas3D;

public class RenderingError {
    private int errorCode = 0;
    private String errorMessage = null;
    private String detailMessage = null;
    private GraphicsDevice graphicsDevice = null;
    private Canvas3D canvas = null;
    public static final int NO_ERROR = 0;
    public static final int UNEXPECTED_RENDERING_ERROR = 1;
    public static final int GRAPHICS_CONFIG_ERROR = 2;
    public static final int CONTEXT_CREATION_ERROR = 3;
    public static final int OFF_SCREEN_BUFFER_ERROR = 4;

    public RenderingError() {
    }

    public RenderingError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public void printVerbose() {
        this.printVerbose(System.err);
    }

    public void printVerbose(PrintStream printStream) {
        printStream.println(this);
        if (this.graphicsDevice != null) {
            printStream.println("graphicsDevice = " + this.graphicsDevice);
        }
        if (this.canvas != null) {
            printStream.println("canvas = " + this.canvas);
        }
        if (this.detailMessage != null) {
            printStream.println();
            printStream.println("Detail Message");
            printStream.println("--------------");
            printStream.println(this.detailMessage);
        }
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setDetailMessage(String detailMessage) {
        this.detailMessage = detailMessage;
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }

    public void setGraphicsDevice(GraphicsDevice graphicsDevice) {
        this.graphicsDevice = graphicsDevice;
    }

    public GraphicsDevice getGraphicsDevice() {
        return this.graphicsDevice;
    }

    public void setCanvas3D(Canvas3D canvas) {
        this.canvas = canvas;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas;
    }

    public String toString() {
        String errorCodeStr;
        switch (this.errorCode) {
            case 0: {
                errorCodeStr = "NO_ERROR";
                break;
            }
            case 1: {
                errorCodeStr = "UNEXPECTED_RENDERING_ERROR";
                break;
            }
            case 2: {
                errorCodeStr = "GRAPHICS_CONFIG_ERROR";
                break;
            }
            case 3: {
                errorCodeStr = "CONTEXT_CREATION_ERROR";
                break;
            }
            case 4: {
                errorCodeStr = "OFF_SCREEN_BUFFER_ERROR";
                break;
            }
            default: {
                errorCodeStr = "UNKNOWN ERROR CODE (" + this.errorCode + ")";
            }
        }
        if (this.errorMessage == null) {
            return errorCodeStr;
        }
        return errorCodeStr + ": " + this.errorMessage;
    }
}

