/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.ShaderAttributeRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple2i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Tuple4f;
import javax.vecmath.Tuple4i;

abstract class ShaderAttributeObjectRetained
extends ShaderAttributeRetained {
    private int classType;
    private Class baseClass;
    AttrWrapper attrWrapper;
    static final int TYPE_INTEGER = 0;
    static final int TYPE_FLOAT = 1;
    static final int TYPE_TUPLE2I = 2;
    static final int TYPE_TUPLE2F = 3;
    static final int TYPE_TUPLE3I = 4;
    static final int TYPE_TUPLE3F = 5;
    static final int TYPE_TUPLE4I = 6;
    static final int TYPE_TUPLE4F = 7;
    static final int TYPE_MATRIX3F = 8;
    static final int TYPE_MATRIX4F = 9;
    static final Class[] classTable = new Class[]{Integer.class, Float.class, Tuple2i.class, Tuple2f.class, Tuple3i.class, Tuple3f.class, Tuple4i.class, Tuple4f.class, Matrix3f.class, Matrix4f.class};
    static final Class[] classTableArr = new Class[]{Integer[].class, Float[].class, Tuple2i[].class, Tuple2f[].class, Tuple3i[].class, Tuple3f[].class, Tuple4i[].class, Tuple4f[].class, Matrix3f[].class, Matrix4f[].class};

    ShaderAttributeObjectRetained() {
    }

    void createObjectData(Object value) {
        this.classType = this.computeClassType(value);
        this.baseClass = this.getBaseClass(this.classType);
        this.attrWrapper = this.createAttrWrapper(value, this.classType);
    }

    void initValue(Object value) {
        this.attrWrapper.set(value);
    }

    Object getValue() {
        return this.attrWrapper.get();
    }

    void setValue(Object value) {
        this.initValue(value);
        AttrWrapper valueWrapper = this.createAttrWrapper(value, this.classType);
        this.sendMessage(8, valueWrapper);
    }

    Class getValueClass() {
        return this.baseClass;
    }

    @Override
    synchronized void initMirrorObject() {
        super.initMirrorObject();
        ((ShaderAttributeObjectRetained)this.mirror).initValue(this.getValue());
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        ShaderAttributeObjectRetained mirrorSAV = (ShaderAttributeObjectRetained)this.mirror;
        if ((component & 8) != 0) {
            mirrorSAV.attrWrapper = (AttrWrapper)value;
        }
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 63;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 63;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    abstract int computeClassType(Object var1);

    abstract Class getBaseClass(int var1);

    abstract AttrWrapper createAttrWrapper(Object var1, int var2);

    int getClassType() {
        return this.classType;
    }

    void setClassType(int classType) {
        this.classType = classType;
    }

    @Override
    void setFrequencyChangeMask(int bit, int mask) {
        if (this.source.getCapability(bit)) {
            this.changedFrequent |= mask;
        } else if (!this.source.isLive()) {
            this.changedFrequent &= ~mask;
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }

    static abstract class AttrWrapper {
        AttrWrapper() {
        }

        abstract void set(Object var1);

        abstract Object get();

        abstract Object getRef();
    }
}

