/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeSetRetained;

public class ShaderAttributeSet
extends NodeComponent {
    public static final int ALLOW_ATTRIBUTES_READ = 0;
    public static final int ALLOW_ATTRIBUTES_WRITE = 1;
    private static final int[] readCapabilities = new int[]{0};

    public ShaderAttributeSet() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public void put(ShaderAttribute attr) {
        if (attr == null) {
            throw new NullPointerException();
        }
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeSet1"));
        }
        ((ShaderAttributeSetRetained)this.retained).put(attr);
    }

    public ShaderAttribute get(String attrName) {
        if (attrName == null) {
            throw new NullPointerException();
        }
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeSet0"));
        }
        return ((ShaderAttributeSetRetained)this.retained).get(attrName);
    }

    public void remove(String attrName) {
        if (attrName == null) {
            throw new NullPointerException();
        }
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeSet1"));
        }
        ((ShaderAttributeSetRetained)this.retained).remove(attrName);
    }

    public void remove(ShaderAttribute attr) {
        if (attr == null) {
            throw new NullPointerException();
        }
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeSet1"));
        }
        ((ShaderAttributeSetRetained)this.retained).remove(attr);
    }

    public void clear() {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeSet1"));
        }
        ((ShaderAttributeSetRetained)this.retained).clear();
    }

    public ShaderAttribute[] getAll() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeSet0"));
        }
        return ((ShaderAttributeSetRetained)this.retained).getAll();
    }

    public int size() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ShaderAttributeSet0"));
        }
        return ((ShaderAttributeSetRetained)this.retained).size();
    }

    @Override
    void createRetained() {
        this.retained = new ShaderAttributeSetRetained();
        this.retained.setSource(this);
    }
}

