/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Link;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class SharedGroupRetained
extends GroupRetained
implements TargetsInterface {
    ArrayList<NodeRetained> childTransformLinks = new ArrayList(1);
    HashKey currentKey = new HashKey();
    HashKey switchKey = new HashKey();
    Vector<NodeRetained> parents = new Vector(1);
    CachedTargets[] j3dCTs = null;
    CachedTargets[] cachedTargets = null;
    int localTargetThreads = 0;
    int targetThreads = 0;
    ArrayList<SwitchState> switchStates = null;

    SharedGroupRetained() {
        this.nodeType = 22;
    }

    @Override
    void setAuxData(SetLiveState s, int index, int hkIndex) {
        super.setAuxData(s, index, hkIndex);
        this.branchGroupPaths.add(hkIndex, s.branchGroupPaths.get(index));
        if (this.orderedPaths == null) {
            this.orderedPaths = new ArrayList(1);
        }
        this.orderedPaths.add(hkIndex, s.orderedPaths.get(index));
        if (this.switchStates == null) {
            this.switchStates = new ArrayList(1);
        }
        this.switchStates.add(hkIndex, s.switchStates.get(index));
        if (this.viewLists == null) {
            this.viewLists = new ArrayList(1);
        }
        if (s.viewLists != null) {
            this.viewLists.add(hkIndex, s.viewLists.get(index));
        } else {
            this.viewLists.add(hkIndex, null);
        }
        if (this.lights == null) {
            this.lights = new ArrayList(1);
        }
        if (s.lights != null) {
            this.lights.add(hkIndex, s.lights.get(index));
        } else {
            this.lights.add(hkIndex, null);
        }
        if (this.fogs == null) {
            this.fogs = new ArrayList(1);
        }
        if (s.fogs != null) {
            this.fogs.add(hkIndex, s.fogs.get(index));
        } else {
            this.fogs.add(hkIndex, null);
        }
        if (this.modelClips == null) {
            this.modelClips = new ArrayList(1);
        }
        if (s.modelClips != null) {
            this.modelClips.add(hkIndex, s.modelClips.get(index));
        } else {
            this.modelClips.add(hkIndex, null);
        }
        if (this.altAppearances == null) {
            this.altAppearances = new ArrayList(1);
        }
        if (s.altAppearances != null) {
            this.altAppearances.add(hkIndex, s.altAppearances.get(index));
        } else {
            this.altAppearances.add(hkIndex, null);
        }
    }

    @Override
    void setNodeData(SetLiveState s) {
        int len;
        if (this.localToVworld == null) {
            this.localToVworld = new Transform3D[s.keys.length][];
            this.localToVworldIndex = new int[s.keys.length][];
            this.localToVworldKeys = new HashKey[s.keys.length];
            this.cachedTargets = new CachedTargets[s.keys.length];
            len = 0;
        } else {
            int newLen = this.localToVworld.length + s.keys.length;
            Transform3D[][] newTList = new Transform3D[newLen][];
            HashKey[] newHList = new HashKey[newLen];
            int[][] newIndexList = new int[newLen][];
            CachedTargets[] newTargets = new CachedTargets[newLen];
            len = this.localToVworld.length;
            System.arraycopy(this.localToVworld, 0, newTList, 0, this.localToVworld.length);
            System.arraycopy(this.localToVworldIndex, 0, newIndexList, 0, this.localToVworldIndex.length);
            System.arraycopy(this.localToVworldKeys, 0, newHList, 0, this.localToVworldKeys.length);
            System.arraycopy(this.cachedTargets, 0, newTargets, 0, this.cachedTargets.length);
            this.localToVworld = newTList;
            this.localToVworldIndex = newIndexList;
            this.localToVworldKeys = newHList;
            this.cachedTargets = newTargets;
        }
        int[] hkIndex = new int[1];
        s.hashkeyIndex = new int[s.keys.length];
        s.parentBranchGroupPaths = this.branchGroupPaths;
        int i = len;
        int j = 0;
        while (i < this.localToVworld.length) {
            if (s.keys[j].equals(this.localToVworldKeys, hkIndex, 0, i)) {
                MasterControl.getCoreLogger().severe("Found matching hashKey in setNodeData.");
            }
            s.hashkeyIndex[j] = hkIndex[0];
            if (hkIndex[0] == i) {
                this.localToVworldKeys[i] = s.keys[j];
                this.localToVworld[i] = s.currentTransforms[j];
                this.localToVworldIndex[i] = s.currentTransformsIndex[j];
            } else {
                int hkIndexPlus1 = hkIndex[0] + 1;
                int blkSize = i - hkIndex[0];
                System.arraycopy(this.localToVworldKeys, hkIndex[0], this.localToVworldKeys, hkIndexPlus1, blkSize);
                System.arraycopy(this.localToVworld, hkIndex[0], this.localToVworld, hkIndexPlus1, blkSize);
                System.arraycopy(this.localToVworldIndex, hkIndex[0], this.localToVworldIndex, hkIndexPlus1, blkSize);
                System.arraycopy(this.cachedTargets, hkIndex[0], this.cachedTargets, hkIndexPlus1, blkSize);
                this.localToVworldKeys[hkIndex[0]] = s.keys[j];
                this.localToVworld[hkIndex[0]] = s.currentTransforms[j];
                this.localToVworldIndex[hkIndex[0]] = s.currentTransformsIndex[j];
            }
            this.setAuxData(s, j, hkIndex[0]);
            ++i;
            ++j;
        }
        s.localToVworld = this.localToVworld;
        s.localToVworldIndex = this.localToVworldIndex;
        s.localToVworldKeys = this.localToVworldKeys;
        s.orderedPaths = this.orderedPaths;
        s.switchStates = this.switchStates;
        s.childTransformLinks = this.childTransformLinks;
        s.parentTransformLink = this;
        s.parentSwitchLink = this;
        s.viewLists = this.viewLists;
        s.lights = this.lights;
        s.fogs = this.fogs;
        s.altAppearances = this.altAppearances;
        s.modelClips = this.modelClips;
    }

    @Override
    void setLive(SetLiveState s) {
        int i;
        Targets[] newTargets = null;
        Transform3D[][] savedLocalToVworld = s.localToVworld;
        int[][] savedLocalToVworldIndex = s.localToVworldIndex;
        HashKey[] savedLocalToVworldKeys = s.localToVworldKeys;
        ArrayList<OrderedPath> savedOrderedPaths = s.orderedPaths;
        ArrayList<ArrayList<View>> savedViewList = s.viewLists;
        ArrayList<ArrayList<LightRetained>> savedLights = s.lights;
        ArrayList<ArrayList<FogRetained>> savedFogs = s.fogs;
        ArrayList<ArrayList<ModelClipRetained>> savedMclips = s.modelClips;
        ArrayList<ArrayList<AlternateAppearanceRetained>> savedAltApps = s.altAppearances;
        SharedGroupRetained savedLastSharedGroup = s.lastSharedGroup;
        Targets[] savedSwitchTargets = s.switchTargets;
        ArrayList<SwitchState> savedSwitchStates = s.switchStates;
        ArrayList<NodeRetained> savedChildSwitchLinks = s.childSwitchLinks;
        GroupRetained savedParentSwitchLink = s.parentSwitchLink;
        ArrayList<NodeRetained> savedChildTransformLinks = s.childTransformLinks;
        GroupRetained savedParentTransformLink = s.parentTransformLink;
        int[] savedHashkeyIndex = s.hashkeyIndex;
        s.lastSharedGroup = this;
        Targets[] savedTransformTargets = s.transformTargets;
        int numPaths = s.keys.length;
        newTargets = new Targets[numPaths];
        for (i = 0; i < numPaths; ++i) {
            newTargets[i] = s.transformLevels[i] >= 0 ? new Targets() : null;
        }
        s.transformTargets = newTargets;
        super.setLive(s);
        for (i = 0; i < numPaths; ++i) {
            if (s.transformTargets[i] == null) continue;
            int hkIndex = s.hashkeyIndex[i];
            this.cachedTargets[hkIndex] = s.transformTargets[i].snapShotInit();
        }
        this.j3dCTs = new CachedTargets[this.cachedTargets.length];
        this.copyCachedTargets(0, this.j3dCTs);
        this.computeTargetThreads(0, this.cachedTargets);
        s.localToVworld = savedLocalToVworld;
        s.localToVworldIndex = savedLocalToVworldIndex;
        s.localToVworldKeys = savedLocalToVworldKeys;
        s.orderedPaths = savedOrderedPaths;
        s.viewLists = savedViewList;
        s.lights = savedLights;
        s.fogs = savedFogs;
        s.modelClips = savedMclips;
        s.altAppearances = savedAltApps;
        s.lastSharedGroup = savedLastSharedGroup;
        s.switchTargets = savedSwitchTargets;
        s.switchStates = savedSwitchStates;
        s.childSwitchLinks = savedChildSwitchLinks;
        s.parentSwitchLink = savedParentSwitchLink;
        s.childTransformLinks = savedChildTransformLinks;
        s.parentTransformLink = savedParentTransformLink;
        s.transformTargets = savedTransformTargets;
        s.hashkeyIndex = savedHashkeyIndex;
    }

    @Override
    void removeNodeData(SetLiveState s) {
        if (this.refCount <= 0) {
            this.localToVworld = null;
            this.localToVworldIndex = null;
            this.localToVworldKeys = null;
            this.branchGroupPaths = new ArrayList(1);
            this.orderedPaths = null;
            this.switchStates = null;
            this.cachedTargets = null;
            this.targetThreads = 0;
            this.lights.clear();
            this.fogs.clear();
            this.modelClips.clear();
            this.altAppearances.clear();
        } else {
            int len;
            int i;
            int newLen = this.localToVworld.length - s.keys.length;
            Transform3D[][] newTList = new Transform3D[newLen][];
            HashKey[] newHList = new HashKey[newLen];
            Transform3D[][] newChildTList = null;
            int[][] newIndexList = new int[newLen][];
            CachedTargets[] newTargets = new CachedTargets[newLen];
            int[] tempIndex = new int[s.keys.length];
            int curStart = 0;
            int newStart = 0;
            boolean found = false;
            for (i = 0; i < s.keys.length; ++i) {
                int index;
                tempIndex[i] = index = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (index >= 0) {
                    found = true;
                    if (index == curStart) {
                        ++curStart;
                        continue;
                    }
                    len = index - curStart;
                    System.arraycopy(this.localToVworld, curStart, newTList, newStart, len);
                    System.arraycopy(this.localToVworldIndex, curStart, newIndexList, newStart, len);
                    System.arraycopy(this.localToVworldKeys, curStart, newHList, newStart, len);
                    System.arraycopy(this.cachedTargets, curStart, newTargets, newStart, len);
                    curStart = index + 1;
                    newStart += len;
                    continue;
                }
                found = false;
                MasterControl.getCoreLogger().severe("Can't Find matching hashKey in SG.removeNodeData.");
            }
            if (found && curStart < this.localToVworld.length) {
                len = this.localToVworld.length - curStart;
                System.arraycopy(this.localToVworld, curStart, newTList, newStart, len);
                System.arraycopy(this.localToVworldIndex, curStart, newIndexList, newStart, len);
                System.arraycopy(this.localToVworldKeys, curStart, newHList, newStart, len);
                System.arraycopy(this.cachedTargets, curStart, newTargets, newStart, len);
            }
            for (i = tempIndex.length - 1; i >= 0; --i) {
                if (tempIndex[i] < 0) continue;
                this.branchGroupPaths.remove(tempIndex[i]);
                this.orderedPaths.remove(tempIndex[i]);
                this.switchStates.remove(tempIndex[i]);
                this.lights.remove(tempIndex[i]);
                this.fogs.remove(tempIndex[i]);
                this.modelClips.remove(tempIndex[i]);
                this.altAppearances.remove(tempIndex[i]);
            }
            this.localToVworld = newTList;
            this.localToVworldIndex = newIndexList;
            this.localToVworldKeys = newHList;
            this.cachedTargets = newTargets;
        }
        s.localToVworld = this.localToVworld;
        s.localToVworldIndex = this.localToVworldIndex;
        s.localToVworldKeys = this.localToVworldKeys;
        s.orderedPaths = this.orderedPaths;
        s.switchStates = this.switchStates;
        s.viewLists = this.viewLists;
        s.lights = this.lights;
        s.fogs = this.fogs;
        s.modelClips = this.modelClips;
        s.altAppearances = this.altAppearances;
    }

    @Override
    void clearLive(SetLiveState s) {
        int i;
        Transform3D[][] savedLocalToVworld = s.localToVworld;
        int[][] savedLocalToVworldIndex = s.localToVworldIndex;
        HashKey[] savedLocalToVworldKeys = s.localToVworldKeys;
        ArrayList<OrderedPath> savedOrderedPaths = s.orderedPaths;
        ArrayList<ArrayList<View>> savedViewLists = s.viewLists;
        ArrayList<ArrayList<LightRetained>> savedLights = s.lights;
        ArrayList<ArrayList<FogRetained>> savedFogs = s.fogs;
        ArrayList<ArrayList<ModelClipRetained>> savedMclips = s.modelClips;
        ArrayList<ArrayList<AlternateAppearanceRetained>> savedAltApps = s.altAppearances;
        Targets[] savedSwitchTargets = s.switchTargets;
        Targets[] savedTransformTargets = s.transformTargets;
        s.transformTargets = null;
        s.switchTargets = null;
        int[] tempIndex = null;
        if (s.keys.length != this.localToVworld.length) {
            tempIndex = new int[s.keys.length];
            for (i = s.keys.length - 1; i >= 0; --i) {
                tempIndex[i] = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            }
        }
        super.clearLive(s);
        if (this.refCount <= 0) {
            this.viewLists.clear();
        } else {
            for (i = tempIndex.length - 1; i >= 0; --i) {
                if (tempIndex[i] < 0) continue;
                this.viewLists.remove(tempIndex[i]);
            }
        }
        s.localToVworld = savedLocalToVworld;
        s.localToVworldIndex = savedLocalToVworldIndex;
        s.localToVworldKeys = savedLocalToVworldKeys;
        s.orderedPaths = savedOrderedPaths;
        s.viewLists = savedViewLists;
        s.lights = savedLights;
        s.fogs = savedFogs;
        s.modelClips = savedMclips;
        s.altAppearances = savedAltApps;
        s.transformTargets = savedTransformTargets;
        s.switchTargets = savedSwitchTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(HashKey key, int index, ArrayList<TransformGroupRetained> dirtyTransformGroups, ArrayList keySet, UpdateTargets targets, ArrayList blUsers) {
        CachedTargets ct = this.j3dCTs[index];
        if (ct != null) {
            targets.addCachedTargets(ct);
            if (ct.targetArr[5] != null) {
                SharedGroupRetained.gatherBlUsers(blUsers, ct.targetArr[5]);
            }
        }
        ArrayList<NodeRetained> arrayList = this.childTransformLinks;
        synchronized (arrayList) {
            for (int i = 0; i < this.childTransformLinks.size(); ++i) {
                NodeRetained obj = this.childTransformLinks.get(i);
                if (obj instanceof TransformGroupRetained) {
                    TransformGroupRetained tg = (TransformGroupRetained)obj;
                    tg.updateChildLocalToVworld(tg.localToVworldKeys[index], index, dirtyTransformGroups, keySet, targets, blUsers);
                    continue;
                }
                LinkRetained ln = (LinkRetained)obj;
                this.currentKey.set(key);
                this.currentKey.append(LinkRetained.plus).append(ln.nodeId);
                if (ln.sharedGroup.localToVworldKeys == null) continue;
                int j = this.currentKey.equals(ln.sharedGroup.localToVworldKeys, 0, ln.sharedGroup.localToVworldKeys.length);
                if (j < 0) {
                    System.err.println("SharedGroupRetained : Can't find hashKey");
                }
                if (j >= ln.sharedGroup.localToVworldKeys.length) continue;
                ln.sharedGroup.updateChildLocalToVworld(ln.sharedGroup.localToVworldKeys[j], j, dirtyTransformGroups, keySet, targets, blUsers);
            }
        }
    }

    void traverseSwitchChild(int child, HashKey key, int index, SwitchRetained switchRoot, boolean init, boolean swChanged, boolean switchOn, int switchLevel, ArrayList<SwitchState> updateList) {
        ArrayList childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(child);
        for (int i = 0; i < childSwitchLinks.size(); ++i) {
            int j;
            Object obj = childSwitchLinks.get(i);
            if (obj instanceof SwitchRetained) {
                SwitchRetained sw = (SwitchRetained)obj;
                for (j = 0; j < sw.children.size(); ++j) {
                    sw.traverseSwitchChild(j, key, index, switchRoot, init, swChanged, switchOn, switchLevel, updateList);
                }
                continue;
            }
            LinkRetained ln = (LinkRetained)obj;
            this.switchKey.set(key);
            this.switchKey.append(LinkRetained.plus).append(ln.nodeId);
            if (ln.sharedGroup.localToVworldKeys == null) continue;
            j = this.switchKey.equals(ln.sharedGroup.localToVworldKeys, 0, ln.sharedGroup.localToVworldKeys.length);
            if (j < 0) {
                System.err.println("SharedGroupRetained : Can't find hashKey");
            }
            if (j >= ln.sharedGroup.localToVworldKeys.length) continue;
            for (int k = 0; k < ln.sharedGroup.children.size(); ++k) {
                ln.sharedGroup.traverseSwitchChild(k, ln.sharedGroup.localToVworldKeys[j], j, switchRoot, init, swChanged, switchOn, switchLevel, updateList);
            }
        }
    }

    void traverseSwitchParent() {
        for (int i = 0; i < this.parents.size(); ++i) {
            NodeRetained ln = this.parents.get(i);
            if (ln.parentSwitchLink == null) continue;
            if (this.parentSwitchLink instanceof SwitchRetained) {
                ((SwitchRetained)this.parentSwitchLink).traverseSwitchParent();
                continue;
            }
            if (!(this.parentSwitchLink instanceof SharedGroupRetained)) continue;
            ((SharedGroupRetained)this.parentSwitchLink).traverseSwitchParent();
        }
    }

    void compile() {
        if (this.source.isCompiled() || VirtualUniverse.mc.disableCompile) {
            return;
        }
        if (J3dDebug.debug) {
            J3dDebug.doDebug(3, 3, "SharedGroupRetained.compile()....\n");
        }
        CompileState compState = new CompileState();
        this.isRoot = true;
        this.compile(compState);
        this.merge(compState);
        if (J3dDebug.debug) {
            if (J3dDebug.doDebug(3, 3)) {
                compState.printStats();
            }
            if (J3dDebug.doDebug(3, 5)) {
                this.traverse(false, 1);
                System.err.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Link[] getLinks() {
        Link[] links;
        Vector<NodeRetained> vector = this.parents;
        synchronized (vector) {
            int n = this.parents.size();
            links = new Link[n];
            for (int i = 0; i < n; ++i) {
                links[i] = (Link)((LinkRetained)this.parents.elementAt((int)i)).source;
            }
        }
        return links;
    }

    @Override
    void insertChildrenData(int index) {
        if (this.childrenSwitchLinks == null) {
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(index, new ArrayList(1));
    }

    @Override
    void appendChildrenData() {
        if (this.childrenSwitchLinks == null) {
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(new ArrayList(1));
    }

    @Override
    void removeChildrenData(int index) {
        ArrayList oldSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(index);
        oldSwitchLinks.clear();
        this.childrenSwitchLinks.remove(index);
    }

    @Override
    public int getTargetThreads(int type) {
        if (type == 0) {
            return this.targetThreads;
        }
        System.err.println("getTargetThreads: wrong arguments");
        return -1;
    }

    @Override
    TargetsInterface getClosestTargetsInterface(int type) {
        return this;
    }

    @Override
    public void computeTargetThreads(int type, CachedTargets[] newCachedTargets) {
        this.localTargetThreads = 0;
        if (type == 0) {
            for (int i = 0; i < newCachedTargets.length; ++i) {
                if (newCachedTargets[i] == null) continue;
                this.localTargetThreads |= newCachedTargets[i].computeTargetThreads();
            }
            this.targetThreads = this.localTargetThreads;
            int numLinks = this.childTransformLinks.size();
            for (int i = 0; i < numLinks; ++i) {
                NodeRetained node = this.childTransformLinks.get(i);
                TargetsInterface childLink = node.nodeType == 9 ? ((LinkRetained)node).sharedGroup : (TargetsInterface)((Object)node);
                if (childLink == null) continue;
                this.targetThreads |= childLink.getTargetThreads(0);
            }
        } else {
            System.err.println("computeTargetsThreads: wrong arguments");
        }
    }

    @Override
    public void updateTargetThreads(int type, CachedTargets[] newCachedTargets) {
        if (type == 0) {
            this.computeTargetThreads(type, newCachedTargets);
            if (this.parentTransformLink != null) {
                TargetsInterface pti = (TargetsInterface)((Object)this.parentTransformLink);
                pti.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.err.println("updateTargetThreads: wrong arguments");
        }
    }

    @Override
    public void propagateTargetThreads(int type, int childTargetThreads) {
        if (type == 0) {
            this.targetThreads |= childTargetThreads;
            for (int i = 0; i < this.parents.size(); ++i) {
                LinkRetained ln = (LinkRetained)this.parents.elementAt(i);
                if (ln.parentTransformLink == null) continue;
                TargetsInterface pti = (TargetsInterface)((Object)ln.parentTransformLink);
                pti.propagateTargetThreads(type, this.targetThreads);
            }
        } else {
            System.err.println("propagateTargetThreads: wrong arguments");
        }
    }

    @Override
    public void updateCachedTargets(int type, CachedTargets[] newCt) {
        if (type == 0) {
            this.j3dCTs = newCt;
        } else {
            System.err.println("updateCachedTargets: wrong arguments");
        }
    }

    @Override
    public void copyCachedTargets(int type, CachedTargets[] newCt) {
        if (type == 0) {
            for (CachedTargets newCt[i] : this.cachedTargets) {
            }
        } else {
            System.err.println("copyCachedTargets: wrong arguments");
        }
    }

    @Override
    public CachedTargets getCachedTargets(int type, int index, int child) {
        if (type == 1) {
            if (index < this.switchStates.size()) {
                SwitchState switchState = this.switchStates.get(index);
                return switchState.cachedTargets;
            }
            return null;
        }
        return this.cachedTargets[index];
    }

    @Override
    public void resetCachedTargets(int type, CachedTargets[] newCtArr, int child) {
        if (type == 1) {
            if (newCtArr.length != this.switchStates.size()) {
                System.err.println("resetCachedTargets: unmatched length!" + newCtArr.length + " " + this.switchStates.size());
                System.err.println("  resetCachedTargets: " + this);
            }
            for (int i = 0; i < newCtArr.length; ++i) {
                SwitchState switchState = this.switchStates.get(i);
                switchState.cachedTargets = newCtArr[i];
            }
        } else {
            this.cachedTargets = newCtArr;
        }
    }

    @Override
    public ArrayList<SwitchState> getTargetsData(int type, int index) {
        if (type == 1) {
            return this.switchStates;
        }
        System.err.println("getTargetsData: wrong arguments");
        return null;
    }

    @Override
    void childDoSetLive(NodeRetained child, int childIndex, SetLiveState s) {
        s.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(childIndex);
        s.switchStates = this.switchStates;
        if (child != null) {
            child.setLive(s);
        }
    }

    void childCheckSetLive(NodeRetained child, int childIndex, SetLiveState s) {
        s.childTransformLinks = this.childTransformLinks;
        s.parentTransformLink = this;
        child.setLive(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dirtyBoundsCache() {
        if (VirtualUniverse.mc.cacheAutoComputedBounds) {
            this.validCachedBounds = false;
            Vector<NodeRetained> vector = this.parents;
            synchronized (vector) {
                Enumeration<NodeRetained> e = this.parents.elements();
                while (e.hasMoreElements()) {
                    LinkRetained parent = (LinkRetained)e.nextElement();
                    if (parent == null) continue;
                    parent.dirtyBoundsCache();
                }
            }
        }
    }
}

