/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2DRetained;
import javax.vecmath.Point2f;

public class Texture2D
extends Texture {
    public static final int ALLOW_DETAIL_TEXTURE_READ = 15;
    public static final int LINEAR_DETAIL = 6;
    public static final int LINEAR_DETAIL_RGB = 7;
    public static final int LINEAR_DETAIL_ALPHA = 8;
    public static final int DETAIL_ADD = 0;
    public static final int DETAIL_MODULATE = 1;
    private static final int[] readCapabilities = new int[]{15};

    public Texture2D() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Texture2D(int mipMapMode, int format, int width, int height) {
        super(mipMapMode, format, width, height);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Texture2D(int mipMapMode, int format, int width, int height, int boundaryWidth) {
        super(mipMapMode, format, width, height, boundaryWidth);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    @Override
    public void setMagFilter(int magFilter) {
        this.checkForLiveOrCompiled();
        switch (magFilter) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture29"));
            }
        }
        ((Texture2DRetained)this.retained).initMagFilter(magFilter);
    }

    public void setDetailImage(ImageComponent2D detailTexture) {
        this.checkForLiveOrCompiled();
        ((Texture2DRetained)this.retained).initDetailImage(detailTexture);
    }

    public ImageComponent2D getDetailImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailImage();
    }

    public void setDetailTextureMode(int mode) {
        this.checkForLiveOrCompiled();
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture2D1"));
        }
        ((Texture2DRetained)this.retained).initDetailTextureMode(mode);
    }

    public int getDetailTextureMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailTextureMode();
    }

    public void setDetailTextureLevel(int level) {
        this.checkForLiveOrCompiled();
        if (level < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture2D2"));
        }
        ((Texture2DRetained)this.retained).initDetailTextureLevel(level);
    }

    public int getDetailTextureLevel() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailTextureLevel();
    }

    public void setDetailTextureFunc(float[] lod, float[] pts) {
        this.checkForLiveOrCompiled();
        if (!(lod != null && pts != null && lod.length == pts.length || lod == null && pts == null)) {
            throw new IllegalStateException(J3dI18N.getString("Texture2D3"));
        }
        ((Texture2DRetained)this.retained).initDetailTextureFunc(lod, pts);
    }

    public void setDetailTextureFunc(Point2f[] pts) {
        this.checkForLiveOrCompiled();
        ((Texture2DRetained)this.retained).initDetailTextureFunc(pts);
    }

    public int getDetailTextureFuncPointsCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailTextureFuncPointsCount();
    }

    public void getDetailTextureFunc(float[] lod, float[] pts) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        ((Texture2DRetained)this.retained).getDetailTextureFunc(lod, pts);
    }

    public void getDetailTextureFunc(Point2f[] pts) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        ((Texture2DRetained)this.retained).getDetailTextureFunc(pts);
    }

    @Override
    void createRetained() {
        this.retained = new Texture2DRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        Texture2DRetained t2d = (Texture2DRetained)this.retained;
        Texture2D t = new Texture2D(t2d.getMipMapMode(), t2d.format, t2d.width, t2d.height);
        t.duplicateNodeComponent(this);
        return t;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        Texture2DRetained tex = (Texture2DRetained)originalNodeComponent.retained;
        Texture2DRetained rt = (Texture2DRetained)this.retained;
        rt.initDetailImage(tex.getDetailImage());
        rt.initDetailTextureMode(tex.getDetailTextureMode());
        rt.initDetailTextureLevel(tex.getDetailTextureLevel());
        rt.initDetailTextureFunc(tex.getDetailTextureFunc());
    }
}

