/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureCubeMapRetained;

public class TextureCubeMap
extends Texture {
    public static final int POSITIVE_X = 0;
    public static final int NEGATIVE_X = 1;
    public static final int POSITIVE_Y = 2;
    public static final int NEGATIVE_Y = 3;
    public static final int POSITIVE_Z = 4;
    public static final int NEGATIVE_Z = 5;

    public TextureCubeMap() {
    }

    public TextureCubeMap(int mipmapMode, int format, int width) {
        super(mipmapMode, format, width, width);
    }

    public TextureCubeMap(int mipmapMode, int format, int width, int boundaryWidth) {
        super(mipmapMode, format, width, width, boundaryWidth);
    }

    public void setImage(int level, int face, ImageComponent2D image) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap1"));
        }
        this.validateImageIllegalSharing(image);
        if (this.isLive()) {
            ((TextureCubeMapRetained)this.retained).setImage(level, face, image);
        } else {
            ((TextureCubeMapRetained)this.retained).initImage(level, face, image);
        }
    }

    public void setImages(int face, ImageComponent2D[] images) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap1"));
        }
        for (int i = 0; i < images.length; ++i) {
            this.validateImageIllegalSharing(images[i]);
        }
        if (this.isLive()) {
            ((TextureCubeMapRetained)this.retained).setImages(face, images);
        } else {
            ((TextureCubeMapRetained)this.retained).initImages(face, images);
        }
    }

    public ImageComponent getImage(int level, int face) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap2"));
        }
        return ((TextureCubeMapRetained)this.retained).getImage(level, face);
    }

    public ImageComponent[] getImages(int face) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap2"));
        }
        return ((TextureCubeMapRetained)this.retained).getImages(face);
    }

    @Override
    public void setImage(int level, ImageComponent image) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setImages(ImageComponent[] images) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImageComponent getImage(int level) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImageComponent[] getImages() {
        throw new UnsupportedOperationException();
    }

    @Override
    void createRetained() {
        this.retained = new TextureCubeMapRetained();
        this.retained.setSource(this);
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }
}

