/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BHLeafInterface;
import org.scijava.java3d.BehaviorRetained;
import org.scijava.java3d.BehaviorStructure;
import org.scijava.java3d.BoundingLeafRetained;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.GroupRetained;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.MorphRetained;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.Shape3DRetained;
import org.scijava.java3d.UnorderList;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupIndexedList;
import org.scijava.java3d.WakeupOnCollisionEntry;

public final class WakeupOnCollisionExit
extends WakeupCriterion {
    static final int COND_IN_GS_LIST = 0;
    static final int COLLIDEEXIT_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    public static final int USE_GEOMETRY = 10;
    public static final int USE_BOUNDS = 11;
    int accuracyMode;
    NodeRetained armingNode;
    Bounds vwcBounds;
    Bounds localBounds = null;
    BoundingLeafRetained boundingLeaf = null;
    UnorderList geometryAtoms = null;
    int nodeType;
    SceneGraphPath armingPath = null;
    Bounds armingBounds = null;
    SceneGraphPath collidingPath = null;
    Bounds collidingBounds = null;

    public WakeupOnCollisionExit(SceneGraphPath armingPath) {
        this(armingPath, 11);
    }

    public WakeupOnCollisionExit(SceneGraphPath armingPath, int speedHint) {
        this(new SceneGraphPath(armingPath), speedHint, null);
    }

    public WakeupOnCollisionExit(Node armingNode) {
        this(armingNode, 11);
    }

    public WakeupOnCollisionExit(Node armingNode, int speedHint) {
        this(new SceneGraphPath(null, armingNode), speedHint, null);
    }

    public WakeupOnCollisionExit(Bounds armingBounds) {
        this(null, 11, (Bounds)armingBounds.clone());
    }

    WakeupOnCollisionExit(SceneGraphPath armingPath, int speedHint, Bounds armingBounds) {
        if (armingPath != null) {
            this.armingNode = (NodeRetained)armingPath.getObject().retained;
            this.nodeType = WakeupOnCollisionEntry.getNodeType(this.armingNode, armingPath, "WakeupOnCollisionExit");
            this.armingPath = armingPath;
            WakeupOnCollisionEntry.validateSpeedHint(speedHint, "WakeupOnCollisionExit4");
        } else {
            this.armingBounds = armingBounds;
            this.nodeType = 0;
        }
        this.accuracyMode = speedHint;
        WakeupIndexedList.init(this, 2);
    }

    public SceneGraphPath getArmingPath() {
        return this.armingPath != null ? new SceneGraphPath(this.armingPath) : null;
    }

    public Bounds getArmingBounds() {
        return this.armingBounds != null ? (Bounds)this.armingBounds.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphPath getTriggeringPath() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit5"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit5"));
            }
        }
        return this.collidingPath != null ? new SceneGraphPath(this.collidingPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds getTriggeringBounds() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit6"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit6"));
            }
        }
        return this.collidingBounds != null ? (Bounds)this.collidingBounds.clone() : null;
    }

    @Override
    void addBehaviorCondition(BehaviorStructure bs) {
        switch (this.nodeType) {
            case 11: 
            case 28: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                Shape3DRetained shape = (Shape3DRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(shape.getMirrorShape(this.armingPath)));
                break;
            }
            case 10: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                MorphRetained morph = (MorphRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(morph.getMirrorShape(this.armingPath)));
                break;
            }
            case 25: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                this.boundingLeaf = ((BoundingLeafRetained)this.armingNode).mirrorBoundingLeaf;
                break;
            }
            case 0: {
                this.vwcBounds = (Bounds)this.armingBounds.clone();
                this.armingNode = this.behav;
                break;
            }
            case 23: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.accuracyMode != 10) break;
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
            }
        }
        this.behav.universe.geometryStructure.addWakeupOnCollision(this);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure bs) {
        this.vwcBounds = null;
        if (this.geometryAtoms != null) {
            this.geometryAtoms.clear();
        }
        this.boundingLeaf = null;
        this.behav.universe.geometryStructure.removeWakeupOnCollision(this);
    }

    void setTarget(BHLeafInterface leaf) {
        Bounds bound;
        SceneGraphPath path;
        if (leaf instanceof GeometryAtom) {
            GeometryAtom geomAtom = (GeometryAtom)leaf;
            Shape3DRetained shape = geomAtom.source;
            path = WakeupOnCollisionEntry.getSceneGraphPath(shape.sourceNode, shape.key, shape.getCurrentLocalToVworld(0));
            bound = WakeupOnCollisionEntry.getTriggeringBounds(shape);
        } else {
            GroupRetained group = (GroupRetained)leaf;
            path = WakeupOnCollisionEntry.getSceneGraphPath(group);
            bound = WakeupOnCollisionEntry.getTriggeringBounds(group);
        }
        if (path != null) {
            this.collidingPath = path;
            this.collidingBounds = bound;
        }
    }

    void updateCollisionBounds(boolean reEvaluateGAs) {
        if (this.nodeType == 23) {
            GroupRetained group = (GroupRetained)this.armingNode;
            this.vwcBounds = group.collisionBound != null ? (Bounds)group.collisionBound.clone() : group.getEffectiveBounds();
            group.transformBounds(this.armingPath, this.vwcBounds);
        } else if (this.nodeType == 0) {
            this.vwcBounds.transform(this.armingBounds, this.behav.getCurrentLocalToVworld());
        }
        if (reEvaluateGAs && this.nodeType == 23 && this.accuracyMode == 10) {
            this.geometryAtoms.clear();
            ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
        }
    }

    @Override
    void setTriggered() {
        if (this.collidingPath != null) {
            super.setTriggered();
        }
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure bs) {
    }
}

