/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.ClassUtils;
import org.scijava.util.ClassUtilsTest;
import org.scijava.util.GenericUtils;

public class GenericUtilsTest {
    @Test
    public void testGetClass() {
        class Struct {
            private int[] intArray;
            private double d;
            private String[][] strings;
            private Void v;
            private List<String> list;
            private HashMap<Integer, Float> map;

            Struct() {
            }
        }
        Assert.assertSame(int[].class, this.getClass(Struct.class, "intArray"));
        Assert.assertSame(Double.TYPE, this.getClass(Struct.class, "d"));
        Assert.assertSame(String[][].class, this.getClass(Struct.class, "strings"));
        Assert.assertSame(Void.class, this.getClass(Struct.class, "v"));
        Assert.assertSame(List.class, this.getClass(Struct.class, "list"));
        Assert.assertSame(HashMap.class, this.getClass(Struct.class, "map"));
    }

    @Test
    public void testGetComponentClass() {
        class Struct {
            private int[] intArray;
            private double d;
            private String[][] strings;
            private Void v;
            private List<String>[] list;
            private HashMap<Integer, Float> map;

            Struct() {
            }
        }
        Assert.assertSame(Integer.TYPE, this.getComponentClass(Struct.class, "intArray"));
        Assert.assertNull(this.getComponentClass(Struct.class, "d"));
        Assert.assertSame(String[].class, this.getComponentClass(Struct.class, "strings"));
        Assert.assertSame(null, this.getComponentClass(Struct.class, "v"));
        Assert.assertSame(List.class, this.getComponentClass(Struct.class, "list"));
        Assert.assertSame(null, this.getComponentClass(Struct.class, "map"));
    }

    @Test
    public void testGetFieldClasses() {
        Field field = ClassUtils.getField(ClassUtilsTest.Thing.class, (String)"thing");
        Type tType = GenericUtils.getFieldType((Field)field, ClassUtilsTest.Thing.class);
        Assert.assertEquals((Object)"capture of ?", (Object)tType.toString());
        Type nType = GenericUtils.getFieldType((Field)field, ClassUtilsTest.NumberThing.class);
        Assert.assertEquals((Object)"capture of ?", (Object)nType.toString());
        Type iType = GenericUtils.getFieldType((Field)field, ClassUtilsTest.IntegerThing.class);
        Assert.assertSame(Integer.class, (Object)iType);
    }

    @Test
    public void testGetGenericType() {
        Field field = ClassUtils.getField(ClassUtilsTest.Thing.class, (String)"thing");
        this.assertAllTheSame(GenericUtils.getFieldClasses((Field)field, ClassUtilsTest.Thing.class), Object.class);
        this.assertAllTheSame(GenericUtils.getFieldClasses((Field)field, ClassUtilsTest.NumberThing.class), Number.class);
        this.assertAllTheSame(GenericUtils.getFieldClasses((Field)field, ClassUtilsTest.IntegerThing.class), Integer.class);
        this.assertAllTheSame(GenericUtils.getFieldClasses((Field)field, ClassUtilsTest.ComplexThing.class), Serializable.class, Cloneable.class);
    }

    private Type type(Class<?> c, String fieldName) {
        return ClassUtils.getField(c, (String)fieldName).getGenericType();
    }

    private Class<?> getClass(Class<?> c, String fieldName) {
        return GenericUtils.getClass((Type)this.type(c, fieldName));
    }

    private Class<?> getComponentClass(Class<?> c, String fieldName) {
        return GenericUtils.getComponentClass((Type)this.type(c, fieldName));
    }

    private <T> void assertAllTheSame(List<T> list, T ... values) {
        Assert.assertEquals((long)list.size(), (long)values.length);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertSame(list.get(i), values[i]);
        }
    }
}

